// CIRCDRAW.C - General Circle Drawing

// Written by Phil Inch for Game Developers Magazine (issue 3).
// Contributed to the public domain.

// This program written and compiled with Borland C++ v3.1
// Compatibility with other compilers is not guaranteed.

// Usage of this program is subject to the disclaimer printed
// in the magazine.  You assume all risks associated with the use
// of this program.


#include <stdio.h>
#include <conio.h>
#include <time.h>
#include <dos.h>
#include <mem.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

const float PI = 3.1415927;
char far *screen=MK_FP(0xA000,0);

/* These arrays hold the floating point cos and sin values, as per the
"medium speed" example */
float FPCosArray[360], FPSinArray[360];

/* These arrays hold the integer cos and sin values, as per the "fast"
example */
int   INTCosArray[360], INTSinArray[360];

void	SetGraphicsMode( void ) {
	asm {
		mov	ax,0x13
    int	0x10
	  }
}

void	SetTextMode( void ) {
	asm {
  	mov	ax,0x03
    int	0x10;
    }
}

void SetPoint( int X, int Y, int C ) {
/* First we'll make sure the point is not off the screen */
  if ( X < 0 || X > 319 ) return;
  if ( Y < 0 || Y > 199 ) return;

/* and only if its on the screen will we draw it */
  *(screen+(Y*320)+X)=C;
}

/* Set up the floating point cos and sin arrays */
void LoadFPCosSinArrays(void) {
  int a;
  float radians;

  for ( a = 0; a < 360; a++ ) {
      radians = (float)a * PI / 180;
      FPCosArray[a] = cos(radians);
      FPSinArray[a] = sin(radians);
      }
}

/* Set up the integer cos and sin arrays */
void LoadINTCosSinArrays(void) {
  int a;
  float radians;

  for ( a = 0; a < 360; a++ ) {
      radians = (float)a * PI / 180;
      INTCosArray[a] = (int)(cos(radians) * 100);
      INTSinArray[a] = (int)(sin(radians) * 100);
      }
}

/* Slow circle drawing routine - lots of floating point */
void SlowCircDraw(int xc, int yc, int r, int color) {
  int x, y;
  float s;

  for ( s = 0; s < 2*PI; s+= PI/180 ) {
      x = xc + ( (float)r * cos(s) );
      y = yc + ( (float)r * sin(s) );
      SetPoint( x, y, color );
      }
}

/* Medium speed circle drawing routine - not as much floating point */
void MediumCircDraw(int xc, int yc, int r, int color) {
  int x, y;
  int s;

  for ( s = 0; s < 360; s++ ) {
      x = xc + ( (float)r * FPCosArray[s] );
      y = yc + ( (float)r * FPSinArray[s] );
      SetPoint( x, y, color );
      }
}

/* Fast circle drawing routine - very little floating point */
void FastCircDraw(int xc, int yc, int r, int color) {
  int x, y, s;

  for ( s = 0; s < 360; s++ ) {
      x = xc + ( ( r * INTCosArray[s] ) / 100 );
      y = yc + ( ( r * INTSinArray[s] ) / 100 );
      SetPoint( x, y, color );
      }
}

void main( void ) {
  char input[64];
  int xc,yc,r,c,d,number_of_circles;

  /* Set up the floating point cos and sin arrays */
  LoadFPCosSinArrays();

  /* Set up the integer cos and sin arrays */
  LoadINTCosSinArrays();

	clrscr();

	printf( "*** HOLLOW CIRCLE DRAWING DEMO ***\n\n" );
	printf( "Suggestions for number of circles:\n\n" );
	printf( "486/50:  2000\n" );
	printf( "486/33:  1000\n" );
	printf( "486/25:   750\n" );
	printf( "386/40:   100\n" );
	printf( "386/33:   100\n" );
	printf( "lower :    50\n\n" );

	printf( "Enter number of circles to draw: " );
	gets( input );

	number_of_circles = atol(input);
	if ( number_of_circles <= 0 ) {
		printf( "That's not a valid number!" );
		exit(1);
		}

  SetGraphicsMode();

  gotoxy( 18, 12 ); printf( "Slow" ); delay(3000);
  for ( d = 0; d < number_of_circles; d++ ) {
      xc = rand()%320;
      yc = rand()%200;
      r = rand()%50;
      c = rand()%255;
      SlowCircDraw(xc,yc,r,c);
      }

  SetGraphicsMode();  // quick way of clearing the graphics screen

  gotoxy( 18, 12 ); printf( "Medium" ); delay(3000);

  for ( d = 0; d < number_of_circles; d++ ) {
      xc = rand()%320;
      yc = rand()%200;
      r = rand()%50;
      c = rand()%255;
      MediumCircDraw(xc,yc,r,c);
      }

  SetGraphicsMode();  // quick way of clearing the graphics screen

  gotoxy( 18, 12 ); printf( "Fast" ); delay(3000);

  for ( d = 0; d < number_of_circles; d++ ) {
      xc = rand()%320;
      yc = rand()%200;
      r = rand()%50;
      c = rand()%255;
      FastCircDraw(xc,yc,r,c);
      }

  SetTextMode();
}





