// PALETTE.C - functions for programming the VGA colour palette.

// Written by Phil Inch for Game Developers Magazine (issue 3).
// Contributed to the public domain.

// This program written and compiled with Borland C++ v3.1
// Compatibility with other compilers is not guaranteed.

// Usage of this program is subject to the disclaimer printed
// in the magazine.  You assume all risks associated with the use
// of this program.

// Note that the ASM portions of this file are written to cope with the
// LARGE memory model only.

// Users of Trident and some other video cards will notice a lot of "noise"
// generated when the palette is modified.  This is a problem with the
// video card and not with this program.  It can be stopped by waiting for
// the VBI (vertical blanking interval) which will be explained in a later
// issue.


#include <stdio.h>
#include <dos.h>
#include <mem.h>

/* Set an individual palette register */

void	SetPal( char Pal, char Red, char Green, char Blue ) {
	asm {
    mov	dh, Red
    mov	ch, Green
    mov	cl, Blue
    mov	ax, 0x1010
    mov	bl, Pal
    int	0x10
    }
}


/* Set a block of 'Num' palette registers */

void	SetBlockPal( char Pal, char *Array, char Num ) {
  asm {
  	push es
    les di,Array
    mov dx,di
    xor	ch, ch
    mov	cl, Num
    mov ax, 0x1012
    xor	bh, bh
    mov	bl, Pal
    int	0x10
    pop	es
    }
}


/* Get an individual palette register */

void	GetPal( char Pal, char *Red, char *Green, char *Blue ) {
	asm {
    mov	ax, 0x1015
    mov	bl, Pal
    int	0x10
    }
    *Red   = _DH;
    *Green = _CH;
    *Blue  = _CL;
}


/* Get a block of 'Num' palette registers */

void	GetBlockPal( char Pal, char *Array, char Num ) {
  asm {
  	push 	es
    les di,Array
    mov dx,di
    xor	ch, ch
    mov	cl, Num
    mov	ax, 0x1017
    xor	bh, bh
    mov	bl, Pal
    int	0x10
    pop	es
    }
}


/* Fade in (from black) the specified palette */

void FadePaletteIn( char *Array ) {
  char tmpPal[768];
  int diff, c;

  memset( tmpPal, 0, 768 );

  do {
    delay(20); diff=0;
    SetBlockPal( 1, tmpPal, 255 );
    for ( c = 0; c < 765; c++ ) {
      if ( tmpPal[c] != Array[c] ) {
        tmpPal[c]++;
        diff++;
        }
      }
    } while (diff);
}


/* Fade out (to black) the current palette */

void FadePaletteOut( void ) {
  char tmpPal[768];
  int diff, c;

  GetBlockPal( 1, &(tmpPal[0]), 255 );

  do {
    diff = 0;
    delay(10);
    SetBlockPal( 1, &(tmpPal[0]), 255 );
    for ( c = 0; c < 765; c++ ) {
      if ( tmpPal[c] ) {
        tmpPal[c]--;
        diff++;
        }
      }
    } while (diff);
}
