// BOXDRAW.C - General Box Drawing

// Written by Phil Inch for Game Developers Magazine (issue 3).
// Contributed to the public domain.

// This program written and compiled with Borland C++ v3.1
// Compatibility with other compilers is not guaranteed.

// Usage of this program is subject to the disclaimer printed
// in the magazine.  You assume all risks associated with the use
// of this program.


#include <stdio.h>
#include <conio.h>
#include <time.h>
#include <dos.h>
#include <mem.h>
#include <string.h>
#include <stdlib.h>

char far *screen=MK_FP(0xA000,0);

void	SetGraphicsMode( void ) {
	asm {
		mov	ax,0x13
    int	0x10
	  }
}

void	SetTextMode( void ) {
	asm {
  	mov	ax,0x03
    int	0x10;
    }
}

void SetPoint( int X, int Y, int C ) {
  *(screen+(Y*320)+X)=C;
}

void SlowBoxDraw(int x1, int y1, int x2, int y2, int color) {
  int x,y;

  /* Top line */
  for ( x = x1; x < x2; x++ ) SetPoint( x, y1, color );

  /* Right line */
  for ( y = y1; y < y2; y++ ) SetPoint( x2, y, color );

  /* Bottom line */
  for ( x = x1; x < x2; x++ ) SetPoint( x, y2, color );

  /* Left line */
  for ( y = y1; y < y2; y++ ) SetPoint( x1, y, color );
}

void FastBoxDraw(int x1, int y1, int x2, int y2, int color) {
  int x,y;

  /* Top and bottom lines */
  for ( x = x1; x < x2; x++ ) {
      SetPoint( x, y1, color );
      SetPoint( x, y2, color );
      }

  /* Left and Right lines */
  for ( y = y1; y < y2; y++ ) {
      SetPoint( x1, y, color );
      SetPoint( x2, y, color );
      }
}

void main( void ) {
  char input[64];
  int x1,y1,x2,y2,c,d,number_of_boxes;

	clrscr();

	printf( "*** HOLLOW BOX DRAWING DEMO ***\n\n" );
	printf( "Suggestions for number of boxes:\n\n" );
	printf( "486/50:  25000\n" );
	printf( "486/33:  10000\n" );
	printf( "486/25:   5000\n" );
	printf( "386/40:    500\n" );
	printf( "386/33:    200\n" );
	printf( "lower :    100\n\n" );

	printf( "Enter number of boxes to draw: " );
	gets( input );

	number_of_boxes = atol(input);
	if ( number_of_boxes <= 0 ) {
		printf( "That's not a valid number!" );
		exit(1);
		}

  SetGraphicsMode();

  gotoxy( 18, 12 ); printf( "Slow" ); delay(3000);
  for ( d = 0; d < number_of_boxes; d++ ) {
      /* Make sure x1 < x2 */
      do {
         x1 = rand()%320; x2 = rand()%320;
      } while ( x1 >= x2 );

      /* Make sure y1 < y2 */
      do {
       y1 = rand()%200; y2 = rand()%200;
      } while ( y1 >= y2 );

      c = rand()%255;

      SlowBoxDraw(x1, y1, x2, y2, c);
      }

  SetGraphicsMode();  // quick way of clearing the graphics screen

  gotoxy( 18, 12 ); printf( "Fast" ); delay(3000);
  for ( d = 0; d < number_of_boxes; d++ ) {
      /* Make sure x1 < x2 */
      do {
         x1 = rand()%320; x2 = rand()%320;
      } while ( x1 >= x2 );

      /* Make sure y1 < y2 */
      do {
       y1 = rand()%200; y2 = rand()%200;
      } while ( y1 >= y2 );

      c = rand()%255;

      FastBoxDraw(x1, y1, x2, y2, c);
      }

  SetTextMode();
}





