{Golfspecs-These specifications of types and variables
           are used repeatedly by several programs}
type
    array255 = array[0..255] of byte;
    real20 = array [1..20] of real;
    holes = 1 .. 18;
    scores = array[holes] of byte;
    game_type = record
      game_no : word;
      hcp     : shortint;
      score   : scores;
      course_id: byte;
      month   : byte;
      day     : byte;
      year    : word;
    end;
    game_file_type = file of game_type;
    course_type = record
                    rated_par : real;
                    slope    : byte;
                    card_par : scores;
                    name : string[32];
                    id   : byte;
                  end;
    course_file_type  = file of course_type;
    golfer_type = record
                    no_of_games: word;
                    hcp        : real;
                    last_20    : real20;
                    name       : string[20];
                    id         : byte;
                  end;
    golfer_file_type  = file of golfer_type;
    option_type = (ViewCourses,SelectCourse,ViewGolfer,SelectGolfer,
                  PostScore,CourseAnalysis,ProgramExit,EditGames);

  const
    copyrite: string = 'Copyright (c) 1994  James W. Butler';
    version : string = 'Golf - Version 4.3';
    nobody : golfer_type =
               (no_of_games:0;
               hcp : 0;
               last_20 : (0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
               name : ' New Golfer name    ';
               id   : 0);
    nowhere : course_type =
               (rated_par:0;
               slope    : 113;
               card_par : (0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0);
               name : ' New Course name               ';
               id   : 0);
    max_golfer_box : byte = 15;
    max_course_box : byte = 15;
    space20        : string[20] = '                    ';
    mono           : boolean = false;
    max_holes      : byte = 18;
    max_diffs      : byte = 20;
    percent        : byte = 96;
    use_slope      : boolean = false;
    adj_score_rule : byte = 3;
    first_game_no  : word = 0;
    last_game_no   : word = 0;
    last_club_id   : byte = 0;

  var
    cx         : array255;  {Too bad I can't use initialized}
    gx         : array255;  { constants instead of "255"    }
    front,back : byte;
    color      : boolean;
    regs       : registers;
    golfers    : golfer_file_type;
    courses    : course_file_type;
    game_file,old
               : game_file_type;
    default    : text;
    club       : course_type;
    golfer     : golfer_type;
    course_hiline, course_over_top,
    golfer_hiline, golfer_over_top : byte;
    prev_game,
    curr_game  : game_type;
    esc_score  : scores;
    eq_sum     : real;
    hole       : shortint;
    card_par   : byte;
    Year,Month,Day,DayofWeek
               : word;
    id         : byte;
    option     : option_type;
    xloc,yloc  : byte;
    ch         : char;
    AntiHcp    : real;
    pstring    : string;
    code       : integer;
    s          : string[4];
    printing   : boolean;
    errcode    : integer;

 {Preserved between runs in golf.ini }
    course_id, golfer_id,
    golfer_view, course_view : byte;

{   The Hex procedure has been deleted by being made a big comment,
      but left for re-activation if desired.

procedure Hex(var x : string ; y : longint);
 const
   c:string = ('0123456789ABCDEF');
 var
   z,zz  : longint;
   L,i   : byte;
   minus : boolean;
 begin
   minus := (y < 0);
   L := length(x);
   z := abs(y);
   x := '';
   repeat
   begin
     zz := z mod 16;
     x := c[(zz mod 16) + 1] + x;
     z := z div 16;
   end;
   until (z = 0) and (length(x) >= L);
   if minus then x[1] := chr(ord(x[1]) + 8);
 end;
}


Procedure Box (var Xloc,yloc:byte;
              width,height:byte;
              name:string);

  Procedure Edge(left_corner,right_corner:char;width:byte);
    var
      i : byte;
    begin
      Write(left_corner);
      for I := 2 to width - 1 do Write('');
      Writeln(right_corner);
    end;  {Edge}

  const
   upper_left = '';
   upper_right = '';
   lower_left = '';
   lower_right = '';

  var
    i:byte;
    box_width, box_height :byte;
    ch : char;
  begin
    if color then TextColor(yellow);
    if color then TextBackground(green);
    box_width := width + 3;  {allows an extra space for linefeed in fillbox}
    if (xloc + box_width) > 80 then xloc := 80 - box_width;
    box_height := height+ 2;
    if (yloc + box_height) > 25 then yloc := 25 - box_height;
    Window(xloc,yloc,xloc+box_width,yloc+box_height);
    Edge(upper_left,upper_right,box_width);
    GotoXY((box_width + 1 - length(name)) div 2,1);
    Writeln(name);
    for i := 2 to box_height-1 do
    begin
       GotoXY(1,i);
       Write('');
       GotoXY(box_width,i);
       Writeln('');
    end;
    GotoXY(1,box_height);
    Edge(lower_left,lower_right,box_width);
    Window (xloc + 1, yloc + 1, xloc + width + 1, yloc + height);
    ClrScr;
  end;   {Box}


function GetNum(var status:char; defalt,limit:integer):integer;
{This version is designed for only two digit numbers > 0 }
var
  ch         : char;
  n          : integer;
  x,y        : integer;
  minus      : boolean;
begin
  x      := WhereX;
  y      := WhereY;
  n      := defalt;
  status := ' ';
  repeat
    ch := ReadKey;
    case ch of
      #0:   begin
              ch := ReadKey;
              if (status in [' ',#0]) then
              case ch of
                'H':   {Up arrow}
                  n := n + 1;
                'P':   {Down arrow}
                  if n > 0 then n := n - 1;
                '-':   {Alt-x}
                  begin
                    option := ProgramExit;
                    exit;
                  end;
                else   {Not Up or Down arrow}
                  status := char(Ord(ch) + 128)
                end; {case}
              if (ch in ['H','P'])
                 then status := #0;
            end;     {Extended key }
      '0'..'9':
          begin
            if status = ' ' then
            begin
             status := #0;
             n := 0;
            end;
          n := 10*n + Ord(ch) - Ord('0');
          end;
       #8:
         begin  {backspace}
           if x < WhereX
             then
               begin
                 GotoXY(WhereX - 1,WhereY);
                 Write(' ');
                 GotoXY(WhereX - 1,WhereY);
                 n := n div 10;
               end;
         end;  {backspace}

       {All others  ... not digit, B/S, or up/down arrow}
        else
          begin
            status := ch;
            GetNum := n;
            exit;
          end;  {'Others', including c/r or esc}
      end; {of case statement}
      n := n mod limit;
      if n = 0 then n := limit;
      GetNum := n;
      GotoXY(x,y);
      Write(n:2);
  until not (status in [#0,' ']);
end;  {GetNum}

procedure Get_Date(var status: char;var month,day,year:word);
const
  mlim : array[1..12] of word = (31,29,31,30,31,30,31,31,30,31,30,31);
var
  ans : char;
  x,y : byte;

  procedure Next_item ;
     begin
       GotoXY(x,y);
       TextBackground(green);
       ClrEol;
       Write(month:2,'/',day:2,'/',year:4);
     end;

  begin
    x := WhereX;
    y := WhereY;
    repeat
      Next_item;
      GotoXY(x,y);
      Textbackground(white);
      month := GetNum(status,month,12);
      if option = ProgramExit then exit;
      month := ((month + 11) mod 12) + 1;
      Next_item;
      if status in [#13,#27] then exit;
      GotoXY(x+3,y);
      TextBackground(white);
      day := GetNum(status,day,mlim[month]);
      if option = ProgramExit then exit;
      if day = 0 then day := mlim[month];
      Next_item;
      if status in [#13,#27] then exit;
      GotoXY(x+8,y);
      Textbackground(white);
      year := GetNum(status,year - 1900,99);
      if option = ProgramExit then exit;
      year := year + 1900;
      Next_item;
    until status <> #0;
end;


{Above is   $I golfspec}  { ---standard spec for all 'golf' programs}

