#############################################################################
#                                 SIDE LINER                                #
#                                                                           #
# This is a general purpose robot that demonstrates may basic techniques.   #
# It also demonstractes an advanced technique using the Blocking() command. #
# This robot moves up and down the right wall. Its main goal it to never    #
# stop moving.                                                              #
#                                                                           #
#############################################################################


Init
{
	name( "Side Liner" )
	
	# Move slowly so we miss less while scanning
	SetAccel( 1 )

	# Register the events this robot will respond to
	RegCore( Core )

	# Register the robot detection handler for "travel mode"
	RegDtcRobot( TrvFoundRobot, 1 )
	RegDtcCookie( FoundCookie, 3 )
	RegDtcMine( FoundMine, 4 )
	RegAScan( AutoScan, 5 )
	
	# Turn everything together
	LockAll( ON )
	BodyRight( 90 )
	
	# Move to the wall (hitting walls causes no damage)
	Ahead( 400 )
	
	# Prepare for Core execution
	BodyLeft( 90 )
	
	# From now on, just move the gun and radar together
	LockAll( OFF )
	LockGun( ON )

	# Didn't want to respond to damage until we are along the wall
	RegCldMissile( Damage, 2 )
	RegCldRobot( Damage, 2 )

	# Register the robot detection handler for "side mode"
	RegDtcRobot( SideFoundRobot, 1 )
}

Core
{
	# At this point we should be on right wall facing up
	# The movedist variable is set during call to ScanPath

	Gosub( ScanPath )
	GunLeft( 90 )
	MovingUp = TRUE
	Ahead( movedist )
	
	# Reached top, turn around
	# The movedist variable is set during call to ScanPath

	GunLeft( 90 )
	Gosub( ScanPath )
	GunRight( 90 )
	MovingUp = FALSE
	Back( movedist )
	
	# Reached bottom, turn around
	GunRight( 90 )
}  

# This section handles scans in the direction
# we will soon be traveling (i.e. our path)

ScanPath
{
	# Turn off cookie-events because our handler section shots them
	# Turn on our mine-events because our handle section shots them

	DtcCookieEvents( OFF )
	DtcMineEvents( ON )
	
	Scan( )
	
	# We don't really need a new event handler, just check if we detected
	# a cookie. If so, we want to move a little further than its distance.

	if( dtccookie )
		movedist = scandist + 5
	else
		movedist = scandist	
	endif
	

	# Switch the event handlers for normal scanning. Normal scanning
	# is when scan into parts of the field not in our path.

	DtcMineEvents( OFF )
	DtcCookieEvents( ON )
}

AutoScan
{
	Scan()
}

Damage
{	
	# The MovingUp variable is set in 'Core'. This allows us to
	# keep track of the direct we were traveling (i.e. our state)

	if( MovingUp )
		Back( 70 )
	else
		Ahead( 70 )
	endif
}

SideFoundRobot
{
	Gosub( fire )
		
	# Many robots will call scan here, but we want to 
	# keep moving. Just fire once, then move along.
}

# This section is used while traveling to the side
# If another is detected, stop, fire until gone,
# then finish moving to the wall

TrvFoundRobot
{
	stop( )
	Gosub( Fire )
	Scan( )
	
	if( dtcrobot == 0 )
		# See the description of Blocking() in the FoundCookie section below
		Blocking( OFF )
		Continue( )
		Blocking( ON )
	endif
}

# Adjust energy based on how sure we are of hitting something

Fire
{
	if( scandist > 200 || energy < 10 )
		fire( 1 )
	elseif( scandist > 100 )
		fire( 3 )
	elseif( scandist > 50 )
		fire( 5 )
	else( )
		fire( 7 )
	endif
}

FoundMine
{
	# Don't want to run into a mine!!
	fire( 1 )
}

FoundCookie
{
	# Our goal here it to shot the cookie so no one else can get it.
	# We don't want to leave our wall. Since we were most likely be
	# zooming along when we detected the cookie we'll probably overshot
	# it. This section backs up a little, fires, then continue on.
	
	Stop( )

	# Use the 'MovingUp' state variable to determine which
	# direction we were going when we detected the cookie

	if( MovingUp )
		Back(4)
	else
		Ahead(4)
	endif

	# NUKE THE COOKIE
	fire( 1 )
	
	if( MovingUp )
		Ahead(4)
	else
		Back(4)
	endif

	# The following use of the Blocking() function is relatively advanced.
	# If blocking were left on, this section would remain active until
	# Continue() ended. Since autoscanning is a lower priority event, we
	# would be moving blind! Turning blocking off prevents this section
	# from blocking on Continue(). This ends this section allowing autoscan
	# to be called normally. The orignial call to Ahead() or Back() in 
	# 'Core' will be blocked since blocking was on when they were called.
	
	# There are other alternatives, but each has at least one major problem.
	# Play around with other alternatives and you will see what I mean.
		
	Blocking( OFF )
	Continue( )
	Blocking( ON )
}
