/**************************************************************************/
/*                             Inset   Utility					    */
/*														    */
/*                                 M\Cooper						    */
/*                        3425 Chestnut Ridge Rd.					    */
/*                        Grantsville, MD 21536-9801				    */
/*                        --------------------------				    */
/*                        Email:  thegrendel@aol.com				    */
/*                                                                        */
/*                $2.00 to register the entire WORDY package	         */
/*														    */	
/**************************************************************************/


/**********************************WORDTEST********************************/
/*       Function tests if word is constructible from Letterset	        */
/*                 Args in: char *letterset, char *word						  */
/*   Returns: error_flag == TRUE (1) if constructible, FALSE (0) if not   */
/**************************************************************************/

#include <conio.h>
#include "srch.h"


#define FILE_OPENING_ERROR 3
#define FILENAME_MAXLEN 8
#define CR "\n"
#define FILE_SUFFIX ".set"
#define MAXLEN 30
#define LINE_LEN 80
#define NOARGS 1
#define INCREMENT 1
#define SPACE ' '

char ad[] =
"INSET utility by M\\Cooper, 3425 Chestnut Ridge Rd., Grantsville, MD 21536";


void getword( char *lset );
void center( char *strng );

typedef enum { FALSE, TRUE } Boolean;

void main( int argc, char **argv )
{

   char letterset[ MAXLEN ];

	 if( argc == NOARGS )
	    {
	    clrscr();
	    puts("Enter a LETTERSET to test ... ");
	    gets( letterset );
	    }
	 else
	    strcpy( letterset, *( argv + 1 ) );

	 getword( letterset );
}



Boolean wordtest( char *letterset, char *word )
{
	Boolean error_flag;

      if( strstr( word, letterset ) )
         error_flag = TRUE;
      else
         error_flag = FALSE;
		return( error_flag );
}

/*************************************************************/
void getword( char *letter_set )
{

	char	l_set [ MAXLEN ],
		word [ MAXLEN ],
		tempstr [ MAXLEN + 1 ],
		targetfile [ MAXLEN ],
		bar [ LINE_LEN + 1 ],
		double_bar [ LINE_LEN + 1 ];

	FILE *fptr,
		*tfile;
	int fnamelen;
	long wcount = 0L;

	   memset( bar, '-', LINE_LEN );
	   *( bar + LINE_LEN ) = NULL;
	   memset( double_bar, '=', LINE_LEN );
	   *( double_bar + LINE_LEN ) = NULL;

	   /*************opening credits*************/
	   clrscr();
	   printf( double_bar );
	   strcpy( tempstr, ad );
	   center ( tempstr );
	   printf( tempstr );
	   printf( CR );
	   printf( double_bar );
	   printf( CR );
	   /****************************************/


	   strcpy ( l_set, letter_set );
//	   strcat ( letter_set, CR );

	   /*   Create name of file to store derived words in   */
	   /*********************************************************/
	   fnamelen = strlen( l_set );
	   if( fnamelen  > FILENAME_MAXLEN )
		  fnamelen = FILENAME_MAXLEN;
	   strncpy( targetfile, l_set, fnamelen );
	   *( targetfile + fnamelen ) = NULL;
	   //NULL-terminate string, so strcat works, ha, ha.
	   strcat( targetfile, FILE_SUFFIX );
	   /*********************************************************/

	   if( !( fptr = fopen( Wordfile, "rt" ) ) )
		 {
		 printf( "\7\7\7Cannot open Wordfile!" );
		 exit( FILE_OPENING_ERROR );
		 }

	   if( !( tfile = fopen( targetfile, "wt" ) ) )
		 {
		 printf( "\7\7\7Cannot open file to save words in!" );
		 exit ( FILE_OPENING_ERROR + 1 );
		 }

	   /**************'Wait' Message************/
	   printf( CR CR );
	   printf( "WORKING...\n\n" );
	   printf( "This will take from 10 seconds or less [fast 486 machine]\n" );
	   printf( "to 5 minutes or more [slow 8088 with old hard drive].\n\n" );
	   printf( "Now searching 94,000 word file \nand writing file of valid words using -%s-.\n\n", 
            letter_set );
	   /*****************************************/





	   sprintf( tempstr, "Words created from: %s\n", strupr( l_set ) );
	   center( tempstr );
	   fprintf( tfile, double_bar );
	   fprintf( tfile, tempstr );
	   fprintf( tfile, double_bar );
	   fprintf( tfile, CR );


		 /*********************Main Loop*************/	 
		  while( fgets( word, MAXLEN, fptr ) != NULL )

			if( wordtest( letter_set, word ) )
			   {
			   fprintf( tfile, "%s", word );
			   wcount++;
			   }
		  /*******************************************/

		  fprintf( tfile, bar );
		  sprintf( tempstr, "%ld words can be constructed from %s.",
				 wcount - INCREMENT, l_set );
		  center( tempstr );		      
		  fprintf( tfile, tempstr );
		  fprintf( tfile, "\n\n" );

		  center( ad );
		  fprintf( tfile, ad );

		  fcloseall();

		  sprintf( tempstr,
				 "The file %s has %ld words derived from %s\7.",
				 targetfile, wcount - INCREMENT, l_set );
		  center( tempstr );
		  printf( CR CR );
		  printf( tempstr );

}



void center( char *str )
{
   int padding;
   char st [ LINE_LEN + INCREMENT ];

	 padding = LINE_LEN / 2 - strlen( str ) / 2;
	 memset( st, SPACE, padding );
	 *( st + padding ) = NULL;  //Terminate string
	 strcat( st, str );
	 strcpy( str, st );

	 return;
}
