/*Ŀ
  ALBATROS CDPLAYER Installation script (c) 1993 Norbert Heller             
                                                                            
                                                                            
  Usage    :  INSTALL  <Source> <Target> <Language> <Display Type >         
                                                                            
  Example  :  INSTALL  A: C:\ALBATROS G           6                         
              INSTALL  C:\UNPACK  C:\ALBATROS G   6                         
                                                                            
                                                                            
*/
/* Anfang mit API */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs
Call SysCls

/* Kommando Zeilen Parameter. */
Parse Arg FloppyDir InstallDir Language Resolution

/* Start Init */
bInstructed = 0
Signal On Halt Name SignalHandler

/* Source */
If FloppyDir = " " Then Do
    Call Instructions
    Say
    Say 'NOTE:  If installing from a floppy drive, specify A: or B: '
    Say '       If installing from a Hard Disk , specify full pathname '
    Say
    Call SimplePrompt 'Source Directory (Default 'directory()'):'
    Pull FloppyDir

    /* Fehler ? */
    If FloppyDir = " " Then Do
       FloppyDir = directory()
    End
End


/* Target */
If InstallDir = " " Then Do
    Call Instructions
    Say
    Call SimplePrompt 'Target Directory ( Default C:\ALBATROS ) :'
    Parse Pull InstallDir

    /* Fehler ? */
    If InstallDir = " " Then Do
       InstallDir='C:\ALBATROS'
    End
End

/* Language erfassen */

If Language = " " Then Do
    Say
    Call SimplePrompt 'Language : (G)erman  (E)nglish  :'
    Parse Pull Language

    /* Fehler, default == Englisch  ? */
    If Language = " " Then Do
       Language = 'e'
    End
End

/* Resolution erfassen */
If Resolution = " " Then Do
    Say
    Call SimplePrompt 'Resolution of Target Screen : (6)40 or 800    (1)024 :'
    Parse Pull Resolution

    /* Fehler, default == 640  ? */
    If Resolution = " " Then Do
       Resolution = '6'
    End
End



/* Pfad berichtigen */
If SubStr( FloppyDir, Length( FloppyDir ), 1 ) \= '\' Then
    FloppyDir = FloppyDir||'\'

/* Alles Klar ?     */
Call SysCls
Say 'ͻ'
Say '                                                           '
Say '    ALBATROS  CD PLAYER INSTALLATION                       '
Say '                                                           '
Say 'ͼ'
Say '                                                             '
Say ' Source Directory:       "'FloppyDir'"              '
Say ' Installation Directory: "'InstallDir'"             '
Say '                                                            '
If Language='G' | Language = 'g' then
Say ' Language = GERMAN                                          '
else
If Language='E' | Language = 'e' then
Say ' Language = ENGLISH                                         '
Say '                                                             '

If Resolution='6' then
Say ' Resolution = 640*480 or 800*600                                          '
else
If Resolution='1' then
Say ' Resolution = 1024*768                                         '
Say '                                                             '

Call YNPrompt 'OK to continue?', '1'

/* Dir's da ? */
Say
Say 'Checking for directory "'InstallDir'".'
Call SysFileTree InstallDir, FileStem, 'D'

/* Directory nicht da  */
If FileStem.0 = '0' Then Do
    Say 'The "'InstallDir'" directory does not exist on your hard drive.'
    Say
    Call YNPrompt 'OK to create "'InstallDir'"?', '1'
    Say
    Say 'Creating 'InstallDir'....'
    rc = SysMkDir( InstallDir )
    if rc = 0 Then Do
        Say 'The directory "'InstallDir'" was created successfully.'
    End
    Else Do
        Say 'The directory "'InstallDir'" could not be created.'
        Exit
    End
End


/* Kopieren */
Call SysCls
Say
Say 'ALBATROS  INSTALL is copying files to your hard drive.'
Say
Call CopyFile 'ALBATROS.EXE',   FloppyDir, InstallDir
Call CopyFile 'ALBATROS.ICO',   FloppyDir, InstallDir
/*
Call CopyFile 'ALBATROS.HLP',   FloppyDir, InstallDir
Call CopyFile 'ALBATROS.INF',   FloppyDir, InstallDir
*/

If Language = 'G' | Language = 'g' then Do
   Copy FloppyDir || GERMAN.DLL InstallDir||'\'||ALBATROS.DLL
   Copy FloppyDir || GERMAN.INF InstallDir||'\'||ALBATROS.INF
   Copy FloppyDir || GERMAN.HLP InstallDir||'\'||ALBATROS.HLP
End

If Language = 'E' | Language = 'e' then do
   Copy FloppyDir || ENGLISH.DLL InstallDir||'\'||ALBATROS.DLL
   Copy FloppyDir || ENGLISH.INF InstallDir||'\'||ALBATROS.INF
   Copy FloppyDir || ENGLISH.HLP InstallDir||'\'||ALBATROS.HLP
End

If Resolution = '6' then do
   Copy FloppyDir || LCD640.FON InstallDir||'\'||ALBATROS.FON
End

If Resolution = '1' then do
   Copy FloppyDir || LCD1024.FON InstallDir||'\'||ALBATROS.FON
End

/*
Call CopyFile 'ALBATROS.FON',   FloppyDir, InstallDir
*/
Call CopyFile 'INSTALL.CMD',    FloppyDir, InstallDir


/* Program objekt erstellen ? */
Call SysCls
Say 'ͻ'
Say '                                                           '
Say '   ALBATROS CD Player can be installed as a program        '
Say '   object on your Desktop                                  '
Say '                                                           '
Say 'ͼ'
Say 
Ret = YNPrompt( 'Do you want a program object created?', '0' )
If Ret = 'Y' | Ret = 'y' Then Do
    Say
    Say 'Creating program reference object.'
    r = SysCreateObject(    "WPProgram",,
                            "Albatros",,
                            "<WP_DESKTOP>",,
                            "EXENAME="||InstallDir||"\ALBATROS.EXE;STARTUPDIR="||InstallDir )

End

/* und das INF Anzeigen */
If Language = 'E' | Language = 'e' then Do
   View InstallDir||'\'||ALBATROS.INF ABOUT
End

If Language = 'G' | Language = 'g' then Do
   View InstallDir||'\'||ALBATROS.INF UEBER
End

/* Und Fertig */
Call SysCls
Say 'ͻ'
Say '                                                           '
Say '   CD Player has been installed correctly                  '
Say '                                                           '
Say '   Please read the README Files and REGISTER Your Copy     '
Say '                                                           '
Say '   Have Fun with CD PLAYER                                 '
Say '                                                           '
Say 'ͼ'
Say '                                                             '


/* Und Tschuess */
Exit


/*Ŀ
  Name:        CopyFile                                                     
                                                                            
  Description: kopiert eine datei                                           
                                                                            
  Args:        File2copy, FloppyDrive, DestDrive                            
                                                                            
*/
CopyFile: Arg ArgFile2Copy, ArgFloppyDir, ArgInstallDir

    Say
    Say 'Copying 'ArgFloppyDir||ArgFile2Copy' to 'ArgInstallDir||'\'||ArgFile2Copy'.'
    Command = '@Copy 'ArgFloppyDir||ArgFile2Copy' 'ArgInstallDir||'\'||ArgFile2Copy
    Command
    if rc \= 0 Then Do
        Call SimplePrompt 'Warning! 'ArgFile2Copy' could not be copied properly.'
        Pull ConfirmIt
    End
    Return


/*Ŀ
                                                                            
  Name:        Prompt                                                       
                                                                            
  Description: Stellt den Curso an eine bestimmte stelle des Bildschirms    
                                                                            
  Args:        Prompt                                                       
*/
SimplePrompt: Parse Arg ArgPrompt

    /* Kursor position */
    Parse Value SysCurPos() With Row .

    /* Schirm groesse */
    Parse Value SysTextScreenSize() With NumRows .

    /* End des Bildschirm ? */
    if Row = NumRows - 1 Then Row = Row - 1

    /* Eingabe  */
    Col = Length( ArgPrompt ) + 1

    /* Zeige Eingabe */
    Say ArgPrompt
    Call SysCurPos Row, Col

    Return


/*Ŀ
  Name:        YNPrompt                                                     
                                                                            
  Description: Fragt nach Y /N                                              
                                                                            
  Args:        Yes/No Prompt                                                
*/
YNPrompt: Parse Arg ArgPrompt, ArgAbort

    /* Bwenutzer Fragen*/
    Call SimplePrompt ArgPrompt' (Y or N)'

    /* Bis er mit ja oder nein antwortet */
    Do Forever
        Key = SysGetKey( 'NOECHO' )
        If Key = 'Y' | Key = 'y' Then Do
            Say
            Return Key
        End
        Else If Key = 'N' | Key = 'n' Then Do
            Say
            If ArgAbort = '1' Then Exit
            Return Key
        End
    End
    Return 'y'


/*Ŀ
  Name:        Instruktionen                                                
                                                                            
  Description: Wie installiere ich richtig                                  
*/
Instructions:
    If bInstructed  = 0 Then Do
        Say
        Say 'ͻ'
        Say '    ALBATROS CD PLAYER Installation Instructions:              '
        Say '                                                               '
        Say ' Usage  : INSTALL  <Source> <Target> <Language> <Display Type> '
        Say '                                                               '
        Say ' Example: INSTALL A:           C:\ALBATROS  E  1               '
        Say ' Example: INSTALL C:\UNPACK    C:\ALBATROS  E  1               '
        Say '                                                               '
        Say 'ͼ'
 
       bInstructed = 1
    End
    Return


/*Ŀ
  Name:        SignalHandler                                                
                                                                            
  Description: Signal Handler                                               
*/
SignalHandler:
    Call SysCls
    Say 'Warning ! CD Player installation aborted.'
    Exit

