#include <windows.h>
#include <dos.h>
#include <memory.h>
#include "wnetbios.h"


#define WM_NETBIOS_NOTIFY   WM_USER+0x5000


static void _loadds cdecl interrupt far PostHandler(void);

static BOOL PASCAL WaitForResponse(WMODE Mode, HWND hwnd, LPNCB lpNCB);

int  FAR PASCAL LibMain(HANDLE hModule, WORD wDataSeg, WORD cbHeapSize, LPSTR lpszCmdLine);
int  FAR PASCAL WEP (int bSystemExit);


HANDLE  hLibrary = NULL;
int net_errno;


BOOL FAR PASCAL LibMain(HANDLE hInstance,
WORD   wDataSeg,
WORD   wHeapSize,
LPSTR  lpCmdLine)
{
	hLibrary = hInstance;
	
	_fmemset(&allNCB, 0, sizeof(allNCB));
	
	return(TRUE);
}                         
// ------------------------- INLINE ASM -----------------------------------

#pragma optimize ("", off)

#pragma alloc_text(FIXEDSEG, WEP)
int FAR PASCAL WEP(int bSystemExit)
{
	return(TRUE);
}

#pragma alloc_text(FIXEDSEG, PostHandler)

static void _loadds cdecl interrupt far PostHandler(void)
{
	LPNCB lpNCB;
	
	/* ES:BX => NCB structure */
	_asm {
		mov     word ptr lpNCB,bx
		mov     word ptr lpNCB+2,es
	}
	PostMessage(lpNCB->post.hwndPost, lpNCB->post.wMsgPost,	lpNCB->post.wParam,	(LONG) lpNCB);
	return;
}


WORD FAR PASCAL _export SendNetBIOS(LPNCB lpNCB)
{
	WORD    wErrCode;
	extern WORD FAR PASCAL NetBIOSCall(void);
	
	lpNCB->fnPost = 0L;
	
	_asm {
		push    ax
		push    bx
		push    es
		les     bx,lpNCB
		call    NetBIOSCall
		xor     ah,ah
		mov     al,byte ptr es:[bx].cRetcode
		mov     wErrCode,ax
		pop     es
		pop     bx
		pop     ax
	}
	net_errno = wErrCode;
	return(wErrCode);
}

WORD FAR PASCAL _export PostNetBIOS(LPNCB lpNCB,HWND  hwndPost,WORD  wMsgPost,WORD  wParam)
{
	WORD    wErrCode;
	extern WORD FAR PASCAL NetBIOSCall(void);
	
	
	lpNCB->post.hwndPost = hwndPost;
	lpNCB->post.wMsgPost = wMsgPost;
	lpNCB->post.wParam   = wParam;
	
	lpNCB->cCommand |= NO_WAIT;
	
	
	_asm {
		push    ax
		push    bx
		push    es
		les     bx,lpNCB
		call    NetBIOSCall
		xor     ah,ah
		mov     wErrCode,ax
		pop     es
		pop     bx
		pop     ax
	}
	net_errno = wErrCode;
	return(wErrCode);
}
#pragma optimize ("", on)
// -------------------------- END INLINE ASM -----------------------------------------


static BOOL PASCAL WaitForResponse(WMODE Mode, HWND hwnd, LPNCB lpNCB)
{
	MSG  msg;
	HWND hwndMsg;
	
	if(Mode == WAIT_APP_MODAL)
	{
		 hwndMsg = hwnd; 
	}else
	{
		 hwndMsg = NULL;
	}	
	while(lpNCB->cCmdCplt == 0x00ff)
	{
		while (PeekMessage(&msg, hwndMsg, 0, 0, PM_REMOVE))			
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
			
			if ( (msg.hwnd == hwnd)
			&& (msg.message == WM_NCDESTROY))
			{
				return FALSE;
			}
			if(lpNCB->cCmdCplt != 0xff)	return TRUE;
		}
	}
	return TRUE; // Call completed
}

BOOL FAR PASCAL _export CancelAllPending(HWND hwndPost)
{
	int x;
	
	for(x = 0; x < MAX_NCB; x++)
	{
		if( (allNCB[x].used == 1)
		&&  (allNCB[x].post.hwndPost == hwndPost))
		{
			_fmemset(&privNCB, 0, sizeof(privNCB));
			privNCB.cCommand = NETBIOS_CANCEL;
			privNCB.cAdapterNum = allNCB[x].cAdapterNum;
			privNCB.lpBuffer = (LPSTR)&allNCB[x];       
			
			SendNetBIOS(&privNCB);
			allNCB[x].used = 0;
		}   
	}
	return(TRUE);
}

LPNCB FAR PASCAL _export CreateNCB(BYTE cCommand, BYTE cAdapterNum)
{
	int x;
	
	for(x = 0; x < MAX_NCB; x++)
	{
		if(allNCB[x].used == 0)
		{
			_fmemset(&allNCB[x], 0, sizeof(privNCB));
			
			allNCB[x].cCommand = cCommand;
			allNCB[x].cAdapterNum = cAdapterNum;
			allNCB[x].cRetcode = 0xff;
			allNCB[x].fnPost = (FARPROC) (void far *) PostHandler;
			_fmemset(allNCB[x].cName, ' ', MAX_NAME_SIZE);
			_fmemset(allNCB[x].cCallName, ' ', MAX_NAME_SIZE);
			allNCB[x].used = 1;
			
			return(&allNCB[x]);
		}   
	}                
	net_errno = NB_NO_FREE_NCB_ERR;
	return(NULL);
}

BOOL FAR PASCAL _export DestroyNCB(LPNCB lpNCB)
{
	if(lpNCB->cCmdCplt == 0xff)
	{
		// OutputDebugString("err WNETBIOS: tried to destroy pending Call\n");
		return FALSE;
	}
	_fmemset(lpNCB, 0, sizeof(NCB));
	
	return(TRUE);
}       

WORD FAR PASCAL _export SubmitNCB(WMODE Mode, LPNCB lpNCB, HWND hwndPost)
{
	
	WORD     wErrCode;
	
	// wenn FensterHandle ungltig dann blockierter Call
	
	if (!IsWindow(hwndPost) || Mode == WAIT_SYS_MODAL)
	{
		wErrCode = SendNetBIOS(lpNCB);
	}
	else
	{
		lpNCB->cCommand |= NO_WAIT;
		wErrCode = SendNetBIOS(lpNCB);
		
		if( (wErrCode == 0x00ff)
		||  (wErrCode == 0x0000))
		{                 
			if(lpNCB->cCmdCplt == 0x00ff)
			{
				if (WaitForResponse(Mode, hwndPost, lpNCB) == FALSE)
				{    
					// OutputDebugString("err WNETBIOS: Response Window destroyed\n");
					Cancel(lpNCB->cAdapterNum, lpNCB);
					net_errno = wErrCode = NB_WAIT_FOR_RESPONSE_ERR;
				}else
				{
					net_errno = wErrCode = lpNCB->cCmdCplt;
				}
			}else
			{
				net_errno = wErrCode = lpNCB->cCmdCplt;
			}
		}
	}
	return(wErrCode);
}

BOOL FAR PASCAL _export IsNetBIOSLoaded(void)
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	if (!_dos_getvect(0x5c))
	return (FALSE);
	
	lpNCB = CreateNCB(NETBIOS_INVALID_COMMAND, 0);
	
	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	wErrCode = SendNetBIOS(lpNCB);
	
	DestroyNCB(lpNCB);
	
	if (wErrCode != NB_INVALID_COMMAND)
	{
		return (FALSE);
	}
	return(TRUE);
}



WORD FAR PASCAL _export AddName(WMODE  Mode,LPSTR  szName,BYTE   cAdapterNum, 
	HWND   hwndPost,LPBYTE cNum)        
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	lpNCB = CreateNCB(NETBIOS_ADD_NAME, cAdapterNum);

	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	if (lstrlen(szName) > MAX_NAME_SIZE)
	{
		szName[MAX_NAME_SIZE] = '\0';
	}
	_fmemcpy(lpNCB->cName, szName, lstrlen(szName));
	
	wErrCode = SubmitNCB(Mode, lpNCB, hwndPost);
	
	if (wErrCode == 0)
	{
		*cNum = lpNCB->cNum;
	}
	DestroyNCB(lpNCB);
	return(wErrCode);
}


WORD FAR PASCAL _export PostAddName(LPSTR szName, BYTE  cAdapterNum, HWND  hwndPost,     
	WORD  wMsgPost, WORD  wParam, LPNCB FAR *lpRetNCB) 
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	if (!IsWindow(hwndPost))
	{
		return(NB_INVALID_WINDOW);
	}
	
	lpNCB = CreateNCB(NETBIOS_ADD_NAME, cAdapterNum);
	
	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	if (lstrlen(szName) > MAX_NAME_SIZE)
	{
		szName[MAX_NAME_SIZE] = '\0';
	}                     
	
	_fmemcpy(lpNCB->cName, szName, lstrlen(szName));
	
	wErrCode = PostNetBIOS(lpNCB,hwndPost,wMsgPost,wParam);
	
	if (wErrCode != 0)
	{
		DestroyNCB(lpNCB);
	}
	else
	{
		*lpRetNCB = lpNCB;
	}
	return(wErrCode);
}


WORD FAR PASCAL _export AddGroupName(WMODE  Mode, LPSTR szName, BYTE  cAdapterNum,  
	HWND  hwndPost, LPBYTE cNum)        
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	lpNCB = CreateNCB(NETBIOS_ADD_GROUP_NAME, cAdapterNum);
	
	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	if (lstrlen(szName) > MAX_NAME_SIZE)
	{
		szName[MAX_NAME_SIZE] = '\0';
	}
	_fmemcpy(lpNCB->cName, szName, lstrlen(szName));
	
	wErrCode = SubmitNCB(Mode, lpNCB, hwndPost);
	
	if (wErrCode == 0)
	{
		*cNum = lpNCB->cNum;
	}
	DestroyNCB(lpNCB);
	
	return(wErrCode);
}


WORD FAR PASCAL _export PostAddGroupName(LPSTR szName, BYTE  cAdapterNum, HWND  hwndPost,     
	WORD  wMsgPost, WORD  wParam, LPNCB FAR *lpRetNCB) 
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	if (!IsWindow(hwndPost))
	{
		return(NB_INVALID_WINDOW);
	}
	
	lpNCB = CreateNCB(NETBIOS_ADD_GROUP_NAME, cAdapterNum);
	
	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	if (lstrlen(szName) > MAX_NAME_SIZE)
	{
		szName[MAX_NAME_SIZE] = '\0';
	}
	
	_fmemcpy(lpNCB->cName, szName, lstrlen(szName));
	
	wErrCode = PostNetBIOS(lpNCB,hwndPost,wMsgPost,wParam);
	
	if (wErrCode != 0)
	{
		DestroyNCB(lpNCB);
	}
	else
	{
		*lpRetNCB = lpNCB;
	}
	return(wErrCode);
}


WORD FAR PASCAL _export DeleteName(WMODE  Mode, LPSTR  szName, BYTE   cAdapterNum, 
	HWND   hwndPost)    
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	lpNCB = CreateNCB(NETBIOS_DELETE_NAME, cAdapterNum);

	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	if (lstrlen(szName) > MAX_NAME_SIZE)
	{
		szName[MAX_NAME_SIZE] = '\0';
	}
	
	_fmemcpy(lpNCB->cName, szName, lstrlen(szName));
	
	wErrCode = SubmitNCB(Mode, lpNCB, hwndPost);
	
	DestroyNCB(lpNCB);
	return(wErrCode);
}


WORD FAR PASCAL _export PostDeleteName(LPSTR szName, BYTE  cAdapterNum, HWND  hwndPost,     
	WORD  wMsgPost, WORD  wParam, LPNCB FAR *lpRetNCB)    
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	if (!IsWindow(hwndPost))
	{
		return(NB_INVALID_WINDOW);
	}
	
	lpNCB = CreateNCB(NETBIOS_DELETE_NAME, cAdapterNum);
	
	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	if (lstrlen(szName) > MAX_NAME_SIZE)
	{
		szName[MAX_NAME_SIZE] = '\0';
	}
	_fmemcpy(lpNCB->cName, szName, lstrlen(szName));
	
	wErrCode = PostNetBIOS(lpNCB,hwndPost,wMsgPost, wParam);
	
	if (wErrCode != 0)
	{
		DestroyNCB(lpNCB);
	}
	else
	{
		*lpRetNCB = lpNCB;
	}
	return(wErrCode);
}


WORD FAR PASCAL _export Listen(WMODE  Mode, LPSTR  szName, LPSTR  szCallName,   
	BYTE   cAdapterNum, BYTE   cRTO, BYTE   cSTO, HWND   hwndPost, LPBYTE cLSN,         
	LPSTR  szRemoteName) 
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	lpNCB = CreateNCB(NETBIOS_LISTEN, cAdapterNum);
	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	if (lstrlen(szName) > MAX_NAME_SIZE)
	{
		szName[MAX_NAME_SIZE] = '\0';
	}
	
	if (lstrlen(szCallName) > MAX_NAME_SIZE)
	{
		szCallName[MAX_NAME_SIZE] = '\0';
	}
	
	lpNCB->cRTO = cRTO;
	lpNCB->cSTO = cSTO;
	_fmemcpy(lpNCB->cName, szName, lstrlen(szName));
	_fmemcpy(lpNCB->cCallName, szCallName, lstrlen(szCallName));
	
	wErrCode = SubmitNCB(Mode, lpNCB, hwndPost);
	
	if (wErrCode == 0)
	{
		*cLSN = lpNCB->cLSN;
		_fmemcpy(szRemoteName, lpNCB->cCallName, MAX_NAME_SIZE);
		szRemoteName[MAX_NAME_SIZE] = '\0';
	}
	
	DestroyNCB(lpNCB);
	return(wErrCode);
}



WORD FAR PASCAL _export PostListen(LPSTR szName, LPSTR szCallName, BYTE  cAdapterNum,  
	BYTE  cRTO, BYTE  cSTO, HWND  hwndPost, WORD  wMsgPost, WORD  wParam, LPNCB FAR *lpRetNCB)    
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	if (!IsWindow(hwndPost))
	{
		return(NB_INVALID_WINDOW);
	}
	
	lpNCB = CreateNCB(NETBIOS_LISTEN, cAdapterNum);
	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	if (lstrlen(szName) > MAX_NAME_SIZE)
	{
		szName[MAX_NAME_SIZE] = '\0';
	}
	
	if (lstrlen(szCallName) > MAX_NAME_SIZE)
	{
		szCallName[MAX_NAME_SIZE] = '\0';
	}
	
	lpNCB->cRTO = cRTO;
	lpNCB->cSTO = cSTO;
	_fmemcpy(lpNCB->cName, szName, lstrlen(szName));
	_fmemcpy(lpNCB->cCallName, szCallName, lstrlen(szCallName));
	
	wErrCode = PostNetBIOS(lpNCB,hwndPost,wMsgPost,wParam);
	
	if (wErrCode != 0)
	{
		DestroyNCB(lpNCB);
	}
	else
	{
		*lpRetNCB = lpNCB;
	}
	return(wErrCode);
}


WORD FAR PASCAL _export Call(WMODE  Mode, LPSTR  szName, LPSTR  szCallName,   
	BYTE   cAdapterNum, BYTE   cRTO, BYTE   cSTO, HWND   hwndPost, LPBYTE cLSN)         
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	lpNCB = CreateNCB(NETBIOS_CALL, cAdapterNum);

	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	if (lstrlen(szName) > MAX_NAME_SIZE)
	{
		szName[MAX_NAME_SIZE] = '\0';
	}
	
	if (lstrlen(szCallName) > MAX_NAME_SIZE)
	{
		szCallName[MAX_NAME_SIZE] = '\0';
	}
	
	lpNCB->cRTO = cRTO;
	lpNCB->cSTO = cSTO;
	_fmemcpy(lpNCB->cName, szName, lstrlen(szName));
	_fmemcpy(lpNCB->cCallName, szCallName, lstrlen(szCallName));
	
	wErrCode = SubmitNCB(Mode, lpNCB, hwndPost);
	
	if (wErrCode == 0)
	{
		*cLSN = lpNCB->cLSN;
	}
	
	DestroyNCB(lpNCB);
	return(wErrCode);
}


WORD FAR PASCAL _export PostCall(LPSTR szName, LPSTR szCallName, BYTE  cAdapterNum,  
	BYTE  cRTO, BYTE  cSTO, HWND  hwndPost, WORD  wMsgPost, WORD  wParam, LPNCB FAR *lpRetNCB)    
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	if (!IsWindow(hwndPost))
	{
		return(NB_INVALID_WINDOW);
	}
	
	lpNCB = CreateNCB(NETBIOS_CALL, cAdapterNum);
	
	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	if (lstrlen(szName) > MAX_NAME_SIZE)
	{
		szName[MAX_NAME_SIZE] = '\0';
	}
	
	if (lstrlen(szCallName) > MAX_NAME_SIZE)
	{
		szCallName[MAX_NAME_SIZE] = '\0';
	}
	
	lpNCB->cRTO = cRTO;
	lpNCB->cSTO = cSTO;
	_fmemcpy(lpNCB->cName, szName, lstrlen(szName));
	_fmemcpy(lpNCB->cCallName, szCallName, lstrlen(szCallName));
	
	wErrCode = PostNetBIOS(lpNCB,hwndPost,wMsgPost,	wParam);
	
	if (wErrCode != 0)
	{
		DestroyNCB(lpNCB);
	}
	else
	{
		*lpRetNCB = lpNCB;
	}
	return(wErrCode);
}


WORD FAR PASCAL _export HangUp(WMODE  Mode, BYTE  cAdapterNum, BYTE  cLSN, HWND  hwndPost)     
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	lpNCB = CreateNCB(NETBIOS_HANGUP, cAdapterNum);
	
	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	lpNCB->cLSN = cLSN;
	
	wErrCode = SubmitNCB(Mode,lpNCB, hwndPost);
	
	DestroyNCB(lpNCB);
	return(wErrCode);
}


WORD FAR PASCAL _export PostHangup(BYTE  cAdapterNum, BYTE  cLSN, HWND  hwndPost, 
	WORD  wMsgPost, WORD  wParam, LPNCB FAR *lpRetNCB) 
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	if (!IsWindow(hwndPost))
	{
		return(NB_INVALID_WINDOW);
	}
	
	lpNCB = CreateNCB(NETBIOS_HANGUP, cAdapterNum);
	
	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	lpNCB->cLSN = cLSN;
	
	wErrCode = PostNetBIOS(lpNCB,hwndPost,wMsgPost,wParam);
	
	if (wErrCode != 0)
	{
		DestroyNCB(lpNCB);
	}
	else
	{
		*lpRetNCB = lpNCB;
	}
	return(wErrCode);
}

WORD FAR PASCAL _export Send(WMODE  Mode, BYTE  cAdapterNum, BYTE  cLSN, LPSTR szBuffer,     
	WORD  wBufLen, HWND  hwndPost)     
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	lpNCB = CreateNCB(NETBIOS_SEND, cAdapterNum);
	
	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	lpNCB->cLSN = cLSN;
	lpNCB->lpBuffer = szBuffer;
	lpNCB->wLength = wBufLen;
	
	wErrCode = SubmitNCB(Mode, lpNCB, hwndPost);
	
	DestroyNCB(lpNCB);
	return(wErrCode);
}


WORD FAR PASCAL _export PostSend(BYTE  cAdapterNum, BYTE  cLSN, LPSTR szBuffer,     
	WORD  wBufLen, HWND  hwndPost, WORD  wMsgPost, WORD  wParam, LPNCB FAR *lpRetNCB)    
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	if (!IsWindow(hwndPost))
	{
		return(NB_INVALID_WINDOW);
	}
	
	lpNCB = CreateNCB(NETBIOS_SEND, cAdapterNum);
	
	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	lpNCB->cLSN = cLSN;
	lpNCB->lpBuffer = szBuffer;
	lpNCB->wLength = wBufLen;
	
	wErrCode = PostNetBIOS(lpNCB,hwndPost,wMsgPost,	wParam);
	
	if (wErrCode != 0)
	{
		DestroyNCB(lpNCB);
	}
	else
	{
		*lpRetNCB = lpNCB;
	}
	return(wErrCode);
}


WORD FAR PASCAL _export ChainSend(WMODE  Mode, BYTE  cAdapterNum, BYTE  cLSN, LPSTR szBuffer,     
	WORD  wBufLen, LPSTR szBuffer2, WORD  wBufLen2, HWND  hwndPost)     
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	lpNCB = CreateNCB(NETBIOS_CHAIN_SEND, cAdapterNum);

	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	lpNCB->cLSN = cLSN;
	lpNCB->lpBuffer = szBuffer;
	lpNCB->wLength = wBufLen;
	_fmemcpy((LPSTR) &lpNCB->cCallName[2], (LPSTR) szBuffer2, sizeof(LPSTR));
	_fmemcpy((LPSTR) &lpNCB->cCallName[0], (LPSTR) &wBufLen2, sizeof(WORD));
	
	wErrCode = SubmitNCB(Mode, lpNCB, hwndPost);
	
	DestroyNCB(lpNCB);
	return(wErrCode);
}


WORD FAR PASCAL _export PostChainSend(BYTE  cAdapterNum, BYTE  cLSN, LPSTR szBuffer, 
	WORD  wBufLen, LPSTR szBuffer2, WORD  wBufLen2, HWND  hwndPost, WORD  wMsgPost,     
	WORD  wParam, LPNCB FAR *lpRetNCB)    
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	if (!IsWindow(hwndPost))
	{
		return(NB_INVALID_WINDOW);
	}
	
	lpNCB = CreateNCB(NETBIOS_CHAIN_SEND, cAdapterNum);
	
	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	lpNCB->cLSN = cLSN;
	lpNCB->lpBuffer = szBuffer;
	lpNCB->wLength = wBufLen;
	_fmemcpy((LPSTR) &lpNCB->cCallName[2], (LPSTR) szBuffer2, sizeof(LPSTR));
	_fmemcpy((LPSTR) &lpNCB->cCallName[0], (LPSTR) &wBufLen2, sizeof(WORD));
	
	wErrCode = PostNetBIOS(lpNCB,hwndPost,wMsgPost,wParam);
	
	if (wErrCode != 0)
	{
		DestroyNCB(lpNCB);
	}
	else
	{
		*lpRetNCB = lpNCB;
	}
	return(wErrCode);
}


WORD FAR PASCAL _export Receive(WMODE  Mode, BYTE  cAdapterNum, BYTE  cLSN, LPSTR szBuffer,     
	LPWORD wBufLen, HWND  hwndPost)     
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	lpNCB = CreateNCB(NETBIOS_RECEIVE, cAdapterNum);
	
	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	lpNCB->cLSN = cLSN;
	lpNCB->lpBuffer = szBuffer;
	lpNCB->wLength = *wBufLen;
	
	wErrCode = SubmitNCB(Mode, lpNCB, hwndPost);
	
	if (wErrCode == 0)
	{
		*wBufLen = lpNCB->wLength;
	}
	
	DestroyNCB(lpNCB);
	return(wErrCode);
}


WORD FAR PASCAL _export PostReceive(BYTE  cAdapterNum, BYTE  cLSN, LPSTR szBuffer,     
	WORD  wBufLen, HWND  hwndPost, WORD  wMsgPost, WORD  wParam, LPNCB FAR *lpRetNCB) 

{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	if (!IsWindow(hwndPost))
	{
		return(NB_INVALID_WINDOW);
	}
	
	lpNCB = CreateNCB(NETBIOS_RECEIVE, cAdapterNum);
	
	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	lpNCB->cLSN = cLSN;
	lpNCB->lpBuffer = szBuffer;
	lpNCB->wLength = wBufLen;
	
	wErrCode = PostNetBIOS(lpNCB,hwndPost,wMsgPost,wParam);
	
	if (wErrCode != 0)
	{
		DestroyNCB(lpNCB);
	}
	else
	{
		*lpRetNCB = lpNCB;
	}
	return(wErrCode);
}


WORD FAR PASCAL _export SendBroadcast(WMODE  Mode, BYTE  cAdapterNum, BYTE  cNum,         
	LPSTR szBuffer, WORD  wBufLen, HWND  hwndPost)     
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	lpNCB = CreateNCB(NETBIOS_SEND_BROADCAST, cAdapterNum);

	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	lpNCB->cNum = cNum;
	lpNCB->lpBuffer = szBuffer;
	lpNCB->wLength = wBufLen;
	
	wErrCode = SubmitNCB(Mode, lpNCB, hwndPost);
	
	DestroyNCB(lpNCB);
	return(wErrCode);
}


WORD FAR PASCAL _export PostSendBroadcast(BYTE  cAdapterNum, BYTE  cNum, LPSTR szBuffer,     
	WORD  wBufLen, HWND  hwndPost, WORD  wMsgPost, WORD  wParam, LPNCB FAR *lpRetNCB) 
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	if (!IsWindow(hwndPost))
	{
		return(NB_INVALID_WINDOW);
	}
	
	lpNCB = CreateNCB(NETBIOS_SEND_BROADCAST, cAdapterNum);
	
	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	lpNCB->cNum = cNum;
	lpNCB->lpBuffer = szBuffer;
	lpNCB->wLength = wBufLen;
	
	wErrCode = PostNetBIOS(lpNCB,hwndPost,wMsgPost,wParam);
	
	if (wErrCode != 0)
	{
		DestroyNCB(lpNCB);
	}
	else
	{
		*lpRetNCB = lpNCB;
	}
	return(wErrCode);
}


WORD FAR PASCAL _export ReceiveBroadcast(WMODE  Mode, BYTE  cAdapterNum, BYTE  cNum,         
	LPSTR szBuffer, LPWORD wBufLen, HWND   hwndPost)    
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	lpNCB = CreateNCB(NETBIOS_RECEIVE_BROADCAST, cAdapterNum);

	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	lpNCB->cNum = cNum;
	lpNCB->lpBuffer = szBuffer;
	lpNCB->wLength = *wBufLen;
	
	wErrCode = SubmitNCB(Mode, lpNCB, hwndPost);
	
	if (wErrCode == 0)
	{
		*wBufLen = lpNCB->wLength;
	}
	
	DestroyNCB(lpNCB);
	return(wErrCode);
}


WORD FAR PASCAL _export PostReceiveBroadcast(BYTE  cAdapterNum, BYTE  cNum, LPSTR szBuffer,     
	WORD  wBufLen, HWND  hwndPost, WORD  wMsgPost, WORD  wParam, LPNCB FAR *lpRetNCB) 
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	if (!IsWindow(hwndPost))
	{
		return(NB_INVALID_WINDOW);
	}
	
	lpNCB = CreateNCB(NETBIOS_RECEIVE_BROADCAST, cAdapterNum);
	
	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	lpNCB->cNum = cNum;
	lpNCB->lpBuffer = szBuffer;
	lpNCB->wLength = wBufLen;
	
	wErrCode = PostNetBIOS(lpNCB,hwndPost,wMsgPost,wParam);
	
	if (wErrCode != 0)
	{
		DestroyNCB(lpNCB);
	}
	else
	{
		*lpRetNCB = lpNCB;
	}
	return(wErrCode);
}


WORD FAR PASCAL _export SendDatagram(WMODE  Mode, BYTE  cAdapterNum, BYTE  cNum,         
	LPSTR szCallName, LPSTR szBuffer, WORD  wBufLen, HWND  hwndPost)     
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	lpNCB = CreateNCB(NETBIOS_SEND_DATAGRAM, cAdapterNum);
	
	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	lpNCB->cNum = cNum;
	_fmemcpy(lpNCB->cCallName, szCallName, lstrlen(szCallName));
	lpNCB->lpBuffer = szBuffer;
	lpNCB->wLength = wBufLen;
	
	wErrCode = SubmitNCB(Mode, lpNCB, hwndPost);
	
	DestroyNCB(lpNCB);
	return(wErrCode);
}


WORD FAR PASCAL _export PostSendDatagram(BYTE  cAdapterNum, BYTE  cNum, LPSTR szCallName,   
	LPSTR szBuffer, WORD  wBufLen, HWND  hwndPost, WORD  wMsgPost, WORD  wParam, LPNCB FAR *lpRetNCB) 

{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	if (!IsWindow(hwndPost))
	{
		return(NB_INVALID_WINDOW);
	}
	
	lpNCB = CreateNCB(NETBIOS_SEND_DATAGRAM, cAdapterNum);
	
	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	lpNCB->cNum = cNum;
	_fmemcpy(lpNCB->cCallName, szCallName, lstrlen(szCallName));
	lpNCB->lpBuffer = szBuffer;
	lpNCB->wLength = wBufLen;
	
	wErrCode = PostNetBIOS(lpNCB,hwndPost,wMsgPost,wParam);
	
	if (wErrCode != 0)
	{
		DestroyNCB(lpNCB);
	}
	else
	{
		*lpRetNCB = lpNCB;
	}
	return(wErrCode);
}


WORD FAR PASCAL _export ReceiveDatagram(WMODE  Mode, BYTE  cAdapterNum, BYTE  cNum, LPSTR szBuffer,      
	LPWORD wBufLen, HWND   hwndPost, LPSTR szCallName)    
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	lpNCB = CreateNCB(NETBIOS_RECEIVE_DATAGRAM, cAdapterNum);

	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	lpNCB->cNum = cNum;
	lpNCB->lpBuffer = szBuffer;
	lpNCB->wLength = *wBufLen;
	
	wErrCode = SubmitNCB(Mode, lpNCB, hwndPost);
	
	if (wErrCode == 0)
	{
		_fmemcpy(lpNCB->cCallName, szCallName, lstrlen(szCallName));
		*wBufLen = lpNCB->wLength;
	}
	
	DestroyNCB(lpNCB);
	return(wErrCode);
}


WORD FAR PASCAL _export PostReceiveDatagram(BYTE  cAdapterNum, BYTE  cNum, LPSTR szBuffer,     
	WORD  wBufLen, HWND  hwndPost, WORD  wMsgPost, WORD  wParam, LPNCB FAR *lpRetNCB) 
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	if (!IsWindow(hwndPost))
	{
		return(NB_INVALID_WINDOW);
	}
	
	lpNCB = CreateNCB(NETBIOS_RECEIVE_DATAGRAM, cAdapterNum);
	
	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	lpNCB->cNum = cNum;
	lpNCB->lpBuffer = szBuffer;
	lpNCB->wLength = wBufLen;
	
	wErrCode = PostNetBIOS(lpNCB,hwndPost,wMsgPost,wParam);
	
	if (wErrCode != 0)
	{
		DestroyNCB(lpNCB);
	}
	else
	{
		*lpRetNCB = lpNCB;
	}
	return(wErrCode);
}

WORD FAR PASCAL _export Cancel(BYTE  cAdapterNum, LPNCB lpPreviousNCB) 
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	lpNCB = CreateNCB(NETBIOS_CANCEL, cAdapterNum);
	
	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	lpNCB->lpBuffer = (LPSTR) lpPreviousNCB;
	wErrCode = SendNetBIOS(lpNCB);
	
	DestroyNCB(lpNCB);
	return(wErrCode);
}

WORD FAR PASCAL _export Reset(BYTE  cAdapterNum, BYTE  cMaxLSN, BYTE  cMaxCmd)      
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	lpNCB = CreateNCB(NETBIOS_RESET, cAdapterNum);
	
	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	lpNCB->cLSN = cMaxLSN;
	lpNCB->cNum = cMaxCmd;
	
	wErrCode = SendNetBIOS(lpNCB);
	
	DestroyNCB(lpNCB);
	return(wErrCode);
}

WORD FAR PASCAL _export SessionStatus(WMODE  Mode, BYTE  cAdapterNum, LPSTR szName,       
	LPSESSIONSTAT lpSessionStat, LPWORD wBufLen, HWND   hwndPost)    
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	lpNCB = CreateNCB(NETBIOS_SESSION_STATUS, cAdapterNum);
	
	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	_fmemcpy(lpNCB->cName, szName, lstrlen(szName));
	lpNCB->lpBuffer = (LPSTR) lpSessionStat;
	lpNCB->wLength = *wBufLen;
	
	wErrCode = SubmitNCB(Mode, lpNCB, hwndPost);
	
	if (wErrCode == 0)
	{
		*wBufLen = lpNCB->wLength;
	}
	
	DestroyNCB(lpNCB);
	return(wErrCode);
}

WORD FAR PASCAL _export PostSessionStatus(BYTE  cAdapterNum, LPSTR szName, 
	LPSESSIONSTAT lpSessionStat, WORD  wBufLen, HWND  hwndPost, WORD  wMsgPost, WORD  wParam,       
	LPNCB FAR *lpRetNCB) 
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	if (!IsWindow(hwndPost))
	{
		return(NB_INVALID_WINDOW);
	}
	
	lpNCB = CreateNCB(NETBIOS_SESSION_STATUS, cAdapterNum);
	
	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	_fmemcpy(lpNCB->cName, szName, lstrlen(szName));
	lpNCB->lpBuffer = (LPSTR) lpSessionStat;
	lpNCB->wLength = wBufLen;
	
	wErrCode = PostNetBIOS(lpNCB,hwndPost,wMsgPost,wParam);
	
	if (wErrCode != 0)
	{
		DestroyNCB(lpNCB);
	}
	else
	{
		*lpRetNCB = lpNCB;
	}
	return(wErrCode);
}

WORD FAR PASCAL _export AdapterStatus(WMODE  Mode, BYTE  cAdapterNum, LPSTR szCallName,   
	LPLANASTAT lpLanaStat, LPWORD   wBufLen, HWND     hwndPost)  
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	lpNCB = CreateNCB(NETBIOS_ADAPTER_STATUS, cAdapterNum);

	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	_fmemcpy(lpNCB->cCallName, szCallName, lstrlen(szCallName));
	lpNCB->lpBuffer = (LPSTR) lpLanaStat;
	lpNCB->wLength = *wBufLen;
	
	wErrCode = SubmitNCB(Mode, lpNCB, hwndPost);
	
	if (wErrCode == 0)
	{
		*wBufLen = lpNCB->wLength;
	}
	
	DestroyNCB(lpNCB);
	return(wErrCode);
}


WORD FAR PASCAL _export PostAdapterStatus(BYTE  cAdapterNum, LPSTR szCallName, 
	LPLANASTAT lpLanaStat, WORD  wBufLen, HWND  hwndPost, WORD  wMsgPost,     
	WORD  wParam, LPNCB FAR *lpRetNCB) 
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	if (!IsWindow(hwndPost))
	{
		return(NB_INVALID_WINDOW);
	}
	
	lpNCB = CreateNCB(NETBIOS_ADAPTER_STATUS, cAdapterNum);
	
	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	
	_fmemcpy(lpNCB->cCallName, szCallName, lstrlen(szCallName));
	lpNCB->lpBuffer = (LPSTR) lpLanaStat;
	lpNCB->wLength = wBufLen;
	
	wErrCode = PostNetBIOS(lpNCB,hwndPost,wMsgPost,wParam);
	
	if (wErrCode != 0)
	{
		DestroyNCB(lpNCB);
	}
	else
	{
		*lpRetNCB = lpNCB;
	}
	return(wErrCode);
}

WORD FAR PASCAL _export UnlinkRPL(BYTE cAdapterNum)  
{
	LPNCB  lpNCB;
	WORD   wErrCode;
	
	lpNCB = CreateNCB(NETBIOS_UNLINK, cAdapterNum);
	
	if (lpNCB == NULL)
	{
		return(NB_NO_FREE_NCB_ERR);
	}
	wErrCode = SendNetBIOS(lpNCB);
	
	DestroyNCB(lpNCB);
	return(wErrCode);
}

LPSTR FAR PASCAL _export WNB_Error()
{
	static char errtxt[80];
	int rc;
	
	rc = LoadString(hLibrary, 100 + net_errno, errtxt, sizeof(errtxt));
	
	if(rc == 0)
	{
		wsprintf(errtxt, "Kein/Unbekannter Fehler (0x%x)", net_errno);
	}
	return(errtxt);
}
