;
; Sample startup file for notGNU emacs (notgnu.st).
; Last modified Tue Dec 7 1993, by Tor Slettnes
; This form of file can be loaded at anytime using
; the extended command load-file.
;

; Default is to make backups; uncommenting the following
; line will turn backups off.
; (toggle-make-backups)


; Default is to NOT check whether a file is edited in two
; places at once; the following will enable this check.
(toggle-check-file-timestamp)


; Default is not to display linenumber in the modeline; 
; The following toggles line numbers on.
(toggle-show-linenumber)


; Default is to provide no linewrapping, and no autoindent.
; The following lines enable these features; when used in
; combination, overflow (wrapped) text will automatically
; be indented.  Nifty for editing text files. :-)
(auto-fill-mode)               ; First buffer opened
(auto-indent-mode)             ; First buffer opened
(set-default-mode 'fill)       ; Subsequent buffers
(set-default-mode 'indent)     ; Subsequent buffers


; Default is to query before killing any modified buffer,
; including *scratch*. Uncommenting the following line
; will disable queries for buffers with no file association.
; (query-save-buffers '0)


; Default is to query before inserting output from a subtask
; such as compile into a NotGNU buffer. The following line
; causes NotGNU to insert the output automatically, without
; query.
if !DOS (query-on-subtask-done '0)


; Default is to highlight the background on mouse selections.
; Uncomment if you want to highlight the foreground (text) instead:
; (set-select-highlight 'f)


; Unix text file format specifies that only LF be used to
; indicate newline, while in DOS and Windows CR is output
; before every LF.  Default for DNOT, WNOT, NTNOT is to use
; DOS file format; uncommenting the following line will
; cause Unix format to be used instead.
; (toggle-just-write-newline)


; GNU-like autocompletion is not set by default; the GNU-ness
; isn't perfect yet. :(  Uncomment if you are a die-hard GNU.
; (set-gnu)


; Default autosave interval is 15 seconds.
; Let's be a little more macho than that.
if !DOS (set-autosave-inc '120)


; The following toggles the time display in the title bar under
; Windows. Uncomment if you are using a utility like 'barclock',
; 'tick-it' etc..
if Win3  (display-time)
if WinNT (display-time)


; Various keybindings. Basic syntax:
; "\^x" is ctrl-x
; "\F1" is function key F1
; "\Eo" is alt-o (or meta-o, ESC o)
; "\Kp-+" is keypad +
; "\Backspace" is a named key
; "\SBackspace" is shift + a named key
; "\CBackspace" is control + a named key
; "\MBackspace" is alt + a named key
; See documentation for details

(define-key C "\^c\^c"        'compile)     ; C map only

(global-set-key "\F1"         'goto-line)
(global-set-key "\F8"         'other-window)
(global-set-key "\e+"         'enlarge-window)
(global-set-key "\e-"         'shrink-window)
(global-set-key "\^z"         'scroll-one-line-up)
(global-set-key "\ez"         'scroll-one-line-down)
(global-set-key "\^x`"        'next-error)

(global-set-key "\^x\^i"      'insert-file)
(global-set-key "\^x!"        'shell-command)
(global-set-key "\^_"         'undo)

(global-set-key "\efx"        'save-buffers-kill-emacs) ; Alt-F x
(global-set-key "\efs"        'save-buffer)             ; Alt-F s
(global-set-key "\Insert"     'set-mark-command)        ; A Demacs thing



; These they will fail in the DOS version because
;   (1) these are not legal DOS commands or
;   (2) fkeys beyond 10 are not visible.
; ``if <os>'' and ``if !<os>'' are supported; case sensitive!
; Legal <os> values are DOS, Win3, WinNT, X11

if !DOS (global-set-key "\F2"         'shell-window)
if !DOS (global-set-key "\F9"         'make)
if !DOS (global-set-key "\F10"        'next-error)
if !DOS (global-set-key "\F12"        'undo)

if !DOS (global-set-key "\^z"         'shell-window)
if  DOS (global-set-key "\^z"         'shell-command)
