/***********************************************************************
**
** CLIDLG.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
** This is the base Client Dialog Class Implementation.
** Most of the common functionality to handle the clients dialogs
** (nb not sockets) is here.
**
** V1.0 - Initial Revision 01-Sep-94
**
*/

#include "stdafx.h"
#include <stdarg.h>
#include "windis.h"
#include "utility.h"
#include "csocket.h"
#include "clidlg.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CClientDlg dialog
CClientDlg::CClientDlg() :
	 CDialog()
{
	// Initialise my counter
	m_KickTime = 0;
	m_Bitmap = NULL;         
	m_Icon = NULL;
	m_sizeFixedLayout.cx = 32767;
	m_sizeFixedLayout.cy = 32767;
}
                  
CClientDlg::~CClientDlg()
{
	delete m_Bitmap;
	m_Bitmap = NULL;
}

BEGIN_MESSAGE_MAP(CClientDlg, CDialog)
	//{{AFX_MSG_MAP(CClientDlg)
		// NOTE: the ClassWizard will add message map macros here
	ON_MESSAGE( WM_SIZEPARENT, OnSizeParent)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CClientDlg message handlers

// These may be called many times for the same icon
// for example, in the SMtp server dialog.
// And there may already be a bitmap so we take care
// in this and in the ClearIcon() function not to 
// create two bitmaps and thus to lose one of them somewhere
void CClientDlg::SetIcon( CStatic * Icon )
{
	ASSERT_VALID( this );
	ASSERT_VALID( Icon );

	if( m_Icon == NULL )
		m_Icon = Icon;                        
	if( m_Bitmap == NULL )
		m_Bitmap = new CAnimatedBitmap(Icon);
}

void CClientDlg::ClearIcon()
{
	// This is generally called only once
	m_Icon = NULL;
	delete m_Bitmap;
	m_Bitmap = NULL;
}
	                                  
// This is a nice interface version of trace.  Slow but what the fuck.
void CClientDlg::TPrintf( 	int  TraceLevel,
            				const char * pszFormat,
            				... )
{        
	ASSERT( TraceLevel >= 0 );                                
   	char * szOutput = new char[ 512 ]; // should be enough
   	va_list ArgList;

	va_start( ArgList, pszFormat );
   	wvsprintf( szOutput, pszFormat, ArgList );
   	va_end( ArgList );
	Trace( TraceLevel , szOutput );  // Calls the derived trace
   	delete [] szOutput;
	return;
}

// This is the String resource version of trace
void CClientDlg::Trace( int Level , UINT nId )
{
	CString Tmp;	
	if( Tmp.LoadString( nId ) )
		Trace( Level , Tmp );
	else
		ASSERT( 0 == 1 );  // Never called in production version.
}
	
BOOL CClientDlg::Create(UINT nID , CWnd* pParentWnd )
{              
	ASSERT_VALID( pParentWnd );
	if( CDialog::Create( nID , pParentWnd ) )
	{
		CRect rect;
		GetWindowRect(&rect);
		m_sizeFixedLayout = rect.Size();    // set fixed size

		// OR in the control bar sub-style
		::SetWindowLong(m_hWnd, GWL_STYLE, GetStyle() | WS_CLIPSIBLINGS);
		// force the size to zero - resizing bar will occur later
		SetWindowPos(NULL, 0, 0, 0, 0, SWP_NOZORDER|SWP_NOACTIVATE|SWP_SHOWWINDOW);
		return TRUE;
	}               
	else
		return FALSE;
}
              
LRESULT CClientDlg::OnSizeParent(WPARAM, LPARAM lParam)
{
	ASSERT_VALID( this );
	
	AFX_SIZEPARENTPARAMS FAR* lpLayout = (AFX_SIZEPARENTPARAMS FAR*)lParam;

	// resize and reposition this control bar based on styles
	DWORD dwStyle = GetStyle();

	if (dwStyle & WS_VISIBLE) 
	{
		// align the control bar
		CRect rect;    
		CSize Size;
	
		GetClientRect( rect );
		Size.cx = rect.Width();
		Size.cy = rect.Height();

		rect.CopyRect(&lpLayout->rect);
        
        
		CSize sizeAvail = rect.Size();  // maximum size available
		CSize size;     // maximum requested size
		size.cx = min(m_sizeFixedLayout.cx, sizeAvail.cx);
		size.cy = min(m_sizeFixedLayout.cy, sizeAvail.cy);
		
		// top align (stretch width)
		size.cx = sizeAvail.cx;
		lpLayout->rect.top += size.cy;

		rect.right = rect.left + size.cx;
		rect.bottom = rect.top + size.cy;
		_AfxRepositionWindow(lpLayout, m_hWnd, &rect);
	}
	return 0;
}
              
