/***********************************************************************
**
** CANIBMP.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
** It is the implementation of the CAnimatedBitmap class.
** This class responsible for animating itself in a particular
** location
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
// NEWSUP.H
// Special Structures and defines for the windows version
// of unbatch, expire and alias etc
#ifndef _NEWSSUP_H
#define _NEWSSUP_H

#define DLLEXPORT FAR PASCAL _export            

#define NEWS_BUF_LEN	512

typedef struct lines {
    char         *data;               /* line of text           */
    struct lines *next;               /* next line              */
    struct lines *last;               /* last line              */
    int           index;              /* line number from start */
} LINES;


// The Lock Class
class CNewsLock {
  public:
      CNewsLock( const char * dir, const char * id, const char * name );
      ~CNewsLock();
      BOOL IsLocked() { return FileName != NULL; }
  private:
      char * FileName;
      BOOL   Locked;
};

// The Active Class
class CActive : public CObject {
  public:
    CActive( char * ActiveLine );
    ~CActive();            
    DWORD GetLoNum() const { return lo_num; }
    DWORD GetHiNum() const { return hi_num; }
    void IncLoNum() { lo_num++; }
    void IncHiNum() { hi_num++; }
    const char * GetGroup() const { return (const char *)group; }
    const char * GetFile() const { return (const char *)gp_file; }
    const BOOL IsSuspend() const { return m_Suspend; }
    CString GetGroupFile( const char * NewsDir ) 	{ return GetFileName( NewsDir , "."   );}
    CString GetIndexFile( const char * NewsDir ) 	{ return GetFileName( NewsDir , ".idx");}
	CString GetNewGroupFile( const char * NewsDir ) { return GetFileName( NewsDir , ".new");}
	CString GetNewIndexFile( const char * NewsDir ) { return GetFileName( NewsDir , ".ndx");}    
    BOOL IsOk() const { return Ok; }
    void	ClearNums() { lo_num = hi_num = 0; }
  private:  
  	CString		GetFileName( const char * Dir , const char * Ext);
    CString     group;         /* group name                              */
    CString     gp_file;        /* name of the file that the data is in    */
    DWORD       lo_num;            /* lowest number less one                  */
    DWORD       hi_num;            /* highest number                          */
	BOOL 		m_Suspend;
    BOOL		Ok;
};
          
class CActiveList {
  public:
	CActiveList( const char * FileName );
	~CActiveList();
	CActive * FindGroup( const char * Groupname );
	POSITION GetStartPosition();
	CActive * GetNextGroup( POSITION& Pos );
	BOOL IsOk() { return Ok; }
	BOOL WriteActive();
	int GetGroupCount() { return GroupList->GetCount(); }
  private:
    CMapStringToOb * GroupList;
    BOOL Ok;                                  
    CString m_FileName;
};
	
class HIST_LIST {
  public:
    long mid;       /* hashed Message-ID: */
    int ngroups;    /* Number of groups in Newsgroups: */
    long offset;    /* ftell() of where in history list this entry is */
    HIST_LIST  *next;
};
                 
class CHistoryList {
	public:
		CHistoryList( const char * FileName );
		~CHistoryList();
		int  AddToHistList(const char *p, int ct, long where);
		void AddHistRecord(const char *msg_id, const char * ng, CActiveList * Act);
		HIST_LIST * FindMsgId( const char * msg_id );
		BOOL IsOk() const { return Ok; }
	private:
		void LoadHistoryList( int All );
		void FreeHistList();
		CStdioFile * hist;
		HIST_LIST *hlist;
		HIST_LIST *hlistend;
		BOOL Ok;
};
		
                      
// The Option Types
#define UNBATCH_CROSSPOST_TO_JUNK 	0x01
#define UNBATCH_REMOVE_BATCH		0x02
#define UNBATCH_CHECKDISK			0x04

class CUnbatchSetupInfo {
  public:          
	CString  NewsDir;
	CString NewsBaseDir;
	CString BatchDir;  
	CString Site;
	int UnbatchOptions;
// These are filled in during processing
	unsigned long LargestArt;
	int	ArticleCount;                   
	int DuplicateCount;
// And these are just helper functions to access the options 
	BOOL CrossPostToJunk() const { return UnbatchOptions & UNBATCH_CROSSPOST_TO_JUNK; }
	BOOL CheckSpace() const { return UnbatchOptions & UNBATCH_CHECKDISK; }
	BOOL RemoveBatch() const { return UnbatchOptions & UNBATCH_REMOVE_BATCH; }
};

class CExpireSetupInfo {
  public:          
	CString  NewsDir;
	CString NewsBaseDir;
	CString BatchDir;  
	CString Site;
	int ExpireDaysOverRide; 
};
// The utility functions defined in wnewssup.cpp
extern BOOL IsToken( char * buf , unsigned long& Length );

#endif

