// This may look like C code, but it is really -*- C++ -*-
//
// Copyright 1993 by Peter Bentley <pete@tecc.co.uk>
//
// Permission to use, copy, modify, distribute, and sell this software and its
// documentation for any purpose is hereby granted without fee, provided that
// the above copyright notice appear in all copies and that both that
// copyright notice and this permission notice appear in supporting
// documentation, and that the name of Peter Bentley not be used in
// advertising or publicity pertaining to distribution of the software without
// specific, written prior permission.  Peter Bentley makes no representations
// about the suitability of this software for any purpose.  It is provided
// "as is" without express or implied warranty.
//
// PETER BENTLEY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
// INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
// EVENT SHALL PETER BENTLEY BE LIABLE FOR ANY SPECIAL, INDIRECT OR
// CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
// DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
// TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THIS SOFTWARE.
//

// tclog.h - TECC classes to provide a common error logging API
//
// $Id: tclog.h,v 1.1 1993/09/02 12:33:58 pete Exp pete $
//
#ifndef _TCLOG_H
#define _TCLOG_H

/////////////////////////////////////////////////////////////////////////////
// Constants for debug message level
enum tcLogLevel {
	TC_DEBUG,				// Real low-level stuff
	TC_TRACE,				// General trace stuff
    TC_OPER,				// Start of an operation
	TC_INFO,				// Informational
	TC_STATE,				// Application state
    TC_WARNING,				// Warning information
	TC_ERROR,				// Real errors
};

/////////////////////////////////////////////////////////////////////////////
// Class for logging error messages
//
// Trivial, really.  All code which outputs log messages has a tcLogger
// and outputs messages through the log() or logf() members.  There is a
// default logf() which calls vsprintf() then passes the string to log().
// Log() should be overridded to do the right thing with messages for each
// log level (write them to file, dialogue box or whatever).

class tcLogger {            
  public:
  	tcLogger();
  	~tcLogger();
  protected:
	static const char *logLevelName[];
	char * m_Buffer;
  public:
	virtual void	logf(tcLogLevel lev, const char *fmt, ...);
	virtual void	log(tcLogLevel lev, const char *string)			=0;
};

#endif // _tcLog_h_
