/***********************************************************************
**
** UTILITY.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
**
** Well, there has to be somewhere to stick all the utility functions
** and this is it.  The whole timeout structure is supposed to
** be here as well but I got bored with it.
** This needs to be added.
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
// Utility.cpp
// All the utility functions for Windis stuffed in one file.
// Also includes the socket timeout functions.
#include "stdafx.h"
#include <stdarg.h>
#include "windis.h"
#include "utility.h"
#include "tcsock.h"


///////////////////////////////////////////////////////
// Socket timeout
// This could be an object but we're going to call this
// functionality a lot on a timer and so I want to make it
// as fast as possible
#define MAX_TIMEOUT_SOCKETS 32
static const UINT s_TimeoutStrings[] = {
		IDS_TIMEOUT_NOTHING,
		IDS_TIMEOUT_CONNECTING,
		IDS_TIMEOUT_READING,
		IDS_TIMEOUT_WRITING,
		IDS_TIMEOUT_RESOLVING
};

// The private data structure
class CMgrStruct 
{
  public:
	int		m_Timeout;
	CTimeoutType	m_Type;
	tcSocket * 	m_Sock;
};

static CMgrStruct s_TimeoutArray[ MAX_TIMEOUT_SOCKETS ];

// The manager functions
// These will be optimised later

HTIMEOUT TimeoutAddSocket( tcSocket * Sock )
{
	for( int i = 0 ; i < MAX_TIMEOUT_SOCKETS ; i++ )
	{
		if( s_TimeoutArray[ i ].m_Sock == NULL )
		{
			// Got it
			s_TimeoutArray[ i ].m_Timeout = 0;
			s_TimeoutArray[ i ].m_Type = TO_NONE;
			s_TimeoutArray[ i ].m_Sock = Sock;
			return HTIMEOUT( i );
		}
	}
	// You're fucked if you get here!
	ASSERT( FALSE );
	return HTIMEOUT( -1 );
}

HTIMEOUT TimeoutAddSocket( tcSocket * Sock , int Secs , CTimeoutType Type )
{
	HTIMEOUT hTimeout = TimeoutAddSocket( Sock );
	TimeoutSet( hTimeout , Secs , Type );
	return hTimeout;
}

void TimeoutRemSocket( tcSocket * Sock )
{
	HTIMEOUT hTimeout = TimeoutFindSocket( Sock );
	TimeoutRemSocket( hTimeout );
}

void TimeoutRemSocket( HTIMEOUT hTimeout )
{
	ASSERT( hTimeout >= 0 );
	ASSERT( hTimeout < MAX_TIMEOUT_SOCKETS );
	s_TimeoutArray[ hTimeout ].m_Timeout = 0;
	s_TimeoutArray[ hTimeout ].m_Type = TO_NONE;
	s_TimeoutArray[ hTimeout ].m_Sock = NULL;
}

void TimeoutSet( HTIMEOUT hTimeout , int Secs , CTimeoutType Type )
{
	ASSERT( hTimeout >= 0 );
	ASSERT( hTimeout < MAX_TIMEOUT_SOCKETS );
	s_TimeoutArray[ hTimeout ].m_Timeout = Secs;
	s_TimeoutArray[ hTimeout ].m_Type = Type;
}

void TimeoutSet( tcSocket * Sock , int Secs , CTimeoutType Type )
{
	HTIMEOUT hTimeout = TimeoutFindSocket( Sock );
	TimeoutSet( hTimeout , Secs , Type );
}

void TimeoutClr( HTIMEOUT hTimeout )
{
	ASSERT( hTimeout >= 0 );
	ASSERT( hTimeout < MAX_TIMEOUT_SOCKETS );
	s_TimeoutArray[ hTimeout ].m_Timeout = 0;
}

void TimeoutClr( tcSocket * Sock )
{
	HTIMEOUT hTimeout = TimeoutFindSocket( Sock );
	TimeoutClr( hTimeout );
}

HTIMEOUT TimeoutFindSocket( tcSocket * Sock )
{
	for( int i = 0 ; i < MAX_TIMEOUT_SOCKETS ; i++ )
	{
		if( s_TimeoutArray[ i ].m_Sock == Sock )
			return HTIMEOUT( i );
	}
	ASSERT( FALSE );
	return HTIMEOUT( -1 );
}

CTimeoutType TimeoutFindType( HTIMEOUT hTimeout )
{
	ASSERT( hTimeout >= 0 );
	ASSERT( hTimeout < MAX_TIMEOUT_SOCKETS );
	return s_TimeoutArray[ hTimeout ].m_Type;
}

int TimeoutTypeId( CTimeoutType Type )
{
	return s_TimeoutStrings[ Type ];
}                

int TimeoutGetId( tcSocket * Sock )
{
	return s_TimeoutStrings[ TimeoutFindType( TimeoutFindSocket( Sock ) ) ];
}

void TimeoutDoTick()
{
	for( int i = 0 ; i < MAX_TIMEOUT_SOCKETS ; i++ )
	{
		if( s_TimeoutArray[ i ].m_Timeout == 0 )
			continue;
		if( --(s_TimeoutArray[ i ].m_Timeout) == 0 )
			s_TimeoutArray[ i ].m_Sock->Timeout();
	}
}



/////////////////////////////////////////////////////
// Global Functions

void NotImplemented()
{
}


// This function takes a username string and turns it into something
// real.                             
static const char * const BadDosCharacters = "\"'`%^&*?() \t\n{}[]#~<>.,:;";

BOOL ValidateFileName( CString &User )
{       
	const char * p;
	for ( p = BadDosCharacters; *p != '\0'; p++)
	{
		if (strchr ((const char *)User, *p) != NULL )
		{
			return FALSE;
		}
	} 
	return TRUE;
}
	                             
// Parses a string of the form
// user@host into the string User and the string Host
// If the string is bracketted in "<" and ">" (which many
// strings are, they are removed.
// This function will also handle user@host1@host2 and turn it
// into user@host1 and host2. 
// Maximum length is 128;
BOOL ParseUserHost( const char * In , CString &User , CString &Host )
{                            
	User = "";
	Host = "";
	char Buffer[ 128 ];
	if( *In == '<' )
		In++;
	strncpy( Buffer , In , 127 );
	int Len = strlen( Buffer );
	if( Len == 0 )  
		return FALSE;

	if( Buffer[ Len - 1 ] == '>' )
	{
		Buffer[ Len - 1 ] = '\0';
		Len--;
	}
	// first check for something
	char * p = strrchr( Buffer , '@' );
	if( p == NULL )
	{                
		// User only?
		User = Buffer;
		if( !ValidateFileName( User ) )
			User = gConfig->GetDefaultRecipient();
		return TRUE;
	}
	// Split the string
	*p = '\0';
	p++;
	Host = p;
	User = Buffer;               
	if( !ValidateFileName( User ) )
		User = gConfig->GetDefaultRecipient();
	return TRUE;
}		
	                                       
// Pretty interface to MessageBox which allows printf like args
int MsgBox( UINT  fuType,
            			LPSTR pszFormat,
            			... )
{
	ASSERT( strlen( pszFormat ) > 0 );
	char * szOutput = new char[ 512 ]; // should be enough
	va_list ArgList;

	va_start( ArgList, pszFormat );
	wvsprintf( szOutput, pszFormat, ArgList );
	va_end( ArgList );

	HWND hWnd = AfxGetApp()->m_pMainWnd->GetSafeHwnd();
	int ret = ::MessageBox( hWnd , szOutput, AfxGetAppName() , fuType );
	delete [] szOutput;
	return ret;
}   // MsgBox
                     
          
// Overloaded MsgBox to load strings
int MsgBox( UINT  fuType,
            			UINT nId,
            			... )
{
	CString Tmp;
	if( Tmp.LoadString( nId ) )
	{                      
		const char * pszFormat = Tmp;
		ASSERT( strlen( Tmp ) > 0 );
		char * szOutput = new char[ 512 ]; // should be enough
		va_list ArgList;
		va_start( ArgList, pszFormat );
		wvsprintf( szOutput, pszFormat, ArgList );
		va_end( ArgList );

		HWND hWnd = AfxGetApp()->m_pMainWnd->GetSafeHwnd();
		int ret = ::MessageBox( hWnd , szOutput, AfxGetAppName() , fuType );
		delete [] szOutput;
		return ret;
	}
	else             
	{
		ASSERT( 0 == 1 ); 
		return FALSE;
	}
}
		          
// Print out the Winsock Error                     
void SocketError( tcSocket * Sock , int Error )
{
	if( Error != 0 && Sock != NULL )
		::MsgBox( MB_OK | MB_ICONSTOP, 
				"%s" , Sock->sockErrMessage( Error ) );
};

BOOL FileExist( const char * FName )
{
	CFileStatus Stat;
	return CFile::GetStatus( FName , Stat );
}

BOOL DirExist( const char * FName )
{
	CFileStatus Stat;
	if( CFile::GetStatus( FName , Stat ) )
	{
		if( Stat.m_attribute & CFile::directory )
			return TRUE;
	}
	return FALSE;
}

BOOL OpenOrCreate( CFile &File , const char * Name , UINT Flags )
{
	if( !File.Open( Name , Flags ) )
		return File.Open( Name , Flags | CFile::modeCreate );
	else
		return TRUE;
}
/////////////////////////////////////////////////////////////////////////////
// Path creation functions 
CString GetNewsDirName()
{
	CString Dir = gConfig->GetKA9QRoot();
	return Dir + "\\spool\\news";
}

CString GetNewsActiveListName()
{
	CString Dir = GetNewsDirName();
	return Dir + "\\active.";
}	

CString GetNewsGroupListName()
{
	CString Dir = gConfig->GetKA9QRoot();
	return Dir + "\\active.dis";
}                                                    

CString GetNewsNewgroupName()
{
	CString Dir = GetNewsDirName();
	return Dir + "\\newgroup";
}
CString GetNewsHistoryName()
{
	CString Dir = GetNewsDirName();
	return Dir + "\\history";
}
CString GetSNewsHistoryName()
{
	CString Dir = GetNewsHistoryName();
	return Dir + ".snw";
}              
       
CString GetNewsBatchFileName()
{
	CString Dir = gConfig->GetKA9QRoot();
	return Dir + "\\spool\\articles\\batch.txt";
}

CString GetNewsDataName()
{
	CString Dir = GetNewsDirName();
	return Dir + "\\nntp.dat";
}                     

CString GetNewsBaseDirName()
{
	CString Dir = GetNewsDirName();
	return Dir + "\\newsbase";
}


/////////////////////////////////////////////////////////////////////////////
// CStatusDlg dialog


CStatusDlg::CStatusDlg()
	: CDialog()
{
	//{{AFX_DATA_INIT(CStatusDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	Create( CStatusDlg::IDD );
	m_Low = m_High = 0;
	m_Brush = new CBrush( RGB( 0 , 0 , 255 ) );
}
      
CStatusDlg::~CStatusDlg()
{
	DestroyWindow();
	delete m_Brush;
}

void CStatusDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CStatusDlg)
	DDX_Control(pDX, IDC_STAT_RECT, m_Rect);
	DDX_Control(pDX, IDC_STAT_LINE3, m_Line3);
	DDX_Control(pDX, IDC_STAT_LINE2, m_Line2);
	DDX_Control(pDX, IDC_STAT_LINE1, m_Line1);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CStatusDlg, CDialog)
	//{{AFX_MSG_MAP(CStatusDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CStatusDlg message handlers

BOOL CStatusDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow();	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CStatusDlg::SetThermPos( UINT Pos )
{               
        
	ASSERT( m_Low != m_High );
	if( m_Pos == Pos )
		return; 
	CRect BarRect;
	m_Rect.GetWindowRect( BarRect );
	ScreenToClient( BarRect );
	CSize Size = BarRect.Size();
	Size.cx = (int)(((long )Size.cx * (long)Pos) / ( m_High - m_Low ) );	
	CRect NewRect( BarRect.TopLeft() , Size );
	           
	CDC * DC = GetDC();
	DC->FillRect( NewRect , m_Brush );
	ReleaseDC( DC );
	m_Pos = Pos;
}
