/***********************************************************************
**
** CANIBMP.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
** It is the implementation of the CAnimatedBitmap class.
** This class responsible for animating itself in a particular
** location
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
// Utility.h
// Declarations of the utility functions which are
// defined in utility.cpp

#ifndef _UTILITY_H
#define _UTILITY_H


//////////////////////////////////////////////////////////////////////
// Timeout stuff
// We need the forward declarations of the tcsocket class
class tcSocket;
// The various types of things which can be timeouts
enum CTimeoutType {
	TO_NONE, // wierd!
	TO_CONNECTING,
	TO_READING,
	TO_WRITING,
	TO_RESOLVING
};                             
                                            
#define TIMEOUT_CONNECT		40 /* 40 seconds */
#define TIMEOUT_READ		20 /* 20 seconds */
#define TIMEOUT_WRITE		10 /* 10 seconds */
                                            
typedef short HTIMEOUT;

// These will all be inlines after debugging

HTIMEOUT	TimeoutAddSocket( tcSocket * Sock );
HTIMEOUT	TimeoutAddSocket( tcSocket * Sock , int Secs , CTimeoutType Type );
void		TimeoutRemSocket( tcSocket * Sock );
void		TimeoutRemSocket( HTIMEOUT   hSock );
void		TimeoutSet(	HTIMEOUT hSock , int Secs , CTimeoutType Type );
void		TimeoutSet( tcSocket * Sock, int Secs , CTimeoutType Type );
void		TimeoutClr( HTIMEOUT hSock );
void		TimeoutClr( tcSocket * Sock );
HTIMEOUT	TimeoutFindSocket( tcSocket * Sock );
CTimeoutType TimeoutFindType( HTIMEOUT hTimeout );
int			TimeoutTypeId( CTimeoutType Type );
int			TimeoutGetId( tcSocket * Sock );
void		TimeoutDoTick();

 

// Some messagebox definitions Not yet complete
#define MSG_INFO
#define MSG_MILD_ERROR
#define MSG_SEVERE_ERROR



///////////////////////////////////////////
// Global Functions
void SocketError( tcSocket * Sock , int Error );
BOOL ValidateFileName( CString &User );
BOOL ParseUserHost( const char * In , CString &User , CString &Host );
int MsgBox( UINT  fuType,LPSTR pszFormat,... );
int MsgBox( UINT  fuType,UINT nId,...);
BOOL FileExist( const char * Str );    
BOOL DirExist( const char * Str );
BOOL OpenOrCreate( CFile &File , const char * Name , UINT Flags );

// Filename functions
CString GetNewsDirName();
CString GetNewsActiveListName();
CString GetNewsGroupListName();
CString GetNewsNewgroupName();
CString GetNewsHistoryName();
CString GetSNewsHistoryName();
CString GetNewsBatchFileName();
CString GetNewsBaseDirName();
CString GetNewsDataName();


/////////////////////////////////////////////////////////////////////////////
// CStatusDlg dialog

class CStatusDlg : public CDialog
{
// Construction
public:      
	CStatusDlg();	         
	~CStatusDlg();
	void SetTitle( const char * Title) { SetWindowText( Title ); }
	void Show() { ShowWindow( SW_SHOW ); }
	void Hide() { ShowWindow( SW_HIDE ); }
	void SetLine1(const char * Str) { m_Line1.SetWindowText( Str ); }
	void SetLine2(const char * Str) { m_Line2.SetWindowText( Str ); }
	void SetLine3(const char * Str) { m_Line3.SetWindowText( Str ); }
	void SetThermRange( UINT Low , UINT High ){ m_Low = Low; m_High = High; } 
	void SetThermPos( UINT Pos );
// Dialog Data
	//{{AFX_DATA(CStatusDlg)
	enum { IDD = IDD_STATUS_DLG };
	CStatic	m_Rect;
	CStatic	m_Line3;
	CStatic	m_Line2;
	CStatic	m_Line1;
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CStatusDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()       
  private:
  	UINT m_Low;
  	UINT m_High;
  	UINT m_Pos;
  	CBrush * m_Brush;
};        

#endif
