/***********************************************************************
**
** WINDIS.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** The Main program
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
// windis.cpp : Defines the class behaviors for the application.
//
// History.
// 01Jul94 	- **** Released Alpha 0.1 ****
// 01Jul94 	- Fixed bad SMTP header in message.cpp
// 04Jul94 	- Fixed some unbatching bugs
// 04Jul94 	- Centered all the dialogs.
// 04Jul94 	- Added code for window position placement.
// 04Jul94 	- Fixed code so nntp dialog loads the nntp historylist
// 			  rather than the socket to speed up second and subsequent
//			  connects.
// 05Jul94	- Added a general purpose Status Dialog
// 05Jul94	- Added a reindexing function to the program (uses CStatusDlg ).
// 05Jul94	- **** Released Alpha 0.2 ****
// 05Jul94	- Reorganised unbatching code to make a new class CUnbatcher
//			  which contains a CStatusDlg rather than an UnbatchDlg which
//			  handles all the interaction.  All setup now for idle time
//			  unbatching, reindexing and expiring rather than hogging
//			  the machine.
// 01Nov94  - Added a number of bug fixes in the reindex code from
//			  Jeremy Sonander (jeremy@silicom.demon.co.uk
//			  Added the ability to set the nntp batching anywhere
//			  from 1 to 12.  Why 12?  Who knows.  This involved
//			  adding a new config variable
//			  Also fixed a bug in the mail reciept which caused all
//			  mail to go to the one person.
//			  Also removed all references to the POP3 server from
//			  the menu items.  The hooks are still there in the
//			  code but it's just confusing for users to have the
//			  view and kick menu items.
//			  Took out the File Dialup menu item until somebody works out 
//			  a way of integrating Dial up into Windis.
//            And, removed all references to the services
//            as strings and substituted the numerics (i.e.
//            "nntp" -> 119).  Did this because people
//            seem to mostly not have services files.  I hate
//            doing it but it might cut down on 20 emails a day
//            from people without services files.
// 02Nov94 	- Took out the locking files from the unbatching routines.
//			  They weren't used really.  This also gave me the opportunity
//			  to clean up the file names and directory names.  All references
//			  to KA9Q file and directory names **should** now go through the
//            functions in UTILITY.CPP. 
// 07Nov94  - Fixed bug where nntp client died if the server closed the
//			  socket unexpectedly
// 09Nov94  - From:             Colin Spensley <colin@alecto.demon.co.uk>
//            NT Time Setting Code in timedlg.cpp.
// 10Nov94  - Added a simple SMTP Batch mechanism to the smtp client.
//			  Doesn't speed things up much but it's a start.
// 11Nov94	- Finally added the code to to Asynch Host Lookups.
//			  Now there are **No** synch calls in the program
//			  Still a remaining bug unfortunately
// 14Nov94	- Added Reindexer fixes from Jeremy Sondander and
//			  Expirer bug from Dave Hodgson.
// 15Nov94  - **Finally** found the bug in the Smtp Client code
//			  which caused the program to fail when the new concurrent
//    		  SMTP sessions code was in operation.  Tidied up the socket,
//			  msg and msg_list interaction.  You can now run as many
//            concurrent mail sessions as you like.  This speeds up sending
//            mail by a factor of 10 compared to pre-batch, pre-concurrent.
//			  Tidied up the display of sent messages.
// 15Nov94 	- Small (but annoying) display bugs.
// 16Nov94  - Fixed application title.
//            Added simplified setup dialog which gets executed if
//            the version has changed or there is no Ini file.
// 17Nov94  - Finally moved all the strings out of the data segment
//            into a string table.  Well, not all the strings but
//            a lot of them.  Also vectored all the messagebox calls
//            through one global message box funtion (::MsgBox).
//			  Found!  That annoying WSACleanup call which didn't
//            work.
//            There seem to be a lot of timeouts when you start.  I
//            wonder if this is a tcp/ip problem.
// 19Nov94  - Took out the pcode in mainfrm.  Also fixed tcsock
//            so that the global starter has a reference count
//            therefore when there are no sockets open, slip
//            connections can timeout (i.e. wsacleanup is called)
// 20Nov94  - Added an OnAppExit function to the MainForm to check
//            for the existance of a batch file and unbatch it on
//            exit.  Unfortunately, I can't see a good way to make
//            this unbatching work in the background.  Added the dialog
//            element as well and changed the setup defaults.
//			  Note that the timeouts on HostResolution are not there
//            at 6am in the morning! Makes me think that this is a demon
//			  problem not mine.     
// 21Nov94  - CODE FREEZE VERSION 1.0.
// 21Nov94  - It's always the same, you freeze the code and find a bug
//            Two in fact.  Firstly, the return of MsgBox isn't quite
//            what I expected and so the program GPFed if you tried to
//            unbatch when there was nothing there.
//            The other problem was that sometimes you get mail from
//            people who's mailer is crap and sends you stuff like
//            ""crap stuff"@yourhost.demon.co.uk".  Fixed this by
//            adding a default recipient.  This isn't very good
//            in the long term.  Owen I think is going to fix this
//            stuff up and add aliases and mail forwarding.
//            It's still slow loading the history file.  
//			  Also realised that we don't currently save newgroups.
//			  Fixed.
// 22Nov94  - I know I said it was code frozen but what the hell.
//            Added font setting to the Finger Window.  Cheap change
//			  really.
//            Added the facility to set a number of "DialerStrings" in the
//            windis.ini file. These are stored on a per config set basis
//            and copied to a global section [Dialer].  These strings can
//			  be read by Trumpet command files using lines like
//				$Dialer = "Dialer"
//				$filename = "windis.ini"
//				%ok = [load $DialString1 $Dialer $filename]    
//			  This means that by starting up windis with a different
//            setup set means that you can start cause dialing to different
//            sites.  Do do this, it's best to set the Start SMTP Listener
//            only option in the preferences.
// 23Nov94  - Fixing bugs.  One from the NT team which might have
//			  caused batches to have been lost.
//            Took out font setting in the finger window because it
//            wasn't working.  Next release.
//            Moved the about string to this file and added a
//            string to distinguish between the Windows version
//            and the windows NT version.

#include "stdafx.h"
#include <ctl3d.h>
#include <stdarg.h>
#include "windis.h"
#include "utility.h"
#include "tcsock.h"
#include "mainfrm.h"
#include "initdlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#ifdef WIN32
const char * SystemWindowTitle = "WinDis NT";
#else
const char * SystemWindowTitle = "WinDis";
#endif
static const char BASED_CODE SystemAboutInfo[] =
		"Windis is a free program written by Ewan Kirk "
		"(ewan@kirk.demon.co.uk).  It may be freely distributed "
		"subject to the usual disclaimers.  You are under no "
		"obligation whatsoever to pay for this program but if you "
		"wish to make a contribution of some sort then please mail "
		"me.  If you are using WinDis in a commercial environment then "
		"there's no obligation either but you might like to think about "
		"how much WinDis is worth to your organisation and then mail "
		"me.  The source code for the program has also been released into "
		"the public domain and is available from ftp.demon.co.uk.\r\n"
		"Please post bug reports to demon.ip.winsock and feature "
		"requests to demon.ip.developers.\r\n"
		"A Win32 version is available and the code was ported "
		"by Colin Spensley (colin@alecto.demon.co.uk)";

/////////////////////////////////////////////////////////////////////////////
// CWindisApp

BEGIN_MESSAGE_MAP(CWindisApp, CWinApp)
	//{{AFX_MSG_MAP(CWindisApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Global help commands
	ON_COMMAND(ID_HELP_INDEX, CWinApp::OnHelpIndex)
	ON_COMMAND(ID_HELP_USING, CWinApp::OnHelpUsing)
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CWinApp::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CWinApp::OnHelpIndex)
END_MESSAGE_MAP()


////////////////////////////////////////////////////////////////////////////
// Function to create the parent of the windows socket windows
// This is a cludge to try and fix the problem with IBM's stack
//
static HWND CreateWinsockParent()
{
	WNDCLASS WndClass;
	ATOM atom;

	WndClass.style			= 0;
	WndClass.lpfnWndProc	= ::DefWindowProc;
	WndClass.cbClsExtra	= 0;
	WndClass.cbWndExtra	= 0;
	WndClass.hInstance		= AfxGetInstanceHandle();
	WndClass.hIcon			= NULL;
	WndClass.hCursor		= NULL;
	WndClass.hbrBackground	= NULL;
	WndClass.lpszMenuName	= NULL;
	WndClass.lpszClassName	= "WinDisParent";

	atom = RegisterClass(&WndClass);
	if( atom == 0 ) 
	{
		::MsgBox( MB_OK | MB_ICONSTOP , IDS_MSG_COULDNT_REGISTER_PARENT_CLASS );
		return NULL;
	}
	HWND hWnd = CreateWindow("WinDisParent", "", 0 /* no style */, 0, 0, 0, 0,
						     NULL, NULL, AfxGetInstanceHandle(), NULL);
	if (hWnd == NULL) 
	{
		::MsgBox( MB_OK | MB_ICONSTOP , IDS_MSG_COULDNT_CREATE_PARENT_WINDOW );
		return NULL;
	}	           
	return hWnd;
}

/////////////////////////////////////////////////////////////////////////////
// CWindisApp construction

CWindisApp::CWindisApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CWindisApp object

CWindisApp NEAR theApp;


/////////////////////////////////////////////////////////////////////////////
// CWindisApp initialization

BOOL CWindisApp::InitInstance()
{
#ifdef _DEBUG
	m_StartState.Checkpoint();
	TRACE( "Checking Memory\n" );
#endif

		// Enable Ctl3D stuff
	Ctl3dRegister(AfxGetInstanceHandle());
	Ctl3dAutoSubclass(AfxGetInstanceHandle());

	// Create the global configuration object
	gConfig = new CWindisSetup;
	int Version = gConfig->GetVersion();
	if( Version == -2 ) // the -2 switch is a special one for
						// Owen's DisWin installer.  He sets
						// Version = -2 when he writes the
						// ini file and so I can not run the
						// setup.
	{
		Version = WINDIS_VERSION;
		gConfig->SetVersion( Version );
		gConfig->WriteGlobalSet();
	}
	if( Version != WINDIS_VERSION )
	{       
		// The version has changed or there's no info
		CInitialiseDlg Dlg;
		if( Dlg.DoModal() == IDOK )
		{                    
			// The user has decided to setup the app (pretty wise!)
			CInitSetupDlg SDlg;
			if( SDlg.DoModal() )
			{
				gConfig->NewSetupSet( "" , "Default" );
				gConfig->SetDefaultSet( "Default" );
				gConfig->WriteGlobalSet();
				gConfig->WriteCurrentSet();
			};
			
		}
	}
    // This should have loaded the default setup.  Now try
    // loading something on the command line.
    if( m_lpCmdLine != NULL && strlen( m_lpCmdLine ) > 0 ) 
    {
    	CString CmdLine = m_lpCmdLine;
    	CmdLine.MakeUpper();
    	CStringArray SetNames;
    	gConfig->GetSetupSetNames( SetNames );
    	for( int i = 0 ; i < SetNames.GetSize() ; i++ )
    	{
    		CString Set = SetNames[ i ];
    		if( CmdLine.CompareNoCase( Set ) != 0 )
    			continue;
    		// This is the one
    		gConfig->SetCurrentSetName( Set );
    	}
    }
	
	HWND Parent = CreateWinsockParent();
	
	// Initialise the socket library                                   
	if( tcSocketInit( Parent , "tcWindisClass" , AfxGetInstanceHandle() , TRUE ) < 0 )
		::MsgBox( MB_OK | MB_ICONHAND , IDS_MSG_INIT_LIBRARY );
	
	// Initialise the animated bitmaps
	if( !InitAnimatedBitmaps() )
		::MsgBox( MB_OK | MB_ICONHAND, IDS_MSG_INIT_BITMAPS );

	// create main MDI Frame window
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE; 
		
	if( Parent == NULL )
		Parent = pMainFrame->m_hWnd;
		
		
	pMainFrame->InitialShowWindow(m_nCmdShow);
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();
	m_pMainWnd = pMainFrame;

	// Now do the kicks
	if ( gConfig->GetTimeStartupKick() )
		pMainFrame->PostMessage( WM_COMMAND , ID_KICK_TIME , 0 );
		
	switch( gConfig->GetStartupOption() )
	{
	case 0: // Do nothing
			break;
	case 1: // Start the smtp server listening
	case 2: // Start the smtp server listening and then 
			// kick everything when it's working.
			pMainFrame->PostMessage( WM_COMMAND , ID_KICK_SMTPSERVER , 0 );
			break;
			// Kick all
	case 3: pMainFrame->PostMessage( WM_COMMAND , ID_KICK_ALL , 0 );
			break;
	default:
			::MsgBox( MB_OK | MB_ICONSTOP , IDS_ERROR_CONFIG_STARTUP );
			break;
	}
	 		
	return TRUE;
}

int CWindisApp::ExitInstance()
{
	// Delete the global configuration object
	delete gConfig;
	Ctl3dUnregister(AfxGetInstanceHandle());

/*#ifdef _DEBUG             
	CMemoryState EndState;
	EndState.Checkpoint();
	CMemoryState Diff;
	Diff.Difference( m_StartState, EndState );
	TRACE("Dumping Memory\n");
	Diff.DumpStatistics();
#endif  */

	return CWinApp::ExitInstance();
}

BOOL CWindisApp::OnIdle( long Count )
{                  
	static DWORD LastTick; // this is initialised to 0 on startup
	DWORD TickNow = ::GetTickCount();
	
	BOOL More = CWinApp::OnIdle( Count );   
	
	// Check for unbatching and expiring
	CMainFrame * Parent = (CMainFrame *)m_pMainWnd;	              
	Parent->DoBackground();
	
	// Are we going to do the animated icons?
	if ( !gConfig->GetAnimatedBitmaps() )
		return More;
		
	if( TickNow - LastTick > 200 )
	{
		Parent->DrawProgress();
		LastTick = TickNow;
	}
	return More;
}
/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CString	m_AboutBuildInfo;
	CString	m_AboutExtraInfo;
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	char * Buf = new char[ 128 ];
	wsprintf( Buf , "Version %d.%d Built on %s %s" , WINDIS_VERSION / 10 , WINDIS_VERSION % 10 , __DATE__ , __TIME__ );
	//{{AFX_DATA_INIT(CAboutDlg)
	m_AboutBuildInfo = Buf;
	m_AboutExtraInfo = SystemAboutInfo;
	//}}AFX_DATA_INIT  
	delete [] Buf;
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Text(pDX, IDC_ABOUTBUILDINFO, m_AboutBuildInfo);
	DDX_Text(pDX, IDC_ABOUTEXTRAINFO, m_AboutExtraInfo);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CWindisApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CWindisApp commands


BOOL CAboutDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow();
	return TRUE;  // return TRUE  unless you set the focus to a control
}
