/***********************************************************************
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
** V1.0 - Initial Revision 01-Sep-94
**
*/
// nntpdlg.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CNntpDlg dialog
#ifndef _NNTPDLG_H
#define _NNTPDLG_H

#include "clidlg.h"  

// classes needed in this file
class CNntpSocket;
class CNntpInfo;
class CNNTPHistoryList;

// Classes defined in this file
class CNntpDlg;
class CNNTPHistoryList;

class CNntpDlg : public CClientDlg
{
public:
	CNntpDlg();	// standard constructor
	~CNntpDlg();
	virtual BOOL Create( CWnd * pParent );	


	BOOL IsConnected() { return m_Sock != NULL; }
	virtual void Trace( int Level , const char * Str );
	virtual void Trace( int Level , UINT nId ) { CClientDlg::Trace( Level , nId ); }
	virtual void Kick();
	virtual void Abort();
	virtual void Connected( int Error , tcSocket * Sock );
	virtual void Closed( int Error , tcSocket * Sock );
	virtual void Timeout( tcSocket * Sock );
	void 		 Info( CNntpInfo * Info);
	 
#ifdef _DEBUG
	virtual	void AssertValid() const;
	virtual	void Dump(CDumpContext& dc) const;
#endif
// Dialog Data
	//{{AFX_DATA(CNntpDlg)
	enum { IDD = IDD_NNTPDLG };
	CStatic	m_NewsIcon;
	CStatic	m_Duplicates;
	CStatic	m_Speed;
	CStatic	m_Messages;
	CStatic	m_Groups;
	CListBox	m_ListBox;
	//}}AFX_DATA

protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	// Generated message map functions
	//{{AFX_MSG(CNntpDlg)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
    afx_msg LRESULT OnSockClose( WPARAM, LPARAM );
	afx_msg void OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
	
	private:
	void CreateSocket();
	void KillSocket(tcSocket * Sock);
	CNntpSocket * m_Sock;		
	tcLogger * m_Log;
	CNNTPHistoryList * m_HistoryList;
};

// Not for public consumption.  This is the global historylist
// We create this when we create the nntp dialog
// and delete it when the nntp dialog disappears
class CNNTPHistoryList 
{
  public:
  	CNNTPHistoryList();
  	~CNNTPHistoryList();
  	BOOL Init();
  	void AddHistoryEntry( const char * Str );
  	BOOL IsAlreadyGot( const char * Str ) { return m_GotArticles.Lookup( Str , m_Dummy ); }
  private:
  	CStdioFile m_HistoryFile;
    CString m_HistoryName;
    CMapStringToOb m_GotArticles;
    CObject * m_Dummy;
};

#endif
