/***********************************************************************
**
** CANIBMP.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
** It is the implementation of the CAnimatedBitmap class.
** This class responsible for animating itself in a particular
** location
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
// maildlg.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CServDlg dialog
#ifndef _SERVDLG_H
#define _SERVDLG_H 

#include "clidlg.h"
#ifndef _SERVSOCK_H
#include "servsock.h"
#endif

class CServDlg : public CClientDlg
{
// Construction
public:
	CServDlg();	// standard constructor
	~CServDlg();
	virtual BOOL Create( CWnd * pParent );	
	
	BOOL IsConnected() { return m_ListenSock != NULL; }
	virtual void Trace( int Level , const char * Str );
	virtual void Trace( int Level , UINT nId ) { CClientDlg::Trace( Level , nId ); }
	virtual void Kick();
	virtual void Abort();
	virtual void Connected( int Error , tcSocket * Sock );
	virtual void Closed( int Error , tcSocket * Sock );
	virtual void Timeout( tcSocket * Sock );
	virtual void Accept( int Error , tcSocket * Sock );
	               
	void ReceivedMessage();            
// Dialog Data
	//{{AFX_DATA(CServDlg)
	enum { IDD = IDD_SMTPSERVDLG };
	CStatic	m_ServReceived;
	CStatic	m_ServIcon;
	CListBox	m_ListBox;
	//}}AFX_DATA


protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CServDlg)
    afx_msg LRESULT OnSockClose( WPARAM , LPARAM );
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
	
	void		KillSocket( tcSocket * Sock );
  private:                      
  	void		DoBitmap();
  	CServSocket * m_ListenSock;
  	CServSocketList m_SockList;
	void CreateSocket();
	void KillSocket();
	tcLogger * m_Log;
	DWORD m_TickConnect;         
	int	m_Received;
	HICON m_QuietIcon;
	HICON m_ListenIcon;
};
#endif
