/***********************************************************************
**
** CANIBMP.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** The Unbatcher class.  Takes a newsbatch and unbatches it.
** Based on the snews code but with all the checks take out since
** we can be pretty sure of memory.  Windows is going to grind to a halt
** long before you exhaust memory.
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
/****************************************************************************/
#include "stdafx.h"
#include "windis.h"
#include "newssup.h"
#include "wunbatch.h"
#include <ctype.h> // Needed for jeremy's functions

BOOL IsToken( char * buf , unsigned long& Length )
{
	if (strncmp(buf, "#! rnews", 8) == 0
		&& (strcspn(buf + 8, "\r\n") != 0)
		&& (Length = atol(buf + 8)) != 0l )
		return TRUE;
	else
		return FALSE;
}

// Added by Jeremy Sonander <Jeremy@silicom.demon.co.uk>
// 01Nov94.  These functions are used in the ExtractDate functions
// 
static const char  * const Days[]   = {"Mon","Tue","Wed","Thu","Fri","Sat","Sun"};
static const char * const Months[] = {"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};

typedef struct {
	char *name;
	char *diff;
} TZoneType;

static const TZoneType Zones[] = {
{ "UT","+0000"},{"GMT","+0000"},
{"EST","-0500"},{"EDT","-0400"},
{"CST","-0600"},{"CDT","-0500"},
{"MST","-0700"},{"MDT","-0600"},
{"PST","-0800"},{"PDT","-0700"}};


static const char *SkipNumeric(const char *ptr)
{
	while (isdigit(*ptr++))
	    ;
        return (ptr);
}

static const char *SkipSpace(const char *ptr) 
{
	while (isspace(*ptr++))
            ;
        return (ptr);
}

static const char *SkipText(const char *ptr)
{
	while ((*ptr>='a' && *ptr<='z') || (*ptr>='A' && *ptr<='Z') || *ptr==',') *ptr++;
	return (ptr);
}


//////////////////////
BOOL CUnbatcher::DoError( const char * Str )
{
	::MessageBox( NULL , Str , "Unbatch" , MB_OK | MB_ICONHAND );
	return FALSE;
}
                  

BOOL CUnbatcher::Init()
{	
/*
	// Make the Lock for the batch
	m_BatchLock = new CNewsLock( m_Setup->BatchDir , "BATCH" , "UnBatch" );
	if (!m_BatchLock->IsLocked() )
		// We can exit here 
		return DoError( "Can't Lock Batch File");
		
    // Make the lock for the News history
    m_NewsLock = new CNewsLock( m_Setup->NewsDir , "history" , "Unbatch" );
    if (!m_NewsLock->IsLocked())
    	return DoError( "Can't lock History File" );
 
*/	
 	m_ActiveList = new CActiveList( GetNewsActiveListName() );
 	if (!m_ActiveList->IsOk() )
 		return DoError( "Cannot Open Active File" );

	m_BatchFile = new CStdioFile();
		
   	if ( !m_BatchFile->Open( GetNewsBatchFileName() , CFile::modeRead | CFile::typeBinary ) ) 
   	{
		::MsgBox( MB_OK , IDS_MSG_NOTHING_TO_UNBATCH );
		return FALSE;
	}
	else
	{
		// Setup the status dialog
        long Len = m_BatchFile->GetLength();
		// We do the size in K
		UINT KLen = (int)(Len / 1024);
		m_StatDlg.SetThermRange( 0 , KLen );
		m_StatDlg.SetTitle( "Unbatching" );
		/* set a large disk transfer buffer */
		for (size_t bufsize = (size_t) 32768U;
			 setvbuf(m_BatchFile->m_pStream, NULL, _IOFBF, bufsize) != 0 && bufsize > 512;
		 	bufsize /= 2)
				; // <-!!!! Missing Null expression CRCS 23/11/94
		/*
		 * Toss it into the appropriate files.
	 	 * 
	 	 */

		LINES *spool = NULL;
		CString msg_id;
		CString subject;
		CString newsgroups;
		// Get to the first token which should be the first line of
		// a batch.
		spool = ReadToToken( subject , msg_id , newsgroups );
	}                              
	return TRUE;
}

LINES * CUnbatcher::ReadToToken( CString& subject , CString& msg_id , CString& newsgroups )
{
	char * buf = new char[ NEWS_BUF_LEN + 1 ];         
	char * msg = new char[ NEWS_BUF_LEN + 1 ];
	char * p;
	LINES * Spool = NULL;
	LINES * help = NULL;
	unsigned long Length;  
	subject = "-- no subject --\n";
	newsgroups = "";
	msg_id = "";                                   
	BOOL InHeader = TRUE;
	
	while( m_BatchFile->ReadString( buf , NEWS_BUF_LEN  ) )
	{	
		Filter( buf );
		if( IsToken( buf , Length ) )
			break;
		// Ok this isn't a token
		
		// A single blank line indicates the end of the header
		if ( strcmp( buf , "\n" ) == 0)
			InHeader = FALSE;

		// Do Message ID;                                     
		if ( InHeader )
		{
			if (strnicmp(buf, "Message-ID:", 11) == 0) {
				strcpy(msg, buf);
				p = strtok(msg, " \t\r\n");
				p = strtok(NULL, " \t\r\n");
				msg_id = p;
			}                
			// Do Newsgroups
			if ((strnicmp(buf, "Newsgroups:", 11) == 0) && (newsgroups.GetLength() == 0))
				newsgroups = buf;
			// Do Subject
			if (strnicmp(buf, "Subject:", 8) == 0) {
				if (strlen(buf) > 136) {
					buf[136] = '\n';
				    buf[137] = '\0';
				}
				subject = buf + 8;
			}
			// Do Path add our system name to the path list
			if (strnicmp(buf, "Path:", 5) == 0) {
				p = strtok(buf, " \t");
				CString Tmp = strtok(NULL, " \t");                      
				// Change this to proper stuff!
				wsprintf(buf, "Path: %s!%s", (const char *)m_Setup->Site , (const char *)Tmp);
			}
		} // InHeader
		// And add the line to the spool list
		if (Spool == NULL)
			Spool = help = new LINES;
		else {
			help->next = new LINES;
			help = help->next;
		}
		help->next = NULL;
		help->data = new char[ strlen(buf) + 1 ];
		strcpy(help->data, buf);
	}                    
	delete [] buf;
	delete [] msg;
	return Spool;
}

/*--------------------------- post article work file to all groups ----*/
LINES *CUnbatcher::PostToGroups( LINES * spool, CString& msg_id ,
								  CString& newsgroups, CString& subject )
{
	LINES          	*help;
	char 			*Tmp;	
	CActive			*gp;
	char           	*p;
	BOOL			AlreadyJunked;		  /* nz - message already junked */
                                         
    
	if (spool == NULL) 
		return NULL;

	if ( newsgroups.GetLength() != 0) {
		// Check if we've already got this message
		if ( m_HistoryList->FindMsgId(msg_id) == NULL) {

			// If we're going to try to cross post to junk then try
			// here to find whether or not this is already going to
			// be posted to junk.
			if (m_Setup->CrossPostToJunk()) {         
				char * Tmp = strdup( newsgroups );
				p = strtok( Tmp, " \t\r\n,:");
				p = strtok(NULL, " \t\r\n,:");
				AlreadyJunked = FALSE;
				while (p != NULL) {
					gp = m_ActiveList->FindGroup(p );
					if ( gp != NULL) {  /* Posting to active group */
						AlreadyJunked = TRUE;	/* No need to post to junk */
						break;
					}
					p = strtok(NULL, " \t\r\n,:");
				}        
				// Note this is free since strdup uses malloc      
				free( Tmp );
				// If we get here with already_junked = 0 then
				// this message isn't being posted to any group
				// that we subscribe to so we crosspost it
				// to junk
				if( !AlreadyJunked )
					newsgroups = "Newsgroups: junk\n";
			}
			/*
			 * For each newsgroup
			 * - open the text file
			 * - save the file pointer
			 * - append the message to it
			 * - close the file
			 * - open the index file
			 * - save the file pointer and the subject line
			 */
			CString PostedGroups;
			char * Buf = new char[ NEWS_BUF_LEN + 1];                
            Tmp = strdup( newsgroups );
			p = strtok( Tmp , " \t\r\n,:");
			p = strtok(NULL, " \t\r\n,:");
			while (p != NULL) 
			{
                gp =m_ActiveList->FindGroup( p ); 
                if ( gp != NULL )
                {       
                	CStdioFile OutFile;              
					CString    FName = gp->GetGroupFile( m_Setup->NewsBaseDir );
					long       Where;
                	PostedGroups += p;
                	PostedGroups += ",";

					// Increment our hinum here
					gp->IncHiNum();					

					// Check for file failures in the next stuff
					TRY
					{   
						CStdioFile * OutFile;
						OutFile = new CStdioFile( FName , CFile::modeWrite | CFile::typeBinary );
						OutFile->SeekToEnd();
						Where = OutFile->GetPosition();
						for (help = spool; help != NULL; help = help->next)
						{                           
							OutFile->WriteString( help->data );
						}
						OutFile->WriteString("\n@@@@END\n");
						delete OutFile; // This closes the file

						FName = gp->GetIndexFile( m_Setup->NewsBaseDir );
						OutFile = new CStdioFile( FName , CFile::modeWrite | CFile::typeBinary );
						OutFile->SeekToEnd();
    					
	    				// Find out when now is
    					CTime t = CTime::GetCurrentTime();
    				
						wsprintf( Buf, "%08ld %08ld %09ld %s", Where,
									gp->GetHiNum(), (time_t)t.GetTime(), (const char *)subject);
						OutFile->WriteString( Buf );
						delete OutFile;  // This closes the file
					}
					CATCH( CFileException, e )
					{
						wsprintf( Buf , "Problem writing to files for %s" , gp->GetGroup() );
						DoError( Buf );           
					}                     
					AND_CATCH_ALL( e )
					{            
						DoError( "Unknown Problem" );
					}
					END_CATCH_ALL         
				}
				p = strtok(NULL, " \t\r\n,:");
			} // While p!= NULL
			delete [] Buf;
			free( Tmp );
			m_HistoryList->AddHistRecord(msg_id, PostedGroups , m_ActiveList );
			m_Setup->ArticleCount++;
		}
		else {
			m_Setup->DuplicateCount++;
		}
	}
	if (spool != NULL) {
		while (spool) {
			help = spool;
			spool = spool->next;
			delete help->data;
			delete help;
		}
	}
	return spool;						  /* == NULL */
}

/*------------------- remove non printables from buffer --------------------*/
void CUnbatcher::Filter(char *buf)
{
	char           *s, *d;

	s = d = buf;

	do {
		if (*s != 0) {
			if (*s < 0x20)				  /* Since BC is signed char will get >0x80 as well */
				if ((*s != '\t') && (*s != '\n') && (*s != '\f') && (*s != '\r'))
					*s = '?';
		}
		if (*s != 0x0d)
			*d++ = *s;
	}
	while (*s++ != '\0');
}
        
/////////////////////////////////////////////////////////////////////////////
// CUnbatcher constructor

CUnbatcher::CUnbatcher()
{
	m_HistoryList = NULL;
	m_ActiveList = NULL;
//	m_BatchLock = NULL;
//	m_NewsLock = NULL;
	m_BatchFile = NULL;                 
	m_Setup = new CUnbatchSetupInfo;
	m_Setup->NewsBaseDir = GetNewsBaseDirName();
	m_Setup->Site = gConfig->GetHostName();
	m_Setup->UnbatchOptions = 0;
	m_Setup->UnbatchOptions = gConfig->GetUnbatchOptions();		
	m_Setup->ArticleCount = 0;
	m_Setup->DuplicateCount = 0;
}


/////////////////////////////////////////////////////////////////////////////
// CUnbatcher message handlers

BOOL CUnbatcher::UnbatchOne( )
{                                                    
	LINES *spool = NULL;
	CString msg_id;
	CString subject;
	CString newsgroups;
	char Progress[ 80 ];

    // This will create a new one if it doesn't exist
    if ( m_HistoryList == NULL )
    {
		m_StatDlg.SetLine1( "Loading History File" );
    	m_HistoryList = new CHistoryList( GetSNewsHistoryName() );
    	if ( m_HistoryList != NULL )
    	{
			return TRUE;
		}
		else                                          
		{
			// Otherwise, we've fucked up so just close
			DoError( "Problem Loading History File" );
			return FALSE;
		}
	}	
	else
	{	
		if ( ( spool = ReadToToken( subject , msg_id , newsgroups ) ) != NULL ) 
		{
			spool = PostToGroups( spool , msg_id , newsgroups , subject );
			m_StatDlg.SetLine1( subject );
			m_StatDlg.SetLine2( (const char *)newsgroups + 12 );
				 
			wsprintf( Progress , "%d Articles , %d Duplicates" , m_Setup->ArticleCount , m_Setup->DuplicateCount );
			m_StatDlg.SetLine3( Progress );
			UINT KLen = int( m_BatchFile->GetPosition() / 1024 );            
			m_StatDlg.SetThermPos( KLen );
			return TRUE;			
		}                                         
		else    
		{
			return FALSE;
		}
	}		
	return FALSE;
}

                                                     

CUnbatcher::~CUnbatcher()
{       

	delete m_BatchFile;		// the destructor is clever enough
							// not to try to close if it didn't
							// open
	if (m_Setup->RemoveBatch() )
	{                
		    
		// Use unlink because it doesn't throw an exception
		// and doesn't complain if there isn't a file there
		// to delete.
		unlink( GetNewsBatchFileName() );
	}
	delete m_HistoryList; 			// Note that history list is written every
									// time there is an addition
							
	if( m_ActiveList )
	{
		if (m_ActiveList->IsOk())
			m_ActiveList->WriteActive();    // But the active file isnt.
		delete m_ActiveList;
	}
	
	// remove the locks
	// Delete the setup structure
	delete m_Setup;
}			

//////////////////////////////////////////////////////////////////////
// Function added by <jwtcdoac@silicom.demon.co.uk> Jeremy Sonander
// Reindexer used to change all the dates of the articles to the
// date that the reindexer was run!
//
// passed a character string, returns a corresponding CTime in the local time zone
CTime CReindexer::ExtractDate(const char *date_str,int zone_as_int)
{   
 	CTime m_date ;
 	CTime now = CTime::GetCurrentTime();
 	// now for the ctime structure
 	int day = -1,date,month=-1,year=94,hour,min,sec=0,i;
 	CTimeSpan shift(0,0,0,0);
 	int shift_forward=0;
 	// remove any initial white space
 	const char *ptr=SkipSpace(date_str);
 	// chek we have a date!
 	if (*ptr==0) {
 		return now;
 	}
 	// check the format of the date
 	if (*ptr>='0' && *ptr<='9') {
 		// must be a format like 14 Jun 95 11:52 PDT
 	}
 	else {
 		// have format like Mon, 12 Jun 1994 10:30:16 GMT
 		// except GMT could be +xxxx or -xxxx
 		ptr = SkipSpace(SkipText(ptr));
 	}
 	date = atoi(ptr);
 	ptr=SkipSpace(SkipNumeric(ptr));
 	for (i=0;i<12;i++) if (!_strnicmp(ptr,Months[i],3)) {
 		month=i+1;
 		break;
 	}
 	// check we found the month
 	if (month<0) return now;
 	// get rest of numeric fields
 	ptr = SkipSpace(SkipText(ptr));
 	year = atoi(ptr);
 	ptr = SkipSpace(SkipNumeric(ptr));
 	sscanf(ptr,"%d:%d",&hour,&min);
 	ptr= SkipNumeric(ptr)+1;
 	ptr= SkipNumeric(ptr);
 	// seconds sometimes included 
 	if (*ptr==':') {
 		sec = atoi(ptr+1);
 		ptr = SkipNumeric(ptr+1);
 	}
 	ptr=SkipSpace(ptr);
 	// extract time zone if there is one
 	if (*ptr!=0) {
 		
 		if (*ptr == '+' || *ptr=='-' || (*ptr>='0' && *ptr<='9')) zone_as_int = atoi(ptr);
 		else for (i=0;i<sizeof(Zones)/sizeof(TZoneType);i++) if (!strncmp(Zones[i].name,ptr,3)) zone_as_int = atoi(Zones[i].diff);
 		if (abs(zone_as_int)<=12) zone_as_int *= 100;
 
 		if (zone_as_int<0) {
 			zone_as_int = -zone_as_int;
 			shift_forward = FALSE;
 		}
 		else shift_forward = TRUE;
 		shift = CTimeSpan(0,zone_as_int/100,zone_as_int%100,0);
 	}
 	if (month<0) return now;
 	if (year<100) year+=1900;
 	m_date=CTime(year,month,date,hour,min,sec);
 	// work in the time zone.
 	// this will either be an 
 	if (shift_forward) m_date -= shift;
 	else m_date += shift;
 	return m_date;
}
 

///////////////////////////////////////////////////////////////////////////
// The reindex dialog, all quite simple
// Read to token stuff
BOOL CReindexer::GetNext( CStdioFile& File , CString& Subject , CTime& WrittenTime, int ZoneAsInt )
{                         
	char Buffer[ 512 ];
	Subject = "";
	while( File.ReadString( Buffer , 511 ) )
	{                       
 		if ( strnicmp( Buffer , "Date:" , 5 ) == 0 )
 		{                    
 			// This is the date when the article was written
 			WrittenTime = ExtractDate(Buffer+6, ZoneAsInt );			
 		}
		if ( strncmp( Buffer , "@@@@END" , 7 ) == 0 )
			return TRUE;
		if ( Subject != "" ) // Already got subject
			continue;
		if ( strnicmp( Buffer , "Subject:" , 8 ) == 0 )
		{
			// This is the subject      
			if( strlen( Buffer ) > 136 )
			{
				Buffer[ 136 ] = '\n';
				Buffer[ 137 ] = '\0';
			}
			Subject = Buffer + 8;
		}
	}
	return FALSE;
}

// The main reindexing loop
BOOL CReindexer::ReindexGroup( CActive * gp )
{
   	CStdioFile TextFile;
   	CStdioFile IdxFile;         
   	char * LineBuf = new char[ 256 ];
	long       Where = 0;
	CString    FName = gp->GetGroupFile( m_Dir );
	CString	   IdxName = gp->GetIndexFile( m_Dir );
	CString		Subject;
        CTime       WrittenTime;

	if( !TextFile.Open( FName , CFile::modeRead | CFile::typeBinary ) ||
		!IdxFile.Open( IdxName ,CFile::modeCreate | CFile::modeWrite | CFile::typeBinary ) )
	{
		delete [] LineBuf;
		return FALSE;
	}
	Where = TextFile.GetPosition();

 	// Get the current time zone and put it into the environment
 	CString Tz = "TZ=";
 	Tz += gConfig->GetTimeZone();
 	_putenv(Tz);
 	ASSERT( strcmp( getenv( "TZ" ) , gConfig->GetTimeZone() ) == 0 );
 	// Now set the tz variables with the time zone;
 	_tzset();                                      
 	
 	// current time zone as an offset in minutes to base 60, ie 1 hour forward is 100
 	int ZoneAsInt = (int)((_timezone/60)%60 + 100 * (_timezone/60/60));
 	
	while( TRUE ){
		// Increment our hinum here
		if( !GetNext( TextFile , Subject , WrittenTime , ZoneAsInt ) )
			break;
			
		gp->IncHiNum();					
    				
		wsprintf( LineBuf, "%08ld %08ld %09ld %s", Where,
					gp->GetHiNum(), (time_t)WrittenTime.GetTime(), (const char *)Subject);
		IdxFile.WriteString( LineBuf );
		m_StatDlg.SetLine2( (const char *)Subject );
		wsprintf( LineBuf , "%ld" , gp->GetHiNum() );
		m_StatDlg.SetLine3( LineBuf );
		Where = TextFile.GetPosition();
	} 
	TextFile.Close();  
	IdxFile.Close();                          
	delete [] LineBuf;
	return TRUE;
}

BOOL CReindexer::Reindex()
{          
	CActive * Group;    
 	if (!m_ActiveList->IsOk() )
 		return FALSE;
	int High = m_ActiveList->GetGroupCount();
	int GroupCount = 0;
	m_StatDlg.SetThermRange( 0 , High );
	POSITION Pos = m_ActiveList->GetStartPosition();
	while( Pos )
	{           
		Group = m_ActiveList->GetNextGroup( Pos );
		m_StatDlg.SetLine1( Group->GetGroup() );
		m_StatDlg.SetThermPos( GroupCount++ );
		Group->ClearNums();
		ReindexGroup( Group );
	}
	m_ActiveList->WriteActive();
	return TRUE;
}

CReindexer::CReindexer()
{
	// the status dialog is created
	// in the constructor.
	// So just show it.
	m_StatDlg.Show();                 
	CString FileName = GetNewsActiveListName();
	m_Dir = GetNewsBaseDirName();
 	m_ActiveList = new CActiveList( FileName );
}

CReindexer::~CReindexer()
{
	delete m_ActiveList;
}

/////////////////////////////////////////////////////////////////////////////
// The group sorting function

CGroupSorter::CGroupSorter()
{
	// Allocate the array                                                
	// Allocate one segment
	m_GlobalHandle = GlobalAlloc( GHND , sizeof( const char *) * 16384L );
	m_StringArray = (char **)GlobalLock( m_GlobalHandle );
	m_LineBuffer = new char [ 512 ];
}                        
                                                 
                                                 
CGroupSorter::~CGroupSorter()
{
	// Clean up the array
	char ** Pos = m_StringArray;
	while( *Pos )
	{
		free( *Pos );
		Pos++;
	}
	GlobalUnlock( m_GlobalHandle );
	GlobalFree( m_GlobalHandle );   
	delete [] m_LineBuffer;
}

BOOL CGroupSorter::Init()
{
	// Load the strings into the array.
	// First open the groups file.
	CString GroupFile = GetNewsGroupListName();
	CStdioFile GroupList;    
	if( !GroupList.Open( GroupFile , CFile::modeRead | CFile::typeText ) )
	{
		::MsgBox( MB_OK , IDS_MSG_COULDNT_OPEN_GROUPS_FILE , 
					(const char *)GroupFile );
		return FALSE;
	}
	// Ok, set up the thermometer and the line info
	m_StatDlg.SetLine1( "Loading group list" );
	GroupList.SeekToEnd();
	UINT Pos100 = UINT(GroupList.GetPosition() / 100);
	GroupList.SeekToBegin();
	m_StatDlg.SetThermRange( 0 , Pos100 );	
	UINT Count = 0;
	char ** Place = m_StringArray;
	while( GroupList.ReadString( m_LineBuffer , 511 ) )
	{        
		if( strlen( m_LineBuffer ) > 0 )
		{                     
			*Place = strdup( m_LineBuffer );
			Place++;
			Count++;
		}
		if( Count % 100 == 0 )
		{
			// Update the display  
			// I know that GetPosition doesn't work with text files
			// but it will be close enough
			Pos100 = UINT(GroupList.GetPosition()/100 );
			m_StatDlg.SetThermPos( Pos100 );
		}
	}   
	GroupList.Close();
	// Done that so now try to load any newgroups there might be
	GroupFile = GetNewsNewgroupName();
	if( GroupList.Open( GroupFile , CFile::modeRead | CFile::typeText ) )
	{                                           
		m_StatDlg.SetLine1( "Loading new groups list" );
		while( GroupList.ReadString( m_LineBuffer  , 511 ) )
		{
			if( strlen( m_LineBuffer ) > 0 )
			{
				*Place = strdup( m_LineBuffer );
				Place++;
				Count++;
			}
			// Don't bother with thermometer for this, it's too
			// much hassle
		}
		GroupList.Close();
	}
	// Guess we're done here.
	return TRUE;
}               
                
// The qsort compare function
static int _cdecl GroupCompare(const void * Elem1 , const void * Elem2 )
{
	return _stricmp( *(char **)Elem1 , *(char **)Elem2 );
}

BOOL CGroupSorter::SortGroups()
{
	// All this is done in qsort ("use the api"!).
	// First count the groups we've got.
	UINT Count = 0;
	char ** Pos = m_StringArray;
	while( *Pos )
	{
		Count++;
		Pos++;
	}
	// Update the display.
	m_StatDlg.SetLine1( "Sorting Groups...please wait" );
	qsort( (void*)m_StringArray , Count , sizeof( char *) ,
			GroupCompare );
	m_StatDlg.SetLine1( "Done!" );
	// And write the groups
	m_StatDlg.SetLine2( "Writing group list" );
	CStdioFile GroupList;
	CString GroupFile = GetNewsGroupListName();
	if( !GroupList.Open( GroupFile , CFile::modeCreate | CFile::typeText ) )
	{
		::MsgBox( MB_OK , IDS_MSG_COULDNT_OPEN_GROUPS_FILE , (const char *) GroupFile );
		return FALSE;
	}
	Pos = m_StringArray;
	m_StatDlg.SetThermRange( 0 , Count / 100 );
	for( UINT i = 0 ; i < Count ; i++ )
	{         
		ASSERT( *Pos != NULL );     
		GroupList.WriteString( *Pos ); // remmember that string includes \n
		Pos++;                                 
		if( i % 100 == 0 )
			m_StatDlg.SetThermPos( i / 100 );
	}
	// and delete the new groups file.
	unlink( GetNewsNewgroupName() );
	return TRUE;
} 
	
