/***********************************************************************
**
** CANIBMP.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
** It is the implementation of the CAnimatedBitmap class.
** This class responsible for animating itself in a particular
** location
**
** V1.0 - Initial Revision 01-Sep-94
**
*/

#include "stdafx.h"
#include "windis.h"
#include "canibmp.h"
                                                           
// This static variable holds the loaded resources.                                                           
static CBitmap m_Bitmaps[ MAX_ANIMATED_BITMAPS ];          

BOOL InitAnimatedBitmaps()
{
	for( int i = 0 ; i < MAX_ANIMATED_BITMAPS ; i++ )
	{                                                
		// Note well here that the bitmaps MUST MUST MUST
		// be in order in the resource file 
		if( !m_Bitmaps[ i ].LoadBitmap( IDB_BITMAP1 + i ) )
			return FALSE;
	}
	return TRUE;
}

CAnimatedBitmap::CAnimatedBitmap( CWnd * pParent )
  : CObject(), m_Parent( pParent ), m_CurrentBitmap( 0 )
{
}
CAnimatedBitmap::~CAnimatedBitmap()
{
	// Null destructor
}

BOOL CAnimatedBitmap::Draw()
{
	ASSERT_VALID( m_Parent );
	ASSERT( m_CurrentBitmap >= 0 );
	ASSERT( m_CurrentBitmap < MAX_ANIMATED_BITMAPS );

	CClientDC dc(m_Parent);
	CBitmap* pbmOld = NULL;

	CDC dcMem;
	dcMem.CreateCompatibleDC(&dc);
	pbmOld = dcMem.SelectObject(&m_Bitmaps[ m_CurrentBitmap ]);
	dc.BitBlt( 0, 0 , 32 , 32 , &dcMem, 0, 0, SRCCOPY);
	dcMem.SelectObject(pbmOld);
	dcMem.DeleteDC();
	m_CurrentBitmap++;
	m_CurrentBitmap = m_CurrentBitmap % MAX_ANIMATED_BITMAPS;
	return TRUE;
}	

	

		
