/***********************************************************************
**
** CANIBMP.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
** It is the implementation of the CAnimatedBitmap class.
** This class responsible for animating itself in a particular
** location
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
// clidlg.h : header file
//

#ifndef _CLIDLG_H
#define _CLIDLG_H

#include "csocket.h"

#ifndef _CANIBMP_H
#include "canibmp.h"
#endif

// Classes needed in this file
class tcSocket;
// classes defined i this file
class CClientDlg;

/////////////////////////////////////////////////////////////////////////////
// CClientDlg dialog

class CClientDlg : public CDialog
{
// Construction
public:   
	// for modal dialogs
	CClientDlg( UINT nId , CWnd * pParent = NULL ) : CDialog( nId , pParent ) {;}
	// for modeless ones				
	CClientDlg();        
	
    virtual ~CClientDlg();
	virtual BOOL Create( UINT ResId , CWnd * pParent ); 
	
	// These functions are called for each of the client windows
	// from the main form timer.  This is a fairly coarse timer
	// which is mainly used periodic kicking of the servers.
	void	SetKickTime( int nTime ) { m_KickTime = (nTime * 1l / TICK_TIMER); }
	void 	ClearKickTime() { m_KickTime = 0; }
	void    KickCountdown() { if ( m_KickTime ) if( (!--m_KickTime) ) Kick(); }

	BOOL	IsVisible() const { return ( GetStyle() & WS_VISIBLE ) != 0; } 
	void 	DrawProgress() { if( m_Bitmap && IsVisible() ) m_Bitmap->Draw(); }
	// Some overrideable functions
	virtual void	Trace( int Level , const char * Str ) = 0;
	virtual void	Trace( int Level , UINT nId );// This is for String ID based trace messages
	virtual void 	Kick() = 0;
	virtual void	Abort()= 0;
	virtual void	Connected( int Error , tcSocket * Sock ) = 0;
	virtual void	Closed( int Error , tcSocket * Sock ) = 0;			
	virtual void 	Close( int Error , tcSocket * Sock )
					{ PostMessage( WM_SOCK_CLOSE , WPARAM(Error), LPARAM( Sock ) ); }
	// And this is a nice interface to Trace
	void	TPrintf( int Level , const char * Fmt , ... );
// Implementation
protected:
	afx_msg LRESULT OnSizeParent(WPARAM, LPARAM lParam);
	// Generated message map functions
	//{{AFX_MSG(CClientDlg)
		// NOTE: the ClassWizard will add member functions here
	//}}AFX_MSG                                       
	// This function MUST be overridden in the derived class
    afx_msg LRESULT OnSockClose( WPARAM, LPARAM );
	
	DECLARE_MESSAGE_MAP()                                   
	
	void SetIcon( CStatic * Icon );
	void ClearIcon();
protected:
	long m_KickTime;   
  	CAnimatedBitmap * m_Bitmap;     
  	CStatic * m_Icon;
  	CSize m_sizeFixedLayout;
};
#endif
