/***********************************************************************
**
** FINWND.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
** Implementaion of the finger window.
** This is basically an MDI child window which creates a finger
** socket, asks for the info from the socket and displays
** it in the client area.  Would be nice if this was 3D
** but I can't get it to work.
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
// finwnd.cpp : implementation file
//

#include "stdafx.h"
#include <ctl3d.h>
#include "windis.h"
#include "csocket.h"
#include "utility.h"
#include "finwnd.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


#define IDC_FINGER_DISPLAY_EDIT 200
#define FINGER_BORDER 0

/////////////////////////////////////////////////////////////////////////////
// CFingerWnd

CFingerWnd::CFingerWnd()
{                             
	m_Sock = NULL;         
	m_Log = AllocateLogger( "finger" );
	m_Y = 0;
}

CFingerWnd::~CFingerWnd()
{                
	delete m_Sock;
	delete m_Log;
}


BEGIN_MESSAGE_MAP(CFingerWnd, CMDIChildWnd)
	//{{AFX_MSG_MAP(CFingerWnd)
	ON_WM_CREATE()                      
	ON_WM_SIZE()                        
	ON_MESSAGE( WM_SOCK_CLOSE, OnSockClose )
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CFingerWnd message handlers
BOOL CFingerWnd::Create(LPCSTR szTitle, LONG style /* = 0 */,
	const RECT& rect /* = rectDefault */,
	CMDIFrameWnd* parent /* = NULL */)
{
	// Now create the edit control               
	CRect Rect( FINGER_BORDER , FINGER_BORDER , 100 , 100 );
	m_Edit.Create( 	WS_VISIBLE | WS_CHILD | WS_BORDER |
					ES_AUTOHSCROLL | ES_AUTOVSCROLL | ES_LEFT |
					ES_MULTILINE | ES_READONLY  , Rect , this , 
					IDC_FINGER_DISPLAY_EDIT );

	// Register a custom WndClass and create a window.
	// This must be done because CFingerWnd has a custom icon.
	const char* pszFingerClass =
		  AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW,
			LoadCursor(NULL, IDC_ARROW),
			(HBRUSH) (COLOR_WINDOW+1),
			LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_FINGERICO)));

	return CMDIChildWnd::Create(pszFingerClass, szTitle, style, rect, parent);
}



int CFingerWnd::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	// This will kick start the connection
	if (CMDIChildWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// Now create the edit control               
	CRect Rect( FINGER_BORDER, FINGER_BORDER , 
				lpCreateStruct->cx - 2 * FINGER_BORDER ,
				lpCreateStruct->cy - 2 * FINGER_BORDER );
	m_Edit.Create( 	WS_VISIBLE | WS_CHILD | WS_VSCROLL | WS_HSCROLL |
					ES_AUTOHSCROLL | ES_AUTOVSCROLL | ES_LEFT |
					ES_MULTILINE   | ES_READONLY | ES_WANTRETURN, Rect , this , 
					IDC_FINGER_DISPLAY_EDIT );

	CString Text;
	GetWindowText( Text );
	ParseUserHost( Text , m_User , m_Host );
	m_Sock = new CFingerSocket( m_Log , this );
	if( m_Sock->Connect( m_Host , 79 ) == -1 )
	{                  
		
		::MsgBox( MB_OK  , "Error on Connect\n%s" , m_Sock->lastErrorMessage() );
	} 
	else
	{            
		CString Tmp = "Connecting to ";
		Tmp += m_Host;
		Tmp += "...";
		AddLine( Tmp );
		DisplayLines();
		m_Sock->SetTimeout( TIMEOUT_CONNECT , TO_CONNECTING );
	}
	return 0;
}

void CFingerWnd::AddLine( const char * Str )
{
	// Get the number of characters in the edit control
	// CEdit
	m_FingerLines += Str;
	m_FingerLines += "\r\n";
}

void CFingerWnd::Timeout( tcSocket * Sock )
{                            
	ASSERT( m_Sock == Sock );
	AddLine( "\r\nTimeout connecting to host\r\n" );
	DisplayLines();
	Close( 0 , Sock );
}

void CFingerWnd::DisplayLines()
{
	HLOCAL Hand = ::LocalAlloc( LMEM_MOVEABLE | LMEM_ZEROINIT , m_FingerLines.GetLength() + 1 );
	if( Hand != NULL )
	{
		HLOCAL OldHand = m_Edit.GetHandle();
		::LocalFree( OldHand );
		char * p = (char *)::LocalLock( Hand );
		strcpy( p , m_FingerLines );
		::LocalUnlock( Hand );    
		m_Edit.SetHandle( Hand );
	}
};

void CFingerWnd::Closed( int Error , tcSocket * Sock )
{   
	ASSERT( Sock == m_Sock );
	Close( Error , Sock );
}

void CFingerWnd::Connected( int Error )
{             
	m_Sock->ClrTimeout();
	if( Error == 0 )
	{
		m_Sock->writeLine( m_User );
	}                  
	else
		Close( Error , m_Sock ); // Shouldn't be passing around the sock really
}

LRESULT CFingerWnd::OnSockClose(WPARAM Error , LPARAM lParam)
{       
	CFingerSocket * Sock = (CFingerSocket *)lParam;   
	if( Error != 0 )
	{
		SocketError( Sock , Error );
	}
	delete m_Sock;                           
	m_Sock = NULL;
	DisplayLines();
	return 0;
}


void CFingerWnd::OnSize(UINT nType, int cx, int cy)
{
	CMDIChildWnd::OnSize(nType, cx, cy);
	// Now size the contained edit control
	m_Edit.MoveWindow( FINGER_BORDER , FINGER_BORDER , cx - 2 * FINGER_BORDER , cy - 2 * FINGER_BORDER );
}

