/***********************************************************************
**
** CANIBMP.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
** It is the implementation of the CAnimatedBitmap class.
** This class responsible for animating itself in a particular
** location
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
// finwnd.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CFingerWnd frame

class CFingerWnd : public CMDIChildWnd
{
  public:
	CFingerWnd();			// protected constructor used by dynamic creation
	BOOL Create(LPCSTR szTitle, LONG style = 0 , const RECT& rect = rectDefault,
				CMDIFrameWnd* parent = NULL );
	void Connected(int Error);
	void AddLine( const char * Str );
	virtual void Closed( int Error , tcSocket * Sock );
	virtual void Timeout( tcSocket * Sock );
	
	
	virtual void 	Close( int Error , tcSocket * Sock )
					{ PostMessage( WM_SOCK_CLOSE , WPARAM(Error), LPARAM( Sock ) ); }

// Implementation
protected:
	virtual ~CFingerWnd();

	// Generated message map functions
	//{{AFX_MSG(CFingerWnd)
	afx_msg int  OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
    afx_msg LRESULT OnSockClose( WPARAM, LPARAM );
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
  private:
  	void DisplayLines();
  	CString m_Host;
  	CString m_User;
  	CFingerSocket * m_Sock;
	tcLogger * m_Log;
	int m_Y;
	CEdit m_Edit;
	CString m_FingerLines;
};

