/***********************************************************************
**
** MESSAGE.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
**
** The implementation of the CMailMessage Object.
** Currently just handles mail messages of PCElm types but the
** class should be an abstract base class where you can
** encapsulate UMail or Pegasus mail and still use the
** same SMTP code.  This has to be added.
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
//////////////////////////////////////////////////////////////////////
// message.cpp
// The construction and destruction of mail messages.  The base
// class does very little but the derived classes do.

#include "stdafx.h"

#ifdef WIN32                    //CRCS 5/10/94
    #include <io.h>
#else
    #include <dos.h>
#endif

#include "windis.h"
#include "utility.h"
#include "message.h"

// Forward declarations
long GetMessageId();


// Mail Message
CMailMessage::CMailMessage() 
	: CObject(), m_ToHost(""), m_FromAddress("")
{
  m_IsOpen = FALSE;
  m_OkToDelete = FALSE;
}

CMailMessage::~CMailMessage()
{
	ASSERT( m_IsOpen == FALSE );
	// Remove the stuff from the lists
	m_ToAddress.RemoveAll();
	// The body file path contains something like
	// c:\demon\spool\mqueue\1234.txt so we unlink
	// the body file and then unlink the work file
	if( m_OkToDelete )
	{
		char Buffer[ 256 ];
		wsprintf( Buffer , "%s\\%ld.txt" , gConfig->GetMailOutDir() , m_SequenceNum );
		unlink(	Buffer );
		wsprintf( Buffer , "%s\\%ld.wrk" , gConfig->GetMailOutDir() , m_SequenceNum );
		unlink(	Buffer );             
	}
}

char * CMailMessage::GetLine( char * Buffer , size_t Len )
{   
	// Do we need to open the file? 
	if( !m_IsOpen )
	{
		// This has already been checked when we made this
		// object
		if( !m_BodyFile.Open( m_BodyFilePath , CFile::modeRead | CFile::typeText ) )
		{             
			::MsgBox( MB_OK | MB_ICONSTOP , IDS_MSG_MAIL_SERIOUS );
			return NULL;
		}
		m_IsOpen = TRUE;
	}
	
	if( m_BodyFile.ReadString( Buffer , Len ) )
	{
		// nuke the cr
		Buffer[ strlen( Buffer ) - 1 ] = '\0'; // This seems stupid since
										   // we're just going to add it again
		return Buffer;												   
	}                 
	else            
	{
		m_BodyFile.Close();
		m_IsOpen = FALSE;
		return NULL;      
	}
}	

////////////////////////////////////////////////////////////////
// The stuff here is for writing mail messages
BOOL CMailMessage::AddLine( const char * p )
{
	// Do we need to open our file?                
	if( !m_IsOpen )
	{               
#ifdef WIN32
		char * Temp = new char [ MAX_PATH ], * TempPath = new char [ MAX_PATH ];
		::GetTempPath((DWORD) MAX_PATH, TempPath);
		::GetTempFileName( TempPath , "mail" , (unsigned) 0 , Temp );
#else
		char * Temp = new char [ 144 ];
		::GetTempFileName( 0 , "mail" , 0 , Temp );
#endif
		if( !m_BodyFile.Open( Temp , CFile::modeReadWrite | CFile::modeCreate | CFile::typeText ) )
		{
			// Pretty big problem here
			::MsgBox( MB_OK | MB_ICONSTOP , IDS_MSG_TEMP_FILE , Temp );
			return FALSE;             
		}                                   
		m_BodyFilePath = Temp;
		delete Temp;                        
		m_IsOpen = TRUE;
		// Righty ho, the file is open so write the string
	}
	TRY 
	{
		m_BodyFile.WriteString( p );
		m_BodyFile.WriteString( "\n" );
	}
	CATCH( CFileException , e )
	{
		return FALSE;
	}
	END_CATCH;
	
	return TRUE;
}

////////////////////////////////////////////////////////////////////////
// The overridden specialised functions for different mail messages
// Load, Write, Delete
//
BOOL CMailMessage::Load( void * Data )
{
	// Right, find the first file of the type *.wrk in the mailqueue
	// directory. 
	CStdioFile WorkFile;
	char Buffer[ 256 ];  
	char * p;                       
	m_SequenceNum = *(long *)Data;
	// Make the filenames;
		                    
	wsprintf( Buffer , "%s\\%ld.wrk" , gConfig->GetMailOutDir() , m_SequenceNum );	                    
	m_WorkFilePath = Buffer;
	wsprintf( Buffer , "%s\\%ld.txt" , gConfig->GetMailOutDir() , m_SequenceNum );	                    
	m_BodyFilePath = Buffer;
	if( !WorkFile.Open( m_WorkFilePath , CFile::modeRead | CFile::typeText ) )
	{
		return FALSE;
	}                
	// The work file is laid out as follows
	// line1: Host 
	// line2: from
	// line3 and subsequent lines? to.
	WorkFile.ReadString( Buffer , 255 );
	CString Tmp = strtok( Buffer , " \n\t\r" );                                
	m_ToHost = Tmp;
	WorkFile.ReadString( Buffer , 255 );
	Tmp = strtok( Buffer , " \n\t\r" );
	m_FromAddress = Tmp;
	int i = 0;
	while( WorkFile.ReadString( Buffer , 255 ) )
	{
		p = strtok( Buffer , " \n\t\r" );
		if ( p == NULL )
			continue;
		m_ToAddress.Add( p );
		i++;
	}
	
	// Now just check that we can open the data file
	if( !m_BodyFile.Open( m_BodyFilePath , CFile::modeRead | CFile::typeText ) )
	{
		return FALSE;
	}
	// CLose the file just so we save file handles
	m_BodyFile.Close();
	return TRUE;
}


// Very crap this one
BOOL CMailMessage::Write( void * )
{
	char * p = new char [ 512 ];

	m_BodyFile.Close();
	m_BodyFile.Open( m_BodyFilePath , CFile::modeRead | CFile::typeText );
	// Now try to open the user's mailbox
	CString MailBoxFilePath = GetMailBoxFile();
	CStdioFile MailBoxFile;
	// Create if not exist
	// ORM 13/10/94 Report if Fails to open mailbox eg if RCPT to name is duff
	if (!MailBoxFile.Open( MailBoxFilePath , CFile::modeReadWrite | CFile::typeText ) )
		{
		if (!MailBoxFile.Open( MailBoxFilePath , CFile::modeCreate | CFile::modeReadWrite | CFile::typeText ))
			{
			::MsgBox( MB_OK | MB_ICONHAND ,
					  IDS_MSG_MAILBOXFILE , (const char *)MailBoxFilePath );
			return FALSE;
			}
		}
	else
		MailBoxFile.SeekToEnd();
		
	// Write in the headers 
		
	time_t t;
	time( &t );   // leading \n is there for really fussy mail readers
				  // and ctime adds another.
	wsprintf( p , "From %s %s" , (const char * )m_FromAddress , ctime( &t ) );
	MailBoxFile.WriteString( p );
	// And the received from header
	MailBoxFile.WriteString( "Received:" );
		
	if ( m_System.GetLength() > 0 )   
	{
		MailBoxFile.WriteString(" from ");
		MailBoxFile.WriteString( m_System );
	}
	/* rfc 822 format */
	CTime TimeNow = CTime::GetCurrentTime();
	wsprintf( p , " by %s with SMTP \n\tid AA%ld ; %s\n" ,                                                          
					(const char *)gConfig->GetHostName() , GetMessageId() , (const char *)TimeNow.Format( "%a, %d %b %y %H:%M:%S %Z" ));

	MailBoxFile.WriteString( p );
			
	while( m_BodyFile.ReadString( p , 512 ) )
		MailBoxFile.WriteString( p );

	// add a blank line to separate the messages
	MailBoxFile.WriteString( "\n" );		    
	MailBoxFile.Close();
	m_BodyFile.Close();		            
	unlink( m_BodyFilePath );
	m_IsOpen = FALSE;   
	delete [] p;
	return TRUE;
}

// EMK Do this better
CString CMailMessage::GetMailBoxFile()
{
	// Just ka9q at the moment
	CString Path = gConfig->GetMailInDir();
	Path += "\\";                    
	// EMK just to one person at the moment
	CString User;
	CString Host;
	if( ParseUserHost( m_ToAddress[ 0 ] , User , Host ) )
	{
		Path += User.Left( 8 );
		Path += ".txt";
	}
	else
		Path += "dead.let";
	return Path;		
}

CMailMessageList::CMailMessageList()
 : CObList()
{                               
	// Reworking for WIN32 - CRCS 5/10/94 
	m_Failed = 0;
	m_Sent = 0;
	// Now try to build the list
	CString MailPath;
	CString FilePath;
#ifdef WIN32
	struct _finddata_t FindBuf;
	long FindHandle;
	int ignore;
#else
	struct _find_t FindBuf;
#endif	
	CMailMessage * Msg;

	MailPath = gConfig->GetMailOutDir();
	MailPath += "\\*.wrk";

#ifdef WIN32
	if( (FindHandle = _findfirst( MailPath.GetBuffer(ignore) ,/* _A_NORMAL ,*/ &FindBuf )) != -1L )
#else
	if( _dos_findfirst( MailPath , _A_NORMAL , &FindBuf ) == 0 )
#endif
	{                            
		do
		{                     
			long Seq = atol( FindBuf.name );
			Msg = new CMailMessage;
			if( !Msg->Load( &Seq ) )                               
			{
				::MsgBox( MB_OK | MB_ICONHAND, IDS_MSG_COULDNT_LOAD_MAIL_FILE , Seq );
				delete Msg;
			}
			else
			{
				CObList::AddTail( Msg );
			}
		}						
#ifdef WIN32						
		while( _findnext( FindHandle, &FindBuf ) == 0 );
		_findclose(FindHandle);
#else
		while( _dos_findnext( &FindBuf ) == 0 );
#endif
	}
#ifdef WIN32
	MailPath.ReleaseBuffer;
#endif
}

CMailMessageList::~CMailMessageList()
{
	while( !IsEmpty() )
	{
		CMailMessage * Msg = (CMailMessage *)RemoveHead();
		delete Msg;
	}
}

CMailMessage * CMailMessageList::GetNextMessage()
{   
	if( IsEmpty() )
		return NULL;
	else
		return(CMailMessage *)RemoveHead();
}

void CMailMessageList::DoneMessage( BOOL Sent )
{
	// Message is already removed from the list when we get it.   
	if( Sent )
	{
		m_Sent++;
	}
	else
	{
		m_Failed++;
	}
}		

// 
// Utility functions
//		
long GetMessageId()
{                
	char * sfilename = new char[ _MAX_PATH ];
	char s[20];
	long sequence = 0;
	CStdioFile sfile;
	wsprintf (sfilename, "%s\\sequence.seq", gConfig->GetMailOutDir());

	/* if sequence file exists, get the value, otherwise set it */
	if ( sfile.Open( sfilename , CFile::modeReadWrite | CFile::typeText ) )
	{
		sfile.ReadString( s , 19 );
		sequence = atol (s);
		/* Keep it in range of and 8 digit number to use for dos name
		 * prefix. */
		if (sequence < 0L || sequence > 99999999L)
			sequence = 0;

		sfile.Close();
	}

	/* increment sequence number, and write to sequence file */

	sfile.Open(sfilename, CFile::modeCreate | CFile::typeText );
	wsprintf( s , "%ld" , ++sequence );
	sfile.WriteString( s );
	sfile.Close();
	delete [] sfilename;
	return sequence;
}

/* Illegal characters in a DOS filename */
static char baddoschars[] = "\"[]:|<>+=;,";
        
#if 0        
/* test if mail address is valid */
int validate_address (char * s)
{
	char *cp, *t;
	DWORD addr;

	/* if address has @ in it the check dest address */
	if (*s == '@' && (cp = strrchr (s, ':')) != NULLCHAR)
		for (t = s, cp++; (*t++ = *cp++) != 0;)
			;

	if ((cp = strrchr (s, '@')) != NULLCHAR)
		{
		cp++;
		/* 1st check if its our hostname if not then check the hosts file
		 * and see if we can resolve ther address to a know site or one of
		 * our aliases */
		if (strcmp (cp, Hostname) != 0)
			{
			if ((addr = mailroute (cp, 0)) == 0
				&& (Smtpmode & QUEUE) == 0)
				return BADADDR;

			if (ismyaddr (addr) == NULLIF)
				return DOMAIN;

			}

		/* on a local address remove the host name part */

		*--cp = '\0';
		}

	/* if using an external router leave address alone */

	if ((Smtpmode & QUEUE) != 0)
		return LOCAL;

	/* check for the user%host hack */

	if ((cp = strrchr (s, '%')) != NULLCHAR)
		{
		*cp = '@';
		cp++;
		/* reroute based on host name following the % seperator */
		if (mailroute (cp, 0) == 0)
			return BADADDR;
		else
			return DOMAIN;
		}

	/* Check for characters illegal in MS-DOS file names */

	for (cp = baddoschars; *cp != '\0'; cp++)
	{
		if (strchr (s, *cp) != NULLCHAR)
			return BADADDR;

	}
	return LOCAL;
}
    
#endif     

