/***********************************************************************
**
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
///////////////////////////////////////////////////////////////////////
// nntpsock.h
// Declaration of the NNTP style socket
// This handles most of the interaction with the nntp server.
#ifndef _NNTPSOCK_H
#define _NNTPSOCK_H

#ifndef _CSOCKET_H
#include "csocket.h"
#endif         

// Classes needed in this header
class CNntpDlg;                            
class CNNTPHistoryList;
// Classes defined in this header
class CNntpInfo;
class CNntpSocket;

class CNntpInfo 
{
  public:
  	UINT		ArticlesToGet; 	// How many articles are there to get
  	UINT		ArticlesGot;   	// How many have we got so far
  	UINT		Duplicates;		// How many duplicate articles
  	UINT		Unavailable;	// How many were unavailable
  	DWORD		ArticleBytes;	// How many bytes?
  	DWORD		CurrentBytes;	// How much in the current article?
  	DWORD 		TotalBytes;		// All the stuff received
  	UINT		GroupsGot;		// How many groups have we got so far
  	UINT		NewGroupsGot;	// How many new groups have we got
  	time_t		SessionStart;
  	time_t		NewsStart;
  // zero on create
  	CNntpInfo() { ArticlesToGet = ArticlesGot = Duplicates = GroupsGot = NewGroupsGot = Unavailable = 0;
  				  ArticleBytes = CurrentBytes = TotalBytes = 0; 
  				  SessionStart = NewsStart = (time_t)0;}	
};
  
//////////////////////////////////////////////////////////////////////////
// This class (derived from a line buf socket) handles all the work
// in downloading a batch of news from a server.  It updates
// the parent dialog by sending a message with the LParam pointing
// to an CNntpInfo structure.
//  

// The constants
#define NntpLineBufSize 513

class CNntpSocket : public CLineSocket
{
  public:
  	enum nntpStates {
  		INIT,
	  	CONNECTED,
 	 	WAITGROUPSCONF,
 	 	WAITGROUPS,                                  
 	 	WAITNEWGROUPSCONF,
 	 	WAITNEWGROUPS,    
 	 	WAITARTIDSCONF,
 	 	WAITARTIDS,    
 	 	WAITARTSCONF,
 	 	WAITARTS,
 	 	CLOSING,      
  	};

	CNntpSocket( tcLogger * Log , CNntpDlg * pParent , int Rbs = 8192 , int Wbs = 1024 );
	// Large default read buffer since there's going to be a lot puking into
	// this socket
    ~CNntpSocket();
	BOOL Init( CNNTPHistoryList * HistList , CTime ThisTime );              
	void SaveNntpDat();
	
	// State Table Functions
	BOOL DoInit( char * Str );
	BOOL DoConnected( char * Str );
	BOOL DoWaitGroupsConf( char * Str );
	BOOL DoWaitGroups( char * Str );
	BOOL DoWaitNewGroupsConf( char * Str );
	BOOL DoWaitNewGroups( char * Str );
	BOOL DoWaitArtIdsConf( char * Str );
	BOOL DoWaitArtIds( char * Str );
	BOOL DoWaitArtsConf( char * Str );
	BOOL DoWaitArts( char * Str );
	BOOL DoClosing( char * Str );


  protected:
    // The overridden read and write functions
    virtual void lineRead();
    virtual void dataWritten();
    virtual void Connected(int error);
	virtual void Closed( int error ); 		
	virtual void Timeout();
  private: 

	// the parsing functions etc
	BOOL DownloadGroups();
	BOOL DownloadNewGroups();
	BOOL DownloadArticleIds();
	BOOL DownloadArticle();
	int ParseReply( const char * Str);
	char * ParseBuffer( char * Buf);
	void AbortConversation();
	void EndConversation(BOOL Save);
	BOOL ProtocolError( const char * Str , int Expected );
  	void TPrintf( int Level , const char * Fmt ,...);
	
	// The data
	CNntpDlg * m_Parent;
    CNntpInfo * m_Info;
    nntpStates m_State;     
    CString m_BatchName;                
    CStdioFile m_BatchFile;
    BOOL m_BatchIsOpen;
    CString m_NntpFileName;
    CStringList m_ArticlesToGet;
    CStringList m_CurrentList;
    CString	m_CurrentId;
    CStringList m_NewsGroups;
    CStringList m_SaveGroups;
    CTime m_LastTime;
    CTime m_ThisTime;
    int	m_BatchOutstanding;           
    char * m_LineBuf;
    CNNTPHistoryList * m_HistList;
	 BOOL	m_GotSomething;
};
    


#endif
