/***********************************************************************
**
** SERVDLG.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
**
** This is the dialog which handles the UI for the SMTP Server.
** Implemented as a toolbar window but could be a free floating
** mdichild.
**
** V1.0 - Initial Revision 01-Sep-94
**
*/

#include "stdafx.h"
#include "windis.h"
#include "utility.h"
#include "servdlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CServDlg dialog

CServDlg::CServDlg()
	: CClientDlg()
{
	//{{AFX_DATA_INIT(CServDlg)
	//}}AFX_DATA_INIT
	m_ListenSock = NULL;
	m_Log = AllocateLogger( "smtpsrv" );
	m_TickConnect = 0;
	m_Received = 0;
	m_QuietIcon = AfxGetApp()->LoadIcon( IDI_SERVICON );
	m_ListenIcon = AfxGetApp()->LoadIcon( IDI_SERVLISTENICO );
	ASSERT( m_QuietIcon != NULL );
	ASSERT( m_ListenIcon != NULL );
}

// Clean up all the sockets.  Note that if the 
// m_Bitmap is nonnull, it's deleted in the clidlg destructor.
CServDlg::~CServDlg()
{
	// Close and delete everything on the socket list
	while( !m_SockList.IsEmpty() )
	{
		CServSocket * Sock = m_SockList.RemoveHead();
		ASSERT( Sock != NULL );
		Sock->Close();
		delete Sock;
	}
	delete m_ListenSock;
	delete m_Log;
}
		                                      
BOOL CServDlg::Create( CWnd * pParent )
{
	return CClientDlg::Create( IDD , pParent );
}
                                      
void CServDlg::DoDataExchange(CDataExchange* pDX)
{
	CClientDlg::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CServDlg)
	DDX_Control(pDX, IDC_SERVRECEIVED, m_ServReceived);
	DDX_Control(pDX, IDC_SERVICON, m_ServIcon);
	DDX_Control(pDX, IDC_SMTPSERVLIST, m_ListBox);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CServDlg, CClientDlg)
	//{{AFX_MSG_MAP(CServDlg)
	ON_MESSAGE( WM_SOCK_CLOSE, OnSockClose )
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CServDlg message handlers                
// Kick:
// Kick creates the listen socket and updates the bitmap.
// Note that this will kick off slip connections which 
// have an ondemand dialer.  Of course with our own
// dialer, things are different!
void CServDlg::Kick()
{       
	ASSERT( m_ListenSock == NULL );
	m_ListenSock = new CServSocket( m_Log , this , 8192 , 1024 );
	int rc = m_ListenSock->Listen( 25 );
	if( rc != 0 )
	{
            SocketError( m_ListenSock , rc );
            m_ListenSock->Close();
            delete m_ListenSock;
            m_ListenSock == NULL;
    }
    else
    {
    	// Right, it's listening so check to see if we want to kick
    	// everything else.
		if( gConfig->GetStartupOption() == 2)
			GetParent()->PostMessage( WM_COMMAND , ID_KICK_ALL , 0 );
   	}
	DoBitmap();
}                                  
                                
// Abort:
// For an smtpserver, this is a bit strange, but what we do
// is delete all ongoing transations and delete the listen
// socket as well.  This way, there's no winsock going on
// and Slip connections can drop themselves.                              
void CServDlg::Abort()
{
	delete m_ListenSock;
	m_ListenSock = NULL;
	while( !m_SockList.IsEmpty() )
	{
		CServSocket * Sock = m_SockList.RemoveHead();
		Sock->Close();
		delete Sock;
	}
	DoBitmap();
}
                      
//
// This gets called if the client closes the socket
// on us.  In fact, for SMTP, the client should
// always close the socket and so we should get
// notifications of here.  Just close the socket
// by posting the close message.
void CServDlg::Closed( int error , tcSocket * Sock )
{
	Close(error , Sock );
}        

// Connected:
// For this socket, we wouldn't expect any connections at all.
// This is an error if this gets called but it's here to
// track these things.
void CServDlg::Connected( int , tcSocket * )
{           
	Trace( 0 , IDS_TRACE_NO_CONNECT );
}

// 
// When a connection comes in on the Listen Socket,
// it calls this function passing it's own address
// as a parameter (well, why not?)
// If there was an error, we do something wimpy but
// if everything's ok, we create a new socket for
// this connection and kick it off.  It gets
// added to the list of sockets so we can delete it
// again.               
void CServDlg::Accept(int , tcSocket * Sock)
{                                                
	ASSERT( Sock == m_ListenSock );
	CServSocket * NewSock = m_ListenSock->Accept();
	if( NewSock )
	{
		if( NewSock->Init() )
			m_SockList.AddTail( NewSock );
		DoBitmap();
	}
	else
	{              
		Trace( 0 , IDS_TRACE_PROBLEM_IN_ACCEPT );
	}
}

// 
// all closing of the socket should go through this routine
// which is generally posted to.
// We can be sure that the socket isn't somewhere on the
// stack above us when we get this and so we can delete it
// with impunity.
LRESULT CServDlg::OnSockClose(WPARAM Error, LPARAM lParam)
{                                                         
	if( Error )
		SocketError( ( tcSocket * )lParam , Error );
		
	KillSocket( (tcSocket *)lParam );
	DoBitmap();
	Trace( 1 , IDS_TRACE_CLOSED_CONNECTION );
	return 0;
}

// 
// Trace:  Takes a level and a character string
// and outputs the character string to a the list box.
// This is called pretty frequently so I guess that
// there should be an inline function to call 
// which probably shouldn't be virtual either.
void CServDlg::Trace( int Level , const char * p)
{                              
	if( Level > gConfig->GetServTrace() )
		return;
	// Dump the information into the dialog
	int rc;
	if ( ( rc = m_ListBox.AddString( p ) ) == LB_ERRSPACE )
	{
		// Empty the list box now
		m_ListBox.ResetContent();
		m_ListBox.AddString( "Emptied Listbox" );
		rc = m_ListBox.AddString( p );
	}        
	m_ListBox.SetTopIndex( rc - 1); // Maybe this could be done better
}                                                                     
                                     
//
// Timeout:  Overridden version of the Clientdialog Timeout.
// To avoid problems, this function calls Close() which 
// **POSTS** a message to the dialog to tell it to delete
// the socket.  This is because this function is called
// by the socket we want to delete.  Major badness if
// we delete an object which is still on the call stack
void CServDlg::Timeout(tcSocket * Sock)
{       
	Trace( 0 , TimeoutGetId( Sock ) );
	Close( 0 , Sock );                
}

	
//
// KillSocket:  Takes a pointer to a socket and tries to find it
// in the socket list.  If successful (and it should be successful)
// then it removes it from the list.  Leaves the bitmap updating
// to the caller.                             
void CServDlg::KillSocket( tcSocket * TheSocket )
{
	if( TheSocket != NULL )
	{
		CServSocket * Sock = (CServSocket *)TheSocket;
		POSITION Pos = m_SockList.Find( Sock );
		ASSERT( Pos != NULL );
		if( Pos != NULL )
		{
			m_SockList.RemoveAt( Pos );
		}
		delete Sock;
	}
}
                     
void CServDlg::ReceivedMessage()
{                                       
	char Buf[ 16 ];
	m_Received++;
	wsprintf( Buf , "%d" , m_Received );
	m_ServReceived.SetWindowText( Buf );
};                     
// DoBitmap:  Handles the creation of an animated bitmap
// if there's one or more active sockets.  If not, then
// if the socket is listening, draw the listen icon, else
// draw the nonlistening icon
void CServDlg::DoBitmap()
{
	if( !m_SockList.IsEmpty() )
	{                                      
		SetIcon( &m_ServIcon );
		return;
	}
	// If we get here , the socket list is empty
	ClearIcon();
	// Finally, check for the Listening Icon
	if( m_ListenSock == NULL )
		m_ServIcon.SetIcon( m_QuietIcon );
	else
		m_ServIcon.SetIcon( m_ListenIcon );
	return;
}

void CServDlg::OnLButtonDown(UINT nFlags, CPoint point)
{
	// Check to see if this is in the client rectangle of
	// the icon.  If so then this is a kick.
	CRect IcoRect;
	m_ServIcon.GetWindowRect( IcoRect );
	ClientToScreen( &point );
	if( IcoRect.PtInRect( point ) )
	{
		if( IsConnected() )
			Abort();
		else
			Kick();
	}
	else
		CClientDlg::OnLButtonDown(nFlags, point);
}
