/***********************************************************************
**
** CANIBMP.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
** It is the implementation of the CAnimatedBitmap class.
** This class responsible for animating itself in a particular
** location
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
///////////////////////////////////////////////////////////////////////
// nntpsock.h
// Declaration of the NNTP style socket
// This handles most of the interaction with the nntp server.
#ifndef _MAILSOCK_H
#define _MAILSOCK_H

#ifndef _CSOCKET_H
#include "csocket.h"
#endif
#ifndef _MESSAGE_H
#include "message.h"
#endif

// classes defined in this file
class CServSocket; // Defined forward
class CServSocketList;
// classes needed in this file
class CServDlg;

// A wrapper for lists of sockets
class CServSocketList : public CPtrList
{
  public:
  	CServSocketList() : CPtrList() {;}
  	~CServSocketList() {;}
  	POSITION AddTail( CServSocket * p ) { return CPtrList::AddTail( (void *) p ); }
  	CServSocket * GetHead() {return (CServSocket *)CPtrList::GetHead(); }
  	CServSocket * RemoveHead() { return (CServSocket *)CPtrList::RemoveHead(); }
  	POSITION Find( CServSocket * p ) { return CPtrList::Find( (void *)p ); }
  	CServSocket * GetAt( POSITION p ) { return (CServSocket *)CPtrList::GetAt( p ); } 
};


//////////////////////////////////////////////////////////////////////////
// This class (derived from a line buf socket) handles all the work
// in waiting for mail messages on the smtp socket
//  
#define ServLineBufSize 1025

class CServSocket : public CLineSocket
{
  public:
  	enum servCommands {
  	HELO,
  	EHLO,
  	RCPT,
  	DATA,
  	RSET,
  	SEND,
  	SOML,
  	SAML,
  	MAIL,
  	VRFY,
  	EXPN,
  	HELP,
  	NOOP,
  	QUIT,
  	TURN,
  	SERVERROR
  	};
                                          
  protected:   
  	enum servStates {
  	SERVLISTEN,
  	SERVCOMMAND,
  	SERVDATA
  	};  	
  public:
	CServSocket( tcLogger * Log , CServDlg * pParent ,  int Rbs = 1024 , int Wbs = 8192 );
	CServSocket( tcLogger * Log , SOCKET s , CServDlg * pParent ,  int Rbs = 1024 , int Wbs = 8192 );
    virtual ~CServSocket();
	BOOL Init();
    CServSocket * Accept(); 
    
  protected:
    // The overridden read and write functions
    virtual void lineRead();
    virtual void dataWritten();
    virtual void Connected(int error);
    virtual void Accepted(int error );
	virtual void Closed( int error ); 		
  private: 
	servCommands ParseCommand( char * Buf , char * &Arguments );
	const char * ParseData( const char * Buf );
	void		 DoHelo( char * Str );
	void		 DoRcpt( char * Str );
	void		 DoData( char * Str );
	void		 DoRset( char * Str );
	void		 DoMail( char * Str );
	void		 DoVrfy( char * Str );
	void		 DoExpn( char * Str );
	void		 DoHelp( char * Str );
	void		 DoNoop( char * Str );
	void		 DoQuit( char * Str );
	void		 DoTurn( char * Str ); 
	void		 DoError(char * Str );
	void		 SendCommand( int Cmd , const char * Str );
	                                                 
	CServDlg * m_Parent;	                                                 
	servStates m_State;  
	CMailMessage * m_Msg;
	char * m_LineBuf;
};
    
#endif
