/***********************************************************************
**
** SMTPDLG.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
**
** The UI for the SMTP client dialog.  This dialog sends the mail.
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
// smtpdlg.cpp : implementation file
//

#include "stdafx.h"
#include "windis.h"
#include "utility.h"
#include "message.h"
#include "smtpsock.h"
#include "smtpdlg.h"                  

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSmtpDlg dialog

CSmtpDlg::CSmtpDlg()
	: CClientDlg()
{
	//{{AFX_DATA_INIT(CSmtpDlg)
	//}}AFX_DATA_INIT
	m_Log = AllocateLogger( "smtpcli" );
	SetKickTime( gConfig->GetMailKickSeconds() );    
	m_Connected = FALSE;
	m_MsgList = NULL;
	m_TotalSent = 0;
}

CSmtpDlg::~CSmtpDlg()
{
	while( !m_SockList.IsEmpty() )
	{
		CSmtpSocket * Sock = m_SockList.RemoveHead();
		ASSERT( Sock != NULL );
		Sock->Close();
		delete Sock;
	}                   
	m_Connected = FALSE;
	delete m_Log;    
	delete m_MsgList;
}

	
BOOL CSmtpDlg::Create( CWnd * pParent )
{
	return CClientDlg::Create( IDD , pParent );
}
                                      
void CSmtpDlg::DoDataExchange(CDataExchange* pDX)
{
	CClientDlg::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSmtpDlg)
	DDX_Control(pDX, IDC_MAIL_SENDING, m_Sending);
	DDX_Control(pDX, IDC_MAIL_SENT, m_MailSent);
	DDX_Control(pDX, IDC_MAIL_QUEUED, m_MailQueued);
	DDX_Control(pDX, IDC_MAIL_FAILED, m_MailFailed);
	DDX_Control(pDX, IDI_MAILICO, m_MailIcon);
	DDX_Control(pDX, IDC_SMTPLIST, m_ListBox);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSmtpDlg, CClientDlg)
	//{{AFX_MSG_MAP(CSmtpDlg)
	ON_WM_CREATE()
	ON_MESSAGE( WM_SOCK_CLOSE, OnSockClose )
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSmtpDlg message handlers
int CSmtpDlg::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CClientDlg::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	return 0;
}

void CSmtpDlg::UpdateDisplay()
{           
	char Buffer[ 16 ];
	char * Fmt = "%d";
	int Queued = 0;
	int Sending= 0;
	int Sent   = 0;
	int Failed = 0;
	if( m_MsgList != NULL )
	{
		Queued = m_MsgList->Queued();
		Sending= m_SockList.GetCount();
		Sent   = m_MsgList->Sent();
		Failed = m_MsgList->Failed();
	}
	wsprintf(Buffer , Fmt , Queued );
	m_MailQueued.SetWindowText( Buffer );
	wsprintf(Buffer , Fmt , Sending );
	m_Sending.SetWindowText( Buffer );
	wsprintf(Buffer , "%d/%d" , Sent , m_TotalSent );
	m_MailSent.SetWindowText( Buffer );
	wsprintf(Buffer , Fmt , Failed );
	m_MailFailed.SetWindowText( Buffer );
}

void CSmtpDlg::Kick()
{                                                 
	ClearKickTime();
	if( !m_SockList.IsEmpty() )
	{              
		Trace( 0 , IDS_TRACE_ALREADY_PROCESSING_MAIL );
		return;
	}                                                      
	if( m_MsgList == NULL )
		m_MsgList = new CMailMessageList();
	
	UpdateDisplay();
	if( m_MsgList->IsEmpty() )
	{
		Trace( 0 , IDS_TRACE_NO_QUEUED_MESSAGES );
		SetKickTime( gConfig->GetMailKickSeconds() );    
		delete m_MsgList;     
		m_MsgList = NULL;
		return;
	}	       
	// Now we know that we're not doing anything and
	// that there's something to do
	while( !m_MsgList->IsEmpty() &&
		    m_SockList.GetCount() < gConfig->GetMailSessions() )   
	{
		DoMessage();  
	}
}		
		                                   
void CSmtpDlg::Abort()
{
	KillSocket( NULL );
}		                                   

void CSmtpDlg::Closed( int error , tcSocket * Sock )
{
	Close( error , Sock );
}
void CSmtpDlg::Timeout( tcSocket * Sock )
{
	Trace( 0 , TimeoutGetId( Sock ) );
	Close( 0 , Sock );
}

void CSmtpDlg::Connected( int Error , tcSocket * Sock )
{                                                
	if( Error != 0 )
		Close( Error , Sock );
	// And do nothing
}
	
// The Socket Handlers
void CSmtpDlg::Trace( int Level , const char * p )
{                            
	// Dump the information into the dialog
	if( Level > gConfig->GetSmtpTrace() )
		return;
	int rc;
	if ( ( rc = m_ListBox.AddString( p ) ) == LB_ERRSPACE )
	{
		// Empty the list box now
		m_ListBox.ResetContent();
		m_ListBox.AddString( "Emptied Listbox" );
		rc = m_ListBox.AddString( p );
	}        
	m_ListBox.SetTopIndex( rc - 1); // Maybe this could be done better
}                                                                     

LRESULT CSmtpDlg::OnSockClose(WPARAM Error, LPARAM lParam )
{                                               
	CSmtpSocket * Sock = (CSmtpSocket *)lParam;   
	if( Error != 0 )
	{
		SocketError( Sock , Error );
	}
	
	// All this does is update the display with failed and succeeded!
	m_MsgList->DoneMessage( Sock->IsSuccess() );
	if( Sock->IsSuccess() )
		m_TotalSent++;
	UpdateDisplay();

	// Now delete this socket from this list
	KillSocket( Sock );                     
	
	// More messages?
	if( !m_MsgList->IsEmpty() )
	{                        
		DoMessage();
	}
	else
	{                
		// If not then we have to check whether there are still
		// things in progress.                
		if( m_SockList.IsEmpty() )
		{               
			m_Connected = FALSE;
			delete m_MsgList;
			m_MsgList = NULL;
			SetKickTime( gConfig->GetMailKickSeconds() );    
		};
	}
	return 0;
}


void CSmtpDlg::DoMessage()
{                                   
	// This call removes the message from the list
	CMailMessage * Msg = m_MsgList->GetNextMessage();
	ASSERT( Msg != NULL );                        
	// Create the new socket and give it its message to deal with
	CSmtpSocket * Sock = new CSmtpSocket( m_Log , this , Msg);
	SetIcon( &m_MailIcon );
	m_SockList.AddTail( Sock );
	// And this kicks the whole stuff into action.
	Sock->ConnectGateway();   
	m_Connected = TRUE;
	UpdateDisplay();
}                                                



                               
void CSmtpDlg::KillSocket( CSmtpSocket * Sock)
{
	if( Sock != NULL )
	{
	    POSITION Pos = m_SockList.Find( Sock );
	    ASSERT( Pos != NULL );
	    if( Pos != NULL )
	    {
	        m_SockList.RemoveAt( Pos );
	    }
		Sock->ClrTimeout();
		Sock->Close();
		delete Sock;
	}                
	else
	{
		while( !m_SockList.IsEmpty() )
		{
	    	Sock = m_SockList.RemoveHead();
			Sock->ClrTimeout();
			Sock->Close();
			delete Sock;
		}
	}
	if( m_SockList.IsEmpty() )
	{
		m_Connected = FALSE;
        ClearIcon();
    }    	        
    UpdateDisplay();
	RedrawWindow();
	return;
}

void CSmtpDlg::OnLButtonDown(UINT nFlags, CPoint point)
{
	// Check to see if this is in the client rectangle of
	// the icon.  If so then this is a kick.
	CRect IcoRect;
	m_MailIcon.GetWindowRect( IcoRect );
	ClientToScreen( &point );
	if( IcoRect.PtInRect( point ) )
	{
		if( IsConnected() )
			Abort();
		else
			Kick();
	}
	else
		CClientDlg::OnLButtonDown(nFlags, point);
}
