/***********************************************************************
**
** SMTPSOCK.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
**
** This is the SMTPClient socket.  Should handle all the interaction
** necessary to send a CMailMessage.  However, **only** sends
** mail through the Gateway at the moment.  There's some
** really shitty logic round about this which I just ignored.
** Also, doesn't do batch because I couldn't be bothered.  
** This really needs a good tidy up.
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
////////////////////////////////////////////////////////////////////
// smtpsock.cpp
// Implementation of the nntpclient socket
#include "stdafx.h"
#include "windis.h"
#include "utility.h"
#include "tcsock.h"
#include "csocket.h"
#include "message.h"
#include "smtpsock.h"  
#include "smtpdlg.h"                

// The simple inline constructors for the time Socket
CSmtpSocket::CSmtpSocket( tcLogger * Log , CSmtpDlg * pParent , CMailMessage * Msg , int Rbs , int Wbs )
	: CLineSocket( Log , Rbs , Wbs )
{
	ASSERT_VALID( pParent );
	m_Parent = pParent;
	m_State = INIT;
	m_LineBuf = new char[ SmtpLineBufSize ];
	m_Batch = gConfig->GetMailBatch();
	m_Message = Msg; // This guy now belongs to the socket.
	m_Error = FALSE; 
}

CSmtpSocket::~CSmtpSocket()
{                                             
	delete [] m_LineBuf;                                   
	delete m_Message;
}           


void CSmtpSocket::lineRead()
{                                         
	BOOL Post = FALSE;
	readLine( m_LineBuf , SmtpLineBufSize - 1 );
	SmtpParse(m_LineBuf);
	return;
}			
 
void CSmtpSocket::SmtpParse(const char * Str)
{
	CString sLine;
	int iReturn = atoi( Str );  // maybe should extract the number before
								// doing this.
	m_Parent->Trace( 4 , Str );
	switch( iReturn /100 )
	{
    case 2: // or iReturn in the range 200 To 299:  Ok reply
   		switch( m_State )
   		{
        case HELO:                        
               	sLine = "HELO ";
               	sLine += gConfig->GetHostName();
				writeLine( sLine );
        		if( m_Batch )
        		{
					// Fire out all the stuff in one big go
                	sLine = "MAIL FROM: <";
                	sLine += m_Message->GetFromAddress();
                	sLine += ">";
                	writeLine( sLine );
                	for( int i = 0 ; i < m_Message->GetRecipientCount() ; i++ )
                	{
                		sLine = "RCPT TO: <";
                		sLine += m_Message->GetToAddress( i );
                		sLine += ">";
                		writeLine( sLine );
                	}
                	sLine = "DATA";
                	writeLine( sLine );
				};					
                m_State = MAILFROM;
                // Removed the VRFY part here.
                break;
        case MAILFROM:
        		if( !m_Batch )
        		{
                	sLine = "MAIL FROM: <";
                	sLine += m_Message->GetFromAddress();
                	sLine += ">";
                	writeLine( sLine );
                };
                m_State = RCPTTO;
                break;
        case RCPTTO:
        		if( !m_Batch )
        		{
                	for( int i = 0 ; i < m_Message->GetRecipientCount() ; i++ )
                	{
                		sLine = "RCPT TO: <";
                		sLine += m_Message->GetToAddress( i );
                		sLine += ">";
                		writeLine( sLine );
                	}
                };
                m_State = DATA;
               	break;
        case DATA:
        		if( !m_Batch )
        		{
                	sLine = "DATA";
                	writeLine( sLine );
                };
                m_State = WAITOKSEND;
                break;
        case QUIT:            
        		m_Message->SetToDelete();
                CloseSession();
                break;
        case INACTIVE: 
        		m_Parent->Closed(m_Error , this );
                // Do something here
                break;
		default:
				// Do something here too
				break;
		}
		m_Parent->Trace( 2 , sLine );
		break;

	case 3: // Or in other words  300 To 399:  Informational reply
		switch( m_State )
		{                           
		case WAITOKSEND:
        	m_LinesToSend = TRUE; // So the write callback functions
            m_State = SENDBODY;
            // Call the data written function to kick everything off
            dataWritten();
            break;
		case SENDBODY:
			m_State = QUIT;
			break;
		default:
			// Handle error here too
			break;
		}
		break;
	case 5: // Or in other words 500 To 599: Error reply
		//ReportProgress "500 Error! Abort!"
		switch( m_State )
		{
		case SENDBODY:
			sLine = ".\nQUIT"; // Try to finish the message
			writeLine( sLine );	
			m_State = INACTIVE;
			break;
		default:
			sLine = "QUIT";
			writeLine( sLine );
			m_State = INACTIVE;
			break;
		}           
		m_Error = TRUE;
		break;
	default:
		//    ReportProgress "Unknown reply #" & Str$(iReturn) & "0!"
		break;
	} // End of main switch
	return;
}
	
void CSmtpSocket::dataWritten()
{
	char Buffer[ 256 ];                          
	
	if( m_State == SENDBODY )
	{
		// This is the only time that we really care if the data
		// has been written  
		// Check for enough space
		if( m_LinesToSend && wrSpace() > 254 )// buffer + newline
		{
			if ( !m_Message->GetLine( Buffer , 254) )
			{
				m_LinesToSend = FALSE;
				strcpy( Buffer , "." );
				m_State = QUIT;
			}
			writeLine( Buffer );
			m_Parent->Trace( 4 , Buffer );
		}
	}
}


void CSmtpSocket::Connected(int error)
{                                     
	delMask( FD_CONNECT );
	ClrTimeout();
	if( error == 0 )
	{        
		m_State = HELO;
		m_Parent->Connected( error , this );
		m_Parent->TPrintf( 0 , "Connected to %s, starting SMTP session" , m_RemoteHost );
	}
	else
	{                      
		// We are really in the shit, nothing can be sent
		m_Parent->Trace( 0 , "Couldn't connect to mail gateway" );
		m_Parent->Close( error , this );
		m_State = INIT;
	}
}                                                              
void CSmtpSocket::CloseSession()
{
	writeLine( "QUIT" );
	m_State = INACTIVE;
	m_Parent->Trace( 0 , "Sent" );
}                                                              


void CSmtpSocket::ConnectGateway()
{
	m_State = TRYGATEWAY;
	m_RemoteHost = gConfig->GetMailGateway();
	m_Parent->TPrintf( 0 , "Connecting to %s" , (const char *)m_RemoteHost );
	int rc = Connect( m_RemoteHost , 25 );
	if ( rc != 0 )
	{   
		m_Parent->TPrintf( 0 , "Couldn't connect to %s" , (const char *)m_RemoteHost );
		m_Parent->Close( 0 , this );
	}
	else
	{
		SetTimeout( TIMEOUT_CONNECT , TO_CONNECTING );
	}
}                                               


// Overridden timeout function
void CSmtpSocket::Timeout()
{
	// We'll have to so something clever when we try to connect
	// to the host before the gateway.  But for now?
	m_Parent->Timeout( this );
}
		
			
