/***********************************************************************
**
** CANIBMP.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
** It is the implementation of the CAnimatedBitmap class.
** This class responsible for animating itself in a particular
** location
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
// timedlg.h : header file
//

#ifndef _TIMEDLG_H
#define _TIMEDLG_H
                      
#include "csocket.h"                                  
#include "clidlg.h"

                                  
/////////////////////////////////////////////////////////////////////////////
// CTimeDlg dialog

class CTimeDlg : public CDialog
{
// Construction
public:
	CTimeDlg(BOOL Simple, const char * Host , CWnd * pParent = NULL );	// standard constructor
	virtual ~CTimeDlg();// standard destructor
	CTime	GetTime() const { return CTime( m_time ); }
	CTime	GetLocalTime() const { return CTime(m_localtime); }	
	void ReadTime( time_t Time );
	virtual void Connected( int Error , tcSocket * Sock );
	virtual void Closed( int Error , tcSocket * Sock );
	virtual void Timeout( tcSocket * Sock );
	
// Dialog Data
	//{{AFX_DATA(CTimeDlg)
	enum { IDD = IDD_TIMEDLG };
	CStatic	m_LocalTime;
	CButton	m_Button;
	CStatic	m_Progress;
	//}}AFX_DATA
// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CTimeDlg)
	afx_msg void OnClickedTimeCancel();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:         
	tcLogger * m_Log;
	tcSocket * m_Sock;
	time_t	m_time;
	time_t	m_localtime;
	BOOL	m_Flag;                           
	CString m_Host;
};
#endif
