/***********************************************************************
**
** WDISCONF.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
**
** The **right** way to handle configuration files.
** There's One Configuration object.  If you want to
** add a config object, add the Declaration in the .h file
** and the definition in this file.  Use the Macros.  They're
** great.  Save a lot of typing and it's difficult (but not
** impossible) to screw up.  You also manage to save a bit
** of space in the static data segment by not having all these
** identical strings all over the place.
**  
** Configurations are stored as global ones and setupsets.
** This is to allow switching between sets which I did at
** work and at home.
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
///////////////////////////////////////////////////////////////////////////
// wdisconf.cpp
// Configuration implementation
//
#include "stdafx.h"
#include "windis.h"
#include "newssup.h"
#include "utility.h"

// turn pcode on
#pragma optimize( "q" , on )

#define MAX_SETUP_SETS 16
#define MAX_FINGER_SETS 8

CWindisSetup * gConfig;
const char * FreeFingerStr = "--Free--";
static const char BASED_CODE StrGlobalName[] = "Globals";
static const char BASED_CODE StrPrefName[] = "Preferences";
static const char BASED_CODE StrSetupSets[] = "SetupSets";
static const char BASED_CODE StrDefault[] = "Default";
static const char BASED_CODE StrFinger[] = "Finger";
static const char BASED_CODE StrNoSetName[] = "##_NONE_##";
static const char BASED_CODE StrDialer[] = "Dialer";
static const char BASED_CODE szFont[] = "Font";
static const char BASED_CODE szHeight[] = "Height";
static const char BASED_CODE szWeight[] = "Weight";
static const char BASED_CODE szItalic[] = "Italic";
static const char BASED_CODE szUnderline[] = "Underline";
static const char BASED_CODE szPitchAndFamily[] = "PitchAndFamily";
static const char BASED_CODE szFaceName[] = "FaceName";
static const char BASED_CODE szSystem[] = "System";

// Macros to make maintenance easier
#define WRITESTR( String ) 				AfxGetApp()->WriteProfileString( CurrentSet , #String , String )
#define WRITEINT( Int ) 				AfxGetApp()->WriteProfileInt( CurrentSet , #Int , Int );
#define WRITEGLOBSTR( String ) 			AfxGetApp()->WriteProfileString( StrGlobalName , #String , String )
#define WRITEGLOBINT( Int ) 			AfxGetApp()->WriteProfileInt( StrGlobalName , #Int , Int );
#define WRITEPREFSTR( String ) 			AfxGetApp()->WriteProfileString( StrPrefName , #String , String )
#define WRITEPREFINT( Int ) 			AfxGetApp()->WriteProfileInt( StrPrefName , #Int , Int );
#define WRITEFINGSTR( String ) 			AfxGetApp()->WriteProfileString( StrFinger , #String , String )
#define WRITEFINGINT( Int ) 			AfxGetApp()->WriteProfileInt( StrFinger , #Int , Int );
#define READSTR( IniEntry , Def ) 		IniEntry = AfxGetApp()->GetProfileString( CurrentSet , #IniEntry , Def )
#define READINT( IniEntry , Def ) 		IniEntry = AfxGetApp()->GetProfileInt( CurrentSet , #IniEntry , Def )
#define READGLOBSTR( IniEntry , Def )	IniEntry = AfxGetApp()->GetProfileString( StrGlobalName , #IniEntry , Def )
#define READGLOBINT( IniEntry , Def )	IniEntry = AfxGetApp()->GetProfileInt( StrGlobalName , #IniEntry , Def )
#define READPREFSTR( IniEntry , Def )	IniEntry = AfxGetApp()->GetProfileString( StrPrefName , #IniEntry , Def )
#define READPREFINT( IniEntry , Def )	IniEntry = AfxGetApp()->GetProfileInt( StrPrefName , #IniEntry , Def )
#define READFINGSTR( IniEntry , Def )	IniEntry = AfxGetApp()->GetProfileString( StrFinger , #IniEntry , Def )
#define READFINGINT( IniEntry , Def )	IniEntry = AfxGetApp()->GetProfileInt( StrFinger , #IniEntry , Def )
// the dialer strings are different because they're written to both
// the current setup set and the global [Dialer] section
// And because we've got to token paste in a % for the ints
// and a $ for the strings
#define WRITEDIALINT( Int ) 			AfxGetApp()->WriteProfileInt( CurrentSet , "%"#Int , Int );\
										AfxGetApp()->WriteProfileInt( StrDialer  , "%"#Int , Int )
#define WRITEDIALSTR( String ) 			AfxGetApp()->WriteProfileString( CurrentSet, "$"#String , String );\
										AfxGetApp()->WriteProfileString( StrDialer , "$"#String , String )
#define READDIALINT( IniEntry , Def )	IniEntry = AfxGetApp()->GetProfileInt( CurrentSet , "%"#IniEntry , Def )
#define READDIALSTR( IniEntry , Def )	IniEntry = AfxGetApp()->GetProfileString( CurrentSet , "$"#IniEntry , Def )

// The Initialisation function
CWindisSetup::CWindisSetup()
{   
	// The globals
	READGLOBINT( Version , -1 );
	READGLOBINT( NntpTrace , 1);
	READGLOBINT( SmtpTrace , 1);
	READGLOBINT( ServTrace , 1);
	READGLOBINT( SocketLogging , FALSE );
	READGLOBSTR( LogPath , "c:\\" );
	READGLOBSTR( DefaultRecipient , "postmast" );	
	READGLOBINT( AnimatedBitmaps , TRUE );
	READGLOBSTR( FingerDefault , FreeFingerStr );
	// Now load the default setup
	READGLOBSTR( DefaultSet , "Set0" );
	CurrentSet = DefaultSet;
	LoadCurrentSet();
	// Finally, load the preferences
	READPREFINT( StartupOption , 0 );
	READPREFINT( ViewNews , 1 );
	READPREFINT( ViewSmtp , 1 );
	READPREFINT( ViewServ , 1 );
}

CWindisSetup::~CWindisSetup()
{
}

void CWindisSetup::WriteGlobalSet()
{                            
	WRITEGLOBINT( Version );            
	WRITEGLOBINT( NntpTrace );
	WRITEGLOBINT( SmtpTrace );
	WRITEGLOBINT( ServTrace );
	WRITEGLOBINT( SocketLogging );
	WRITEGLOBSTR( LogPath );	          
	WRITEGLOBINT( AnimatedBitmaps );          
	WRITEGLOBSTR( FingerDefault );
	WRITEGLOBSTR( DefaultRecipient );	
	// and write the preferences
	WRITEPREFINT( StartupOption );
	WRITEPREFINT( ViewNews );
	WRITEPREFINT( ViewSmtp );
	WRITEPREFINT( ViewServ );
}

void CWindisSetup::LoadCurrentSet()
{                      
	const char * NulStr = "";

	READSTR( NewsServer , NulStr );
	READSTR( KA9QRoot , NulStr );
	READINT( DownloadGroups, 0 );
	READINT( DownloadGroupsDays, 7 );
	READINT( DownloadGroupsLastTime, 0);
	READINT( DownloadNewGroups, 1 ); 
	READINT( NewsKickSeconds, 600 );
	READINT( NewsBatchDepth,  12);

	READSTR( MailOutDir , NulStr );
	READSTR( MailInDir , NulStr );
	READSTR( MailGateway , NulStr );
	READINT( MailBatch , 1 );
	READSTR( MailBoxType , "KA9Q" );
	READINT( MailKickSeconds , 600 );
	READINT( MailSessions , 5 );
	                         
	READSTR( TimeServer , NulStr );
	READINT( TimeSetSystem , TRUE );
	READINT( TimeStartupKick , FALSE);
	READINT( TimeUseNews , TRUE );
	READSTR( TimeZone, "GMT0BST1" );
	
	READSTR( HostName , NulStr );
	READINT( SlipConnection , TRUE );
	READINT( ConnectOnStartup , TRUE );
	
	READINT( UnbatchOptions , UNBATCH_CROSSPOST_TO_JUNK | UNBATCH_REMOVE_BATCH );
	READINT( BackgroundUnbatch , 1 );
	READINT( UnbatchOnExit , 1 );
             
    READDIALSTR( DialString1, NulStr );
    READDIALSTR( DialString2, NulStr );
    READDIALSTR( DialString3, NulStr );
    READDIALSTR( DialString4, NulStr );
    READDIALSTR( DialString5, NulStr );
    READDIALSTR( DialString6, NulStr );
	READDIALINT( DialInt1 , 0 );
	READDIALINT( DialInt2 , 0 );
	READDIALINT( DialInt3 , 0 );    
    // When we load this setupset, we have to set the globals so
    // trumpet can find them
	WRITEDIALSTR( DialString1 );    
	WRITEDIALSTR( DialString2 );    
	WRITEDIALSTR( DialString3 );    
	WRITEDIALSTR( DialString4 );    
	WRITEDIALSTR( DialString5 );    
	WRITEDIALSTR( DialString6 );    
	WRITEDIALINT( DialInt1 );
	WRITEDIALINT( DialInt2 );
	WRITEDIALINT( DialInt3 );
}   


void CWindisSetup::WriteCurrentSet()
{

	WRITESTR( NewsServer );
	WRITESTR( KA9QRoot );
	WRITEINT( DownloadGroups );
	WRITEINT( DownloadGroupsDays );
	WRITEINT( DownloadGroupsLastTime );
	WRITEINT( DownloadNewGroups );                        
	WRITEINT( NewsKickSeconds );
	WRITEINT( NewsBatchDepth );

	WRITESTR( MailOutDir );       
	WRITESTR( MailInDir );
	WRITESTR( MailGateway );
	WRITEINT( MailBatch );
	WRITESTR( MailBoxType );
	WRITEINT( MailKickSeconds );
	WRITEINT( MailSessions );
	
	WRITESTR( TimeServer );
	WRITEINT( TimeSetSystem );
	WRITEINT( TimeStartupKick );
	WRITEINT( TimeUseNews );
	WRITESTR( TimeZone );
	
	WRITESTR( HostName );
	WRITEINT( SlipConnection );
	WRITEINT( ConnectOnStartup ); 
	
	WRITEINT( UnbatchOptions );      
	WRITEINT( BackgroundUnbatch );
	WRITEINT( UnbatchOnExit );

	// Also write out the dial strings for trumpet to find.
	WRITEDIALSTR( DialString1 );    
	WRITEDIALSTR( DialString2 );    
	WRITEDIALSTR( DialString3 );    
	WRITEDIALSTR( DialString4 );    
	WRITEDIALSTR( DialString5 );    
	WRITEDIALSTR( DialString6 );    
	WRITEDIALINT( DialInt1 );
	WRITEDIALINT( DialInt2 );
	WRITEDIALINT( DialInt3 );
}	


CString CWindisSetup::GetDefaultSetName()
{
	return SetToName( GetDefaultSet() );
}

CString CWindisSetup::SetToName( const char * Str )
{
	return AfxGetApp()->GetProfileString( StrSetupSets , Str , "" );
}


CString CWindisSetup::GetCurrentSetName()
{
	return SetToName( CurrentSet );
}

void CWindisSetup::SetCurrentSetName( const char * Str )
{
	WriteCurrentSet();
	CurrentSet = NameToSet( Str ); 
	LoadCurrentSet();
}

void CWindisSetup::SetDefaultSetName( const char * Str )
{
	DefaultSet = NameToSet( Str );                   
	WRITEGLOBSTR( DefaultSet );
}

BOOL CWindisSetup::CurrentIsDefault()
{
	if( DefaultSet == CurrentSet )
		return TRUE;
	else
		return FALSE;
}

void CWindisSetup::GetSetupSetNames( CStringArray &StrArray )
{
	for( int i = 0; i < MAX_SETUP_SETS ; i++ )
	{
		CString Ind = MakeIndex( i );
		CString Test = AfxGetApp()->GetProfileString( StrSetupSets , Ind , "" );
		if( Test != "" )
			StrArray.Add( Test );
	}
}

int CWindisSetup::FindSetIndex( const char * Name )
{                                                                            
	CString SetNoName = StrNoSetName;
	for( int i = 0 ; i < MAX_SETUP_SETS ; i++ )
	{                           
		CString Buffer = MakeIndex( i );
		CString Test = AfxGetApp()->GetProfileString( StrSetupSets , Buffer , StrNoSetName );
		if( Test == Name )
			return i; // Got it
		else
		{					
		if ( Test == SetNoName )
			return -1;
		}
	}
	return -1;
}

CString CWindisSetup::FindFreeIndex()
{                          
	CString SetNoName = StrNoSetName;
	for( int i = 0 ; i < MAX_SETUP_SETS ; i++ )
	{                           
		CString Buf = MakeIndex( i );
		CString Test = AfxGetApp()->GetProfileString( StrSetupSets , Buf , StrNoSetName );
		if( Test == "" || Test == SetNoName )
			return Buf; // Got it
	}
	return "";
}

void CWindisSetup::DeleteSetupSet( const char * Name )
{
	CString Set = NameToSet( Name );
	if( Set != "" )
	{             
		AfxGetApp()->WriteProfileString( StrSetupSets , Set, "" );
	}
}
        
CString CWindisSetup::MakeIndex( int i )
{
	char Buf[ 16 ];
	wsprintf( Buf , "Set%d" , i );
	return Buf;
}       

CString CWindisSetup::NameToSet(const char * Name)
{       
	for( int i = 0 ; i < MAX_SETUP_SETS ; i++ )
	{
		CString Set = MakeIndex( i );
		CString Test = AfxGetApp()->GetProfileString( StrSetupSets , Set , StrNoSetName );
		if( Test == Name )
			return Set;
	}
	return "";
}
				
void CWindisSetup::NewSetupSet( const char * From, const char * New )
{                
	CString SetFrom = NameToSet( From );
	CString SetNew = NameToSet( New );
	if ( SetNew == "" )
	{
		// This really is a new one
		SetNew = FindFreeIndex();             
		if ( SetNew == "" )
			return; // No space but the person's got 32 setups so fuck em.
	}                                                  
	// make the set entry
	AfxGetApp()->WriteProfileString( StrSetupSets , SetNew , New );
	WriteCurrentSet();
	CurrentSet = SetNew;
	WriteCurrentSet();
}

CString CWindisSetup::MakeFingerIndex( int i )
{
	char Buf[ 16 ];
	wsprintf( Buf , "Finger%d" , i );
	return Buf;            
}
		
void CWindisSetup::GetFingerNames( CStringArray &StrArray )
{
	for( int i = 0; i < MAX_FINGER_SETS ; i++ )
	{
		CString Ind = MakeFingerIndex( i );
		CString Test = AfxGetApp()->GetProfileString( StrFinger , Ind , FreeFingerStr );
		StrArray.Add( Test );
	}
}

void CWindisSetup::SetFingerNames( CStringArray &StrArray )
{
	for( int i = 0 ; i < MAX_FINGER_SETS ; i++ )	
	{
		CString Ind = MakeFingerIndex( i );                   
		CString Val = StrArray[ i ];
		AfxGetApp()->WriteProfileString( StrFinger , Ind , Val );
	}
}

// The Font stuff stolen from the superpad application
void CWindisSetup::GetFingerFont(LOGFONT* plf)
{
	CWinApp* pApp = AfxGetApp(); 
	LPCSTR		  szSec = StrFinger;
	plf->lfHeight = pApp->GetProfileInt(szSec, szHeight, 0);
	if (plf->lfHeight != 0)
	{
		plf->lfWeight = pApp->GetProfileInt(szSec, szWeight, 0);
		plf->lfItalic = (BYTE)pApp->GetProfileInt(szSec, szItalic, 0);
		plf->lfUnderline = (BYTE)pApp->GetProfileInt(szSec, szUnderline, 0);
		plf->lfPitchAndFamily = (BYTE)pApp->GetProfileInt(szSec, szPitchAndFamily, 0);
		CString strFont = pApp->GetProfileString(szSec, szFaceName, szSystem);
		strncpy((char*)plf->lfFaceName, strFont, sizeof plf->lfFaceName);
		plf->lfFaceName[sizeof plf->lfFaceName-1] = 0;
	}
}

void CWindisSetup::SetFingerFont( const LOGFONT* plf )
{
	CWinApp* pApp = AfxGetApp();
	LPCSTR		  szSec = StrFinger;

	pApp->WriteProfileInt(szSec, szHeight, plf->lfHeight);
	if (plf->lfHeight != 0)
	{
		pApp->WriteProfileInt(szSec, szHeight, plf->lfHeight);
		pApp->WriteProfileInt(szSec, szWeight, plf->lfWeight);
		pApp->WriteProfileInt(szSec, szItalic, plf->lfItalic);
		pApp->WriteProfileInt(szSec, szUnderline, plf->lfUnderline);
		pApp->WriteProfileInt(szSec, szPitchAndFamily, plf->lfPitchAndFamily);
		pApp->WriteProfileString(szSec, szFaceName, (LPCSTR)plf->lfFaceName);
	}
}

