/***********************************************************************
**
** CANIBMP.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
** It is the implementation of the CAnimatedBitmap class.
** This class responsible for animating itself in a particular
** location
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
// wunbatch.h : header file
//
#ifndef _WUNBATCH_H
#define _WUNBATCH_H
#ifndef _NEWSSUP_H
#include "newssup.h"
#endif

#ifndef _UTILITY_H
#include "utility.h"
#endif

/////////////////////////////////////////////////////////////////////////////
// CUnbatchDlg dialog

class CUnbatcher
{
// Construction
public:
	CUnbatcher();
    ~CUnbatcher();
    

public:
	BOOL Init();
	BOOL UnbatchOne();
private:
    // the execution of the unbatch
	BOOL DoError( const char * Str );
	AbortError( const int Num , const char * Str );
	LINES * ReadToToken( CString& subject , CString& msg_id , CString& newsgroups );
    LINES *PostToGroups( LINES * spool, CString& msg_id ,CString& newsgroups, CString& subject );
    void Filter(char *buf);         
    // Private variables
    CUnbatchSetupInfo * m_Setup;
	class CActiveList * m_ActiveList;
	class CHistoryList * m_HistoryList;
	CStdioFile * m_BatchFile; 
	CStatusDlg m_StatDlg;
};

/////////////////////////////////////////////////////////////////////////
// The Reindexer object (new paradigm)
// Reindexes the complete set of newsgroups.
class CReindexer 
{
  public:
  	CReindexer();
  	~CReindexer();
  	BOOL Init();
  	Reindex();
  private:
	CTime ExtractDate(const char *date_str,int zone_as_int);
	BOOL GetNext( CStdioFile& File , CString& Subject , CTime& WrittenTime, int ZoneAsInt );
  	BOOL ReindexGroup( CActive * Group );
 	// Variables
  	CActiveList * m_ActiveList;
  	CStatusDlg m_StatDlg;
  	CString m_Dir;
};

//////////////////////////////////////////////////////////////////////////
// CGroupSorter.  An object to take the current group list, and the
// newgroup list if it exists and sort the two.  Useful since the
// list downloaded from the LIST command isn't sorted.
class CGroupSorter
{
  public:
  	CGroupSorter();
  	~CGroupSorter();
  	BOOL Init();
  	
  	BOOL SortGroups();
  private:
  	CActiveList * m_ActiveList;
  	CStatusDlg m_StatDlg;
  	// This has to be fast so we use direct memory and no
  	// use of the string classes.
  	// NB, if you get more than 16000 newsgroups. you're going
  	// to get screwed. Although, we might manage 32000
  	// if we're really lucky (by using some wierd memory
  	// management features.
  	HGLOBAL m_GlobalHandle;
  	char ** m_StringArray;                 
  	char * m_LineBuffer;
};
  	
#endif                                           
