{------------------------------------------------}
{     Yet Another Wallpaper Changer V1.0         }
{                                                }
{          (C) 1993  Brad Trupp                  }
{                                                }
{        E-mail: Compuserve 74670,1572           }
{                                                }
{ This program may be freely modified for        }
{ personal and educational purposes. Only the    }
{ unmodified version may be distributed as a     }
{ part of the YAWC 1.0 package.                  }
{                                                }
{                                                }
{ Standard disclaimer (just in case...)          }
{                                                }
{ This software claims no warranty, implied or   }
{ otherwise. This software is provided "AS IS".  }
{ The author claims no responsibility for any    }
{ damages that might be caused by the use or     }
{ abuse of this software.                        }
{                                                }
{------------------------------------------------}

program yawc;
{$X+}         {Turn on extended syntax           }
{$R yawc.RES} {Here's where I hide my icon and   }
              {about dialog. Use the resource    }
              {compiler to extract these from the}
              {yawc.exe program executable file. }

uses WObjects, WinTypes, WinProcs, Strings, WinDos;

{------------------------------------------------}
{  Define global constants and variables         }
{------------------------------------------------}
const
  id_Timer1 = 111;
  id_ST0 = 100;
  id_ST1 = 101;
  id_ST2 = 102;
  id_about = 109;
var
  AStat0, AStat,AStat2 : PStatic;
  Bt1: PButton;
  isAbout: Boolean;
{------------------------------------------------}
{ Define objects and methods                     }
{------------------------------------------------}
type
  YAWCApp = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

  YAWCWindow = ^TYAWCWindow;
  TYAWCWindow = object(TWindow)
    constructor Init(ATitle : PChar);
    procedure SetupWindow ; virtual;
    function GetClassName : PChar; virtual;
    procedure GetWindowClass(var AWndClass : TWndClass); virtual;
    procedure WMTimer(var Msg: TMessage); virtual wm_First + wm_Timer;
    procedure ChangeWallPaper;
    procedure IDAbout(var Msg: TMessage); Virtual id_First + id_about;
    destructor Done; virtual;
  end;

  PAboutDialog = ^TAboutDialog;
  TAboutDialog = object(TDialog)
  end;



{--TYAWCWindow.Init------------------------------}
{  Init the window and set up window style       }
{------------------------------------------------}
constructor TYAWCWindow.Init(ATitle : PChar);
begin
  TWindow.Init(Nil, ATitle);
  with Attr do
    begin
      Style := ws_DlgFrame;
      Menu := 0;
    end;
{ if (ParamCount > 0) then begin
    if (ParamStr(1) = 'minimize') then begin
      with Attr do
      begin
        Style := ws_Minimize;
        Menu := 0;
      end;
    end;
  end; }

  isAbout := FALSE;
  Bt1 := New(PButton, Init(@Self, id_about, 'About',
    50, 80, 275, 24, False));
  ChangeWallPaper;
end;

{--TYAWCWindow.SetupWindow-----------------------}
{  Size the window to 375 x 80 and display it    }
{  for six seconds only.                         }
{------------------------------------------------}
procedure TYAWCWindow.SetupWindow;
var
  R: TRect;
begin
  TWindow.SetupWindow;
  SetRect(R,0,0,375,106);
  AdjustWindowRect(R,Attr.Style,TRUE);
  SetWindowPos(HWindow,0,0,0,R.Right-R.Left,
      R.Bottom-R.Top, swp_nomove OR swp_nozorder);
  SetTimer(hWindow, id_Timer1, 6000, nil);
end;

{--TYAWCWindow.GetClassName----------------------}
{  Override method to return my appname instead  }
{  of default 'TurboWindow' class name.          }
{------------------------------------------------}
function TYAWCWindow.GetClassName : PChar;
begin
  GetClassName := 'YAWC';
end;

{--TYAWCWindow.GetWindowClass--------------------}
{  Get a Window class record (from AWndClass)    }
{  with default values for it's registration     }
{  attributes. Change window to use my icon.     }
{------------------------------------------------}
procedure TYAWCWindow.GetWindowClass(var AWndClass : TWndClass);
begin
TWindow.GetWindowClass(AWndClass);
with AWndClass do
  begin
  hCursor := LoadCursor(0, PChar(idc_Arrow));
  hIcon := LoadIcon(hInstance, 'YAWC');
  Style := cs_Vredraw or cs_Hredraw;
  end;
end;

{-----------------------------------------------}
{  Once the six seconds is over from setupwindow}
{  then end the application.                    }
{-----------------------------------------------}
procedure TYAWCWindow.WMTimer(var Msg: TMessage);
Begin
  if (Msg.wparam = id_Timer1) and (IsAbout = FALSE) then begin
     KillTimer(hWindow, id_Timer1);
     TWindow.CloseWindow;
   end;
End;


{------TYAWCWindow.ChangeWallPaper---------------}
{  Do as advertised...change the wallpaper...    }
{------------------------------------------------}
procedure TYAWCWindow.ChangeWallpaper;
var
  WinDir, CurrentBmp, MyMessage: array[0..144] of char;
  Attributes, Temp: word;
  SearchRec : TSearchRec;
  NumBmp : Integer;
begin
{--find out the current wallpaper-----------------}
  GetProfileString('desktop','wallpaper','',CurrentBmp,144);
{--find all the *.bmp in the Windows Directory----}
  GetWindowsDirectory(WinDir,144);
  Strcat(WinDir,'\*.bmp');
  Attributes := faReadOnly + faDirectory + faArchive;
  FindFirst(WinDir, Attributes, SearchRec);
  NumBmp := 0;
  while DosError = 0 do
    begin
      Inc(NumBmp);
      FindNext(SearchRec);
    end;
{--handle no *.bmp files-------------------------}
  if NumBmp = 0 then begin
    Strcopy(MyMessage,
      'Sorry! I could not find any wallpaper files in your ');
    StrCat(MyMessage,WinDir);
    MyMessage[ (Strlen(MyMessage) - 6) ] := #0; { lose the "\*.bmp" }
    StrCat(MyMessage,' directory.');
    end;
{--handle one *.bmp file-------------------------}
  if NumBmp = 1 then begin
    Strcopy(MyMessage,'Did you know you only have one wallpaper file in ');
    StrCat(MyMessage,WinDir);
    MyMessage[ (Strlen(MyMessage) - 6) ] := #0; { lose the "\*.bmp" }
    StrCat(MyMessage,'? So ');
    StrCat(MyMessage,CurrentBmp);
    Strcat(MyMessage,' will just have to stay.');
    end;
{--pick a *.bmp file at random and change the----}
{--desktop wallpaper entry in win.ini------------}
  if NumBmp > 1 then
    begin
      Randomize; Temp := Random(NumBmp);
      FindFirst(WinDir, Attributes, SearchRec);
      for NumBmp := 1 to Temp do FindNext(SearchRec);
      WriteProfileString('desktop','TileWallPaper','1');
      WriteProfileString('desktop','wallpaper',SearchRec.Name);
      StrCopy(MyMessage,'The new Wallpaper selected is ');
      StrCat(MyMessage,SearchRec.Name);
      MyMessage[ (Strlen(MyMessage) - 4) ] := #0; { lose the ".bmp" }
      StrCat(MyMessage,'.');
    end;
{--display a message on the windows desktop------}
{ AStat0 := New(PStatic, Init(@Self, id_ST0, 'YAWC', 2, 20, 32, 32, 0)); }
{ AStat0^.Attr.Style :=  AStat0^.Attr.Style and not SS_ICON; }

  AStat := New(PStatic, Init(@Self, id_ST1, MyMessage, 20, 20, 335, 60, 0));
  AStat^.Attr.Style := AStat^.Attr.Style and not SS_LEFT or SS_CENTER;

{ AStat2 := New(PStatic, Init(@Self, id_ST2,'(c) Brad Trupp 1993',
     20, 106, 335, 20, 0));
  AStat2^.Attr.Style := AStat2^.Attr.Style and not SS_LEFT or SS_CENTER; }


end;


{--TYAWCWindow.Done------------------------------}
{  Use Twindow.Done method to destroy TYAWCWindow}
{------------------------------------------------}
destructor TYAWCWindow.Done;
begin
  TWindow.Done;
end;

{--------------------------------------------------}
{                                                  }
{--------------------------------------------------}
procedure TYAWCWindow.IDAbout(VAR Msg : TMessage);
BEGIN
  IsAbout := TRUE;
  Application^.ExecDialog(New(PAboutDialog,
                            Init(@Self, 'YAWCAbout')));
  IsAbout := FALSE;
END;


{--YAWCApp.InitMainWindow------------------------}
{  MyApp opens up the YAWCWindow object.         }
{------------------------------------------------}

procedure YAWCApp.InitMainWindow;
begin
  MainWindow := New(YAWCWindow, Init('Yet Another WallPaper Changer'));
end;

{-----------------------------------------------}
{  The main procedure for YAWC.                 }
{-----------------------------------------------}
var
  App : YAWCApp;
begin
  App.Init('YAWCWindow');
  App.Run;
  App.Done;
end.
