/*
  C source for Winsock Chess
  
  Revision 1994-03-15
  Modified by Donald Munro for use as a 2 player chess game over a 
  WINSOCK layer on a TCP (or other WinSock supporting) network.
  Source code and make files for MS Visual C/C++ V1.00/1.50.
  February/March 1994
  All GNU copyright and distribution conditions as described below and in the
  file COPYING also apply to WinSock Chess.
  This module is adapted from GNU Chess. 
  
  
  C source for GNU CHESS

  Revision: 1990-09-30

  Modified by Daryl Baker for use in MS WINDOWS environment

  This file is part of CHESS.

  Modified by Donald Munro for use as a 2 player chess game over a 
  communications link viz WINSOCK or other.
  Source code and make files for MS Visual C++ V1.00/1.50
  Conversion to usage of message crackers for easy conversion to win32
  February/March 1994

  CHESS is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY.  No author or distributor accepts responsibility to anyone for
  the consequences of using it or for whether it serves any particular
  purpose or works at all, unless he says so in writing.  Refer to the CHESS
  General Public License for full details.

  Everyone is granted permission to copy, modify and redistribute CHESS, but
  only under the conditions described in the CHESS General Public License.
  A copy of this license is supposed to have been given to you along with
  CHESS so you can know your rights and responsibilities.  It should be in a
  file named COPYING.  Among other things, the copyright notice and this
  notice must be preserved on all copies.
*/

#define NOATOM 
#define NOCLIPBOARD
#define NOCREATESTRUCT
#define NOFONT
#define NOREGION
#define NOSOUND
#define NOWH
#define NOCOMM
#define NOKANJI

#include <windows.h>

extern char szAppName[];

LRESULT CALLBACK ChessWndProc(HWND hWnd, UINT message,
                             WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK StatusBarProc(HWND,UINT,WPARAM,LPARAM);                             

extern DWORD clrBackGround;
extern DWORD clrBlackSquare;
extern DWORD clrWhiteSquare;
extern DWORD clrBlackPiece;
extern DWORD clrWhitePiece;

BOOL FAR ChessInit(HANDLE hInstance)
{
    HANDLE hMemory;                /* handle to allocated memory */
    PWNDCLASS pWndClass;               /* structure pointer      */
    BOOL bSuccess;                 /* RegisterClass() result     */
    WNDCLASS wc;
    HBRUSH hbrushLGrey = CreateSolidBrush(RGB(0XC0,0XC0,0XC0));;
 
    hMemory = LocalAlloc(LHND, sizeof(WNDCLASS));
    pWndClass = (PWNDCLASS) LocalLock(hMemory);

    pWndClass->style = NULL;
    pWndClass->lpfnWndProc = ChessWndProc;
    pWndClass->hInstance = hInstance;
    pWndClass->hIcon = LoadIcon(hInstance, szAppName);
    pWndClass->hCursor = LoadCursor(NULL, IDC_ARROW);
    pWndClass->hbrBackground = GetStockObject(WHITE_BRUSH);
    pWndClass->lpszMenuName = (LPSTR) szAppName;
    pWndClass->lpszClassName = (LPSTR) szAppName;

    bSuccess = RegisterClass(pWndClass);
    
  wc.style         = CS_HREDRAW | CS_VREDRAW;
  wc.lpfnWndProc   = StatusBarProc;
  wc.cbClsExtra    = 0;
  wc.cbWndExtra    = 0;  
  wc.hInstance     = hInstance;
  wc.hIcon         = NULL;
  wc.hCursor       = LoadCursor(NULL,IDC_ARROW);
  wc.hbrBackground = hbrushLGrey;
  wc.lpszMenuName  = NULL;
  wc.lpszClassName = "STATBR";
  bSuccess = bSuccess & RegisterClass(&wc);

    LocalUnlock(hMemory);            
    LocalFree(hMemory);             

    return (bSuccess);   
}


