/*
  C source for Winsock Chess
  
  Revision 1994-03-15
  Modified by Donald Munro for use as a 2 player chess game over a 
  WINSOCK layer on a TCP (or other WinSock supporting) network.
  Source code and make files for MS Visual C/C++ V1.00/1.50.
  February/March 1994
  All GNU copyright and distribution conditions as described below and in the
  file COPYING also apply to WinSock Chess.

  C source for GNU CHESS

  Revision: 1990-09-30

  Modified by Daryl Baker for use in MS WINDOWS environment

  Copyright (C) 1986, 1987, 1988, 1989, 1990 Free Software Foundation, Inc.
  Copyright (c) 1988, 1989, 1990  John Stanback

  This file is part of CHESS.

  CHESS is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY.  No author or distributor accepts responsibility to anyone for
  the consequences of using it or for whether it serves any particular
  purpose or works at all, unless he says so in writing.  Refer to the CHESS
  General Public License for full details.

  Everyone is granted permission to copy, modify and redistribute CHESS, but
  only under the conditions described in the CHESS General Public License.
  A copy of this license is supposed to have been given to you along with
  CHESS so you can know your rights and responsibilities.  It should be in a
  file named COPYING.  Among other things, the copyright notice and this
  notice must be preserved on all copies.
*/


#define STRICT 
#include <windows.h>         
#include <windowsx.h>
#include <commdlg.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <ddeml.h>

#include "winsock.h"
#include "gnuchess.h"
#include "defs.h"
#include "chess.h"
#include "saveopen.h"
#include "color.h"
#include "resource.h"

extern DWORD clrBackGround;
extern DWORD clrBlackSquare;
extern DWORD clrWhiteSquare;
extern DWORD clrBlackPiece;
extern DWORD clrWhitePiece;
extern DWORD clrText;


static char np08lX[] = "%08lX";

void SaveColors (void)
//--------------------
{  char ostring[30];

   wsprintf ( ostring, np08lX, clrBackGround);
   WritePrivateProfileString ( "Colors", "BackGround",ostring,"wschess.ini");

   wsprintf ( ostring, np08lX, clrBlackSquare);
   WritePrivateProfileString ( "Colors", "BlackSquare",ostring,"wschess.ini");
   
   wsprintf ( ostring, np08lX, clrWhiteSquare);
   WritePrivateProfileString ( "Colors", "WhiteSquare",ostring,"wschess.ini");
   
   wsprintf ( ostring, np08lX, clrBlackPiece);
   WritePrivateProfileString ( "Colors", "BlackPiece",ostring,"wschess.ini");
   
   wsprintf ( ostring, np08lX, clrWhitePiece);
   WritePrivateProfileString ( "Colors", "WhitePiece",ostring,"wschess.ini");

   wsprintf ( ostring, np08lX, clrText);
   WritePrivateProfileString ( "Colors", "Text",ostring,"wschess.ini");
}

void GetStartupColors (void)
//--------------------------
{
   char istring[30];

   SetStandardColors ();

   GetPrivateProfileString ( "Colors", "BackGround","Default",istring,
                             sizeof(istring), "wschess.ini");
   if (lstrcmp ( istring, "Default") != 0)  sscanf ( istring, np08lX, &clrBackGround);

   GetPrivateProfileString ( "Colors", "BlackSquare","Default",istring,
                             sizeof(istring), "wschess.ini");
   if (lstrcmp ( istring, "Default") != 0)  sscanf ( istring, np08lX, &clrBlackSquare);

   GetPrivateProfileString ( "Colors", "WhiteSquare","Default",istring,
                             sizeof(istring), "wschess.ini");
   if (lstrcmp ( istring, "Default") != 0)  sscanf ( istring, np08lX, &clrWhiteSquare);

   GetPrivateProfileString ( "Colors", "BlackPiece","Default",istring,
                             sizeof(istring), "wschess.ini");
   if (lstrcmp ( istring, "Default") != 0)  sscanf ( istring, np08lX, &clrBlackPiece);

   GetPrivateProfileString ( "Colors", "WhitePiece","Default",istring,
                             sizeof(istring), "wschess.ini");
   if (lstrcmp ( istring, "Default") != 0)  sscanf ( istring, np08lX, &clrWhitePiece);

   GetPrivateProfileString ( "Colors", "Text","Default",istring,
                             sizeof(istring), "wschess.ini");
   if (lstrcmp ( istring, "Default") != 0)  sscanf ( istring, np08lX, &clrText);
}

void SaveHosts(HWND hdlg,char *szNewHost)
//---------------------------------------
{ WORD i,wNoHosts;
  char szEntry[20];
  PSTR psz;
  DWORD dwEntryLen;
  BOOL bInsert=TRUE;

  WritePrivateProfileString("Hosts",NULL,NULL,"wschess.ini");
  wNoHosts = (WORD)SendDlgItemMessage(hdlg,IDC_COMBO1,CB_GETCOUNT,0,0L);
  _itoa(wNoHosts,szEntry,10);                            
  WritePrivateProfileString("Hosts","No",szEntry,"wschess.ini");  
  for (i=0; i<wNoHosts; i++)
   { dwEntryLen = SendDlgItemMessage(hdlg,IDC_COMBO1,CB_GETLBTEXTLEN,(WPARAM)i,
                                     (LPARAM)((LPCSTR)szEntry));
     if (dwEntryLen != CB_ERR)
       { psz = (PSTR)LocalAlloc(LMEM_FIXED,(WORD)dwEntryLen);
         if (psz != NULL)                                
           { SendDlgItemMessage(hdlg,IDC_COMBO1,CB_GETLBTEXT,(WPARAM)i,
                                (LPARAM)((LPCSTR)psz));
             wsprintf((LPSTR)szEntry,"host%d",i);
             WritePrivateProfileString("Hosts",szEntry,psz,"wschess.ini");
             if (lstrcmpi(szNewHost,psz) == 0)
               bInsert = FALSE;
             LocalFree(psz);
           }
       }      
   }
  if (bInsert) 
    { SendDlgItemMessage(hdlg,IDC_COMBO1,CB_INSERTSTRING,-1,
                         (LPARAM)((LPCSTR)szNewHost));            
      wsprintf((LPSTR)szEntry,"host%d",i);                   
      WritePrivateProfileString("Hosts",szEntry,szNewHost,"wschess.ini");
      _itoa(++wNoHosts,szEntry,10);
      WritePrivateProfileString("Hosts","No",szEntry,"wschess.ini");  
    }  
}   

void GetHosts(HWND hdlg)
//----------------------
{ char szEntry[30],szHost[80];
  int i,no;

  no = GetPrivateProfileInt("Hosts","No",0,"wschess.ini");
  for (i=0; i<no; i++)
   { wsprintf((LPSTR)szEntry,"host%d",i);
     GetPrivateProfileString("Hosts",szEntry,"NOT DEFINED HERE",
                              szHost,80,"wschess.ini");
     if (lstrcmp(szHost,"NOT DEFINED HERE") == 0) continue;   
     SendDlgItemMessage(hdlg,IDC_COMBO1,CB_INSERTSTRING,i,
                        (LPARAM)((LPCSTR)szHost));
   } 
}  
