/*
  C source for Winsock Chess
  
  Revision 1994-03-15
  Modified by Donald Munro for use as a 2 player chess game over a 
  WINSOCK layer on a TCP (or other WinSock supporting) network.
  Source code and make files for MS Visual C/C++ V1.00/1.50.
  February/March 1994
  All GNU copyright and distribution conditions as described below and in the
  file COPYING also apply to WinSock Chess.
  This module is adapted from GNU Chess.

  C source for GNU CHESS

  Revision: 1990-09-30

  Modified by Daryl Baker for use in MS WINDOWS environment

  Based on Ideas and code segments of Charles Petzold from artices in
  MicroSoft Systems Journal.

  This file is part of CHESS.

  CHESS is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY.  No author or distributor accepts responsibility to anyone for
  the consequences of using it or for whether it serves any particular
  purpose or works at all, unless he says so in writing.  Refer to the CHESS
  General Public License for full details.

  Everyone is granted permission to copy, modify and redistribute CHESS, but
  only under the conditions described in the CHESS General Public License.
  A copy of this license is supposed to have been given to you along with
  CHESS so you can know your rights and responsibilities.  It should be in a
  file named COPYING.  Among other things, the copyright notice and this
  notice must be preserved on all copies.
*/

#define NOATOM 
#define NOCLIPBOARD
#define NOCREATESTRUCT
#define NOFONT
#define NOREGION
#define NOSOUND
#define NOWH
#define NOWINOFFSETS
#define NOCOMM
#define NOKANJI

#define STRICT
#include <windows.h>
#include <commdlg.h>
#include <string.h>
#include <stdio.h>

#include "chess.h"
#include "color.h"

#define CBLACK     RGB(0,0,0)
#define BLUE      RGB(0,0,255)
#define GREEN     RGB(0,255,0)
#define CYAN      RGB(128,255,255)
#define RED       RGB(255,0,0)
#define PINK      RGB(255,0,255)
#define YELLOW    RGB(255,255,0)
#define PALEGRAY  RGB(192,192,192)
#define DARKGRAY  RGB(127,127,127)
#define DARKBLUE  RGB(0,0,128)
#define DARKGREEN RGB(0,128,0)
#define DARKCYAN  RGB(0,255,255)
#define DARKRED   RGB(128,0,0)
#define DARKPINK  RGB(255,0,128)
#define BROWN     RGB(128,128,64)
#define CWHITE     RGB(255,255,255)

extern DWORD clrBackGround;
extern DWORD clrBlackSquare;
extern DWORD clrWhiteSquare;
extern DWORD clrBlackPiece;
extern DWORD clrWhitePiece;
extern DWORD clrText;

void SetStandardColors (void)
{
   clrBackGround =  BROWN;
   clrBlackSquare = DARKGREEN;
   clrWhiteSquare = PALEGRAY;
   clrBlackPiece  = RED;
   clrWhitePiece  = CWHITE;
   clrText        = CBLACK;
}

BOOL ColorDialog ( HWND hWnd, int id )
//-------------------------------------
{ CHOOSECOLOR choosecolor;
  DWORD dwCustClrs[16] = { CBLACK,BLUE,GREEN,CYAN,RED,PINK,YELLOW,PALEGRAY,
                           DARKGRAY,DARKBLUE,DARKGREEN,DARKCYAN,DARKRED,
                           DARKPINK,BROWN,CWHITE };
  BOOL bStatus;                         
 
 choosecolor.lStructSize    = sizeof(CHOOSECOLOR);
 choosecolor.hwndOwner      = hWnd;
 choosecolor.hInstance      = NULL;
 choosecolor.rgbResult      = 0L;
 choosecolor.lpCustColors   = (LPDWORD)dwCustClrs;
 choosecolor.Flags          = CC_FULLOPEN;
 choosecolor.lCustData      = 0L;
 choosecolor.lpfnHook       = (FARPROC)NULL;
 choosecolor.lpTemplateName = (LPSTR)NULL;
 
 if ( (bStatus = ChooseColor(&choosecolor)) )
   { switch (id)
      { case IDM_BACKGROUND:
          clrBackGround  = choosecolor.rgbResult;
          break;

        case IDM_BLACKSQUARE:
          clrBlackSquare = choosecolor.rgbResult;
          break;

        case IDM_WHITESQUARE:
          clrWhiteSquare = choosecolor.rgbResult;
          break;

        case IDM_BLACKPIECE:
          clrBlackPiece  = choosecolor.rgbResult;
          break;

        case IDM_WHITEPIECE:
          clrWhitePiece  = choosecolor.rgbResult;
          break;

        case IDM_TEXT:
          clrText        = choosecolor.rgbResult;
          break; 
      }    
   }
 return bStatus;  
}

