/*
  C source for Winsock Chess
  
  Revision 1994-03-15
  Modified by Donald Munro for use as a 2 player chess game over a 
  WINSOCK layer on a TCP (or other WinSock supporting) network.
  Source code and make files for MS Visual C/C++ V1.00/1.50.
  February/March 1994
  All GNU copyright and distribution conditions as described below and in the
  file COPYING also apply to WinSock Chess.
  This module is adapted from GNU Chess.

  C source for GNU CHESS

  Revision: 1990-09-30

  Modified by Daryl Baker for use in MS WINDOWS environment

  This file is part of CHESS.

  CHESS is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY.  No author or distributor accepts responsibility to anyone for
  the consequences of using it or for whether it serves any particular
  purpose or works at all, unless he says so in writing.  Refer to the CHESS
  General Public License for full details.

  Everyone is granted permission to copy, modify and redistribute CHESS, but
  only under the conditions described in the CHESS General Public License.
  A copy of this license is supposed to have been given to you along with
  CHESS so you can know your rights and responsibilities.  It should be in a
  file named COPYING.  Among other things, the copyright notice and this
  notice must be preserved on all copies.
*/

#define NOATOM 
#define NOCLIPBOARD
#define NOCREATESTRUCT
#define NOFONT
#define NOREGION
#define NOSOUND
#define NOWH
#define NOWINOFFSETS
#define NOCOMM
#define NOKANJI

#include <windows.h>
#include "gnuchess.h"
#include "defs.h"
#include "chess.h"

extern char mvstr[4][6];

BOOL FAR PASCAL ReviewDlgProc ( HWND hDlg, unsigned message,
                               WORD wParam, LONG lParam);


int ReviewDialog ( HWND hWnd, HANDLE hInst)
{
   FARPROC lpProcReview;
   int status;

   lpProcReview = MakeProcInstance(ReviewDlgProc, hInst);
    status = DialogBoxParam (hInst, MAKEINTRESOURCE(REVIEW),   hWnd,  lpProcReview, 0);
   FreeProcInstance(lpProcReview);
   return status;
}

BOOL FAR PASCAL ReviewDlgProc ( HWND hDlg, unsigned message,
                               WORD wParam, LONG lParam)
{

   int i,f,t;
   char tmp[50];

   switch (message) {
       case WM_INITDIALOG:         /* message: initialize dialog box */

        for (i = 1; i <= GameCnt; i++) {
            f = GameList[i].gmove >> 8;
            t = (GameList[i].gmove & 0xFF);
            algbr (f, t, false);
            wsprintf (tmp, "%4d\t\t%5s\t\t",
               (i+1)/2, 
               (char far *)mvstr[0]);
             i++;
             if ( i > GameCnt) 
               { SendDlgItemMessage (hDlg, 100, LB_ADDSTRING, 0, 
                                     (LPARAM) ((char FAR *)tmp));
                 break;  
               }  
             f = GameList[i].gmove >> 8;
             t = (GameList[i].gmove & 0xFF);  
             algbr (f, t, false);
             lstrcat(tmp,mvstr[0]);
             SendDlgItemMessage (hDlg, 100, LB_ADDSTRING, 0, 
                                 (LPARAM) ((char FAR *)tmp));
         }
         SendDlgItemMessage (hDlg, 100, WM_SETREDRAW, TRUE, 0);
         return (TRUE);

      case WM_SYSCOMMAND:
         if ( (wParam&0xfff0) == SC_CLOSE ) {
              EndDialog(hDlg, NULL);
              return TRUE;
         }
         break;


       case WM_COMMAND:           /* message: received a command */
         switch (wParam) {
         
            case IDOK:
                 EndDialog(hDlg, 1);
                 return TRUE;
               break;

         }
          break;
    }

    return (FALSE);               /* Didn't process a message    */
}


