* -> PROGRAM NAME     DBINDENT.PRG
* -> PURPOSE          INDENT CERTAIN COMMANDS FOR READABILITY, DEBUGGING, ETC
* -> WRITTEN BY       R. S. (BOB) VAN GORDER, COMPUSERVE ID 73230, 2136
* -> FILES USED       DBINDENT.PRG (THIS PROGRAM), DBINDENT.DBF
*
* THE FILE DBINDENT.DBF CONSISTS OF ONE FIELD NAMED 'ENT'.  ENT IS A CHARACTER
* TYPE FIELD WHICH MAY BE SET TO WHATEVER LENGTH YOU FEEL APPROPRIATE; KEEPING
* UNIDENTED LINES TO 78 CHARACTERS OR LESS AND USING A FIELD LENGTH OF 120 TO
* ALLOW FOR DEEPLY INDENTED SITUATIONS SEEMS TO WORK QUITE WELL
*
* BEFORE USING THIS PROGRAM, 'APPEND' THE TEXT TO BE INDENTED INTO
* DBINDENT WITH THE COMMAND
*
*           APPEND FROM [PATH] [FILENAME + EXTENSION] SDF
*
* THE 'SDF' FILE TYPE MUST BE USED TO READ IN ASCII FILES (.PRG FILES CREATED
* WITH THE NATIVE DBASE EDITOR AND MOST LINE EDITORS ARE ASCII FILES)
*
* AFTER RUNNING THE PROGRAM, WRITE THE INDENTED FILE TEXT WITH THE COMAND
*
*          COPY TO [PATH] [FILENAME + EXTENSTION] DELI WITH BLANK
*
* 'DELI WITH BLANK' IS NECESSARY TO WRITE THE INDENTED FILE AS AN ASCII FILE
*
* -> INITIALIZE ENVIRONMENT
SET STEP OFF
SET ECHO OFF
SET TALK OFF
SET COLOR TO W+/B
CLEA
SET DEVI TO SCREEN
SET FILT TO
SET DELE ON
SET EXAC OFF
*
* -> ESTABLISH / INITIALIZE VALUES
*
* -> ESTABLISH A STRING WORKING VALUE AND
WV = ''
* -> A 'KEYWORD' SEARCH STRING
KS = ''
* -> CREATE A NUMERIC INDENTATION / SPACING VALUE
INDEN = 0
* -> SET UP A LONG LINE (STATEMENT CONTINUATION) INDICATOR,
CON = .F.
* -> A PROCEDURE (SUBROUTINE/SUBPROGRAM) INDICATOR,
PON = .F.
* -> TEXT...ENDTEXT INDICATOR, AND
TON = .F.
* -> A 'TEMPORARY UN-INDENT' INDICATOR (ELSE, OTHERWISE, CASE, PARAMETERS, ETC)
UNINDE = .F.
*
* -> BEGIN PROCEDURE OPERATIONS
*
USE DBINDENT
DO WHILE .NOT. EOF()
*
* -> GET A WORKING VALUE FOR THE ENTRY / LINE
*
WV = UPPER(LTRIM(RTRIM(ENT))) + ' '
*
* -> REMOVE ANY COMMAND LINE COMMENTS
* -> IF YOU WISH TO RETAIN COMMAND LINE COMMENTS, REPLACE 'WV' IN REPLACE
*    COMMANDS IN THIS PROGRAM WITH 'UPPER(LTRIM(RTRIM(ENT)))'
*
IF ("&"+"&") $ WV
  WV = RTRIM(LEFT(WV, AT(("&"+"&"),WV))) + ' '
ENDIF
*
* -> EXTRACT THE LEFTMOST COMMAND WORD FOR 'KEYWORD' SEARCHES
*
KS = LEFT(WV, AT(' ', WV))
*
* -> CHECK FOR TEXT...ENDTEXT SITUATIONS
*
IF TON .AND. (KS = 'ENDT ' .OR. KS = 'ENDTEXT ')
  TON = .F.
  REPL ENT WITH 'ENDTEXT'
  SKIP
  LOOP
ENDIF
IF .NOT. TON .AND. KS = 'TEXT '
  TON = .T.
  REPL ENT WITH 'TEXT'
ENDIF
IF TON
  SKIP
  LOOP
ENDIF
*
* -> DELETE EMPTY LINES OUTSIDE TEXT...ENDTEXT SITUATIONS
*
IF LEN(KS) = 1
  DELE
  SKIP
  LOOP
ENDIF
*
* -> CHECK FOR 'TEMPORARY UNINDENTS'
*
IF KS = 'CASE '
  INDEN = INDEN - 2
  UNINDE = .T.
ENDIF
IF KS  = 'OTHERWISE ' .OR. KS  = 'OTHE '
  INDEN = INDEN - 2
  UNINDE = .T.
ENDIF
IF KS = 'ELSE '
  INDEN = INDEN - 2
  UNINDE = .T.
ENDIF
IF PON .AND. (KS = 'PARAMETERS ' .OR. KS = 'PARA ')
  INDEN = INDEN - 2
  UNINDE = .T.
ENDIF
*
* -> CHECK FOR ENDINGS OF INDENT SITUATIONS
*
IF KS = 'ENDCASE ' .OR. KS = 'ENDC '
  INDEN = INDEN - 4
ENDIF
IF KS = 'ENDDO ' .OR. KS = 'ENDD '
  INDEN = INDEN - 2
ENDIF
IF KS = 'ENDIF ' .OR. KS = 'ENDI '
  INDEN = INDEN - 2
ENDIF
*
* -> YOU MAY WISH TO DELETE THIS SECTION AND ARBITRARILY SET THE INDENTATION
*    VALUE TO 0 AT THE START OF A PROCEDURE (SUBROUTINE) IN THE DE-INDENTING
*    'IF PON' LINE FURTHER ON, ESPECIALLY IF YOU USE 'RETURN' IN CONDITION
*    CHECKS WITHIN SUBROUTINES; AVOIDING SUCH USE OF RETURN COMMANDS ANYPLACE
*    OTHER THAN AT THE END OF SUBPROGRAMS CAN BE ACCOMPLISHED THROUGH THE USE
*    OF DO...ENDDO LOOPS AND USING EXIT VERSUS RETURN WHEN CHECKING FOR ANY
*    TERMINATING (RETURN) CONDITIONS
*
IF PON .AND. (KS = 'RETURN ' .OR. KS = 'RETU ')
  INDEN = INDEN - 2
  PON = .F.
ENDIF
*
* -> INSURE INDENY VALUE IS >= 0 (MIGHT BE < 0 FOR UNBALANCED IF...ENDIF, ETC)
*
IF INDEN < 0
  INDEN = 0
ENDIF
*
* -> REPLACE ENTRY WITH INDENTED LINE
*
REPL ENT WITH SPACE(INDEN) + WV
*
* -> REVERSE 'TEMPORARY UNIDENT' SITUATIONS AFTER WRITING THE INDENTED LINE
*
IF UNINDE
  INDEN = INDEN + 2
  UNINDE = .F.
ENDIF
*
* -> MAKE ADJUSTMENTS FOR SPECIAL SITUATIONS
*
* -> COMMENT LINES - SELECT AN IF STATEMENT BELOW OR DELETE THIS SECTION
* -> THE FIRST IF STATEMENT MOVES ALL COMMENT LINES TO THE LEFT MARGIN WHILE
*    THE SECOND LEAVE COMMENT LINES INDENTED EXCEPT WHEN SERVING AS A
*    'SEPARATOR LINE'
*
*  IF LEFT(KS, 1) = '*'
IF LEN(LTRIM(RTRIM(ENT))) = 1 .AND. LTRIM(RTRIM(ENT)) = '*'
  REPL ENT WITH WV
ENDIF
*
* -> IF YOU SO DESIRE, DELETE ALL COMMENT LINES WITH THIS SECTION
*
*  IF LEFT(KS,1) = '*'
*    DELE
*  ENDIF
*
* -> OR REMOVE SEPARATOR LINES ONLY WITH THE FOLLOWING COMMANDS
*
*  IF LEN(LTRIM(RTRIM(ENT))) = 1 .AND. '*' $ ENT
*    DELE
*  ENDIF
*
* -> MOVE @ SAY...GET STATEMENTS TO THE LEFT MARGIN
* -> YOU MAY WISH TO REMOVE THIS SECTION FOR IMPROVED READABILITY; IN SOME
*    CASES, THOUGH, THIS MEY MAKE THE @ SAY...GET LINE MAY EXTEND BEYOND THE
*    RIGHT SIDE OF YOUR EDITING SCREEN AND MAKE ERRORS HARDER TO FIND.
*    (BY USING ENT RATHER THAN KS IN THE REPL LINE, UPPER/LOWER CASE IS
*    RETAINED FOR READABILITY; THIS CAN BE EXPECIALLY DESIRABLE IF YOU
*    WRITE YOUR OWN INPUT SCREENS)
*
IF KS = '@'
  REPL ENT WITH LTRIM(ENT)
  SKIP
  LOOP
ENDIF
*
* -> CONTINUATION LINES
*
* -> YOU MAY ALSO WISH TO OMIT THIS SECTION FOR READABILITY.  BE AWARE,
*    HOWEVER, THAT IN SOME SITUATIONS IT MAY RESULT IN AN OVERLY LONG
*    LINE (MORE THAN 254 CHARACTERS IN LENGTH) WHICH CAN BE TRUNCATED
*    BY DBASE RESULTING IN AN ERROR CONDITION OR AN INCOMPLETE BUT
*    SYNTACTICALLY VALID LINE
*
IF CON
  REPL ENT WITH ' ' + LTRIM(RTRIM(WV))
ENDIF
*
* -> CHECK FOR THE START OR TERMINATION OF CONTINUATION LINE SITUATIONS AFTER
*    ADJUSTING INDENTING (SO THE FIRST LINE WILL BE PROPERLY INDENTED IN
*    RELATION TO PRECEDING LINES)
*
CON = (RIGHT(RTRIM(WV), 1) = ';')
*
* -> NOW CHECK FOR POSSIBLE BEGINNINGS OF OTHER INDENTATION SITUATIONS
*
IF KS = 'DO CASE '
  INDEN = INDEN + 4
ENDIF
IF .NOT. PON .AND. (KS = 'PROCEDURE ' .OR. KS = 'PROC ')
  INDEN = INDEN + 2
  PON = .T.
ENDIF
IF KS = 'DO WHILE ' .OR. KS = 'DO WHIL '
  INDEN = INDEN + 2
ENDIF
IF KS = 'IF '
  INDEN = INDEN + 2
ENDIF
SKIP
ENDDO
SET ECHO ON
SET TALK ON
SET DELE ON
* -> HERE'S A LITTLE TRICK I FOUND TO CLEAR THE SCREEN UPON RETURNING FROM A
*    PROGRAM TO THE DBASE PROMPT; AT THE END OF THE PROGRAM, SWITCH THE
*    STATUS LINE OFF AND BACK ON AGAIN (THE PROGRAM WILL DEFAULT BACK TO THE
*    DBASE PROMPT WHEN THERE ARE NO MORE LINES IN THE PROGRAM)
SET STAT OFF
SET STAT ON
