/******************************************************************
*  This is a demo of the clock program.  It could also be
*  used as a screen blanker from your menu system if your
*  menu can be configured to call an external program.
*
*   Compile this demo by running the MAKECLK.BAT
*     (This assumes you are using RTLink.)
*
*   Syntax (From DOS):  CLK  [ 12|24 ]  [ String_to_be_displayed ]
*
*   Both parameters are optional, the clock will default to 12
*   hour mode and "Press any key to continue..."
*
*  The parameters can be passed in any order, and either can be
*  omited.  The only stipulation is that the words in the string,
*  if it contains more than one word, must be separated by the
*  under-score, "_", character.  Any place you want a space, you
*  must replace it with a under-score.  REMEMBER, this is only
*  true of this demo, if you link CLOCK() in with your application,
*  the under-scores are not needed.  The reason the underscore is
*  necessary here is because of the way Clipper handles input
*  parameters from DOS.  If there are any spaces, each word will be
*  concidered a separate parameter.
*
*  All that this function does is resolve and convert the DOS input
*  parameters into their proper type/look.
*
*  All DOS parameters come in as Character type or NIL if not passed.
*
*/


FUNCTION Main(mode, string)
LOCAL holdit
IF string != NIL
  // at least two parameters were passed
  IF string = "12" .or. string = "24"
    // parameters are backwards, flip'um
    holdit := string
    string := mode
    mode := holdit
  ENDIF
ENDIF
// see if first parameter is 12 or 24
IF mode != NIL
  IF mode = "12"
    mode := .T.
  ELSEIF mode = "24"
    mode := .F.
  ELSE
    // parameter one is not 12 or 24,
    // it will now be the displayed string
    string := mode
    mode := .T.
  ENDIF
ENDIF
// if second parameter resolved into a character string,
// replace all underscores with spaces
IF VALTYPE(string) = "C"
  string := STRTRAN(string, "_", " ")
ENDIF
// call the clock (if there are any other errors)
// clock will have to handle it
Clock(mode, string)
RETURN( NIL )
