!
!   RED - 06/11/93

!   This defines variables used in conjunction with the wysifile() function
!   to produce 1-2-3 WYSIWYG files.

!   NOTE: Bit settings are numbered by Lotus Development as 0 through 7 with
!         0 being the rightmost bit.

!

! WYSIWYG record function op codes
wysi_func   GROUP,PRE(wyf)
bof             SHORT(  0)          ! Any op-code > 0 corresponds to the
setup           SHORT,OVER(wyf:bof) !   .FMT file op codes.
eof             SHORT(  1)

prt_cart        SHORT(131)          ! Records should be written in the order
cartridge_1     SHORT(132)          !   of their record code (except EOF).
cartridge_2     SHORT(133)
printer_name    SHORT(134)
port_code       SHORT(135)
baud            SHORT(136)
driver_name     SHORT(137)

line_color      SHORT(150)
color_neg       SHORT(153)
shadow_color    SHORT(163)
font_face       SHORT(174)
font_pitch      SHORT(175)
font_type       SHORT(176)
font_points     SHORT(177)
attr_tab        SHORT(178)
cluster_info    SHORT(181)
prt_settings    SHORT(185)
                                    ! Special, multi-purpose op-codes are < 0.
std_init        SHORT(-1)           !   Write the standard BOF information
std_attr        SHORT(-2)           !   Write a standard attribute table record
                                    !       with the fonts contained in the
                                    !       wyv:fonts_to_use table.
first_clustr    SHORT(-3)           !   Initialize the 1st cluster record and tracking variables
write_clustr    SHORT(-4)           !   "Write" the current cluster
row_end_lump    SHORT(-5)           !   Setup the final lump for the row and "Write" the cluster record
flush_clustr    SHORT(-6)           !   Flush (write) the pending cluster record
                                    !       This MUST be done before a print
                                    !       settings record is written and is
                                    !       done automatically (if needed) when
                                    !       an EOF record is written.
            .
!
wys_version1    BYTE(6)             ! FMT 2 version WYSIWYG file. Must be
wys_version2    BYTE(128)           !   handled as 2 bytes because Clarion's
                                    !   SHORT datatype holds a maximum of 32,767!
!
font_types      GROUP,PRE(wft)      ! Font types used in the B0h record
helv                BYTE(00)        ! Helvetica (like Swiss)
TMS                 BYTE(01)        ! Times Roman (like Dutch)
courier             BYTE(02)        ! Courier
symbol              BYTE(03)        ! Symbol Set
                .

!
! These format codes turn on the various format attributes used in the
!   ATTR_TAB_INFO (B2h) record when BORed together.

wysiwyg_attr    GROUP,PRE(wya)
                                            ! Font Number in (byte 1 of the B2h
use_fonts           GROUP                   !       record). Must be BORed or the
                         BYTE(00000000b)    ! 0 !   bold, etc. settings will be
                         BYTE(00000001b)    ! 1 !   lost.  Uses only bits 0-2.
                         BYTE(00000010b)    ! 2 !
                         BYTE(00000011b)    ! 3
                         BYTE(00000100b)    ! 4
                         BYTE(00000101b)    ! 5
                         BYTE(00000110b)    ! 6
                         BYTE(00000111b)    ! 7
!                             76543210
                    .
use_font            BYTE,DIM(8),OVER(use_fonts)

                                        ! Display attribiutes (byte 1 of the B2h record)
bold                BYTE(00001000b)     ! Bold On
italics             BYTE(00010000b)     ! Italics on
dbl_under           BYTE(00100000b)     ! Double Underline
sngl_under          BYTE(01000000b)     ! Single Underline
wide_under          BYTE(01100000b)     ! Wide Underline

                                        ! Colors used in bytes 2 & 3 of the B2h record
black               BYTE(00000000b)     ! 0
dk_blue             BYTE(00000001b)     ! 1
green               BYTE(00000010b)     ! 2
cyan                BYTE(00000011b)     ! 3
red                 BYTE(00000100b)     ! 4
magenta             BYTE(00000101b)     ! 5
yellow              BYTE(00000110b)     ! 6
white               BYTE(00000111b)     ! 7
red_negative        BYTE(10000000b)     ! BOR this to turn on red negative numbers (byte 2).
                                        !   The red must be set using the color_neg (99h) record.
text_range          BYTE, |
                     OVER(red_negative) ! BOR this to indicate the cell is in a text range (byte 3)

light_shade         BYTE(00001000b)     ! Shades used in byte 3
dark_shade          BYTE(00010000b)
solid_shade         BYTE(00011000b)

shadow_on           BYTE(00100000b)     ! Shadow added used in byte 3

                                        ! Line attributes (byte 4 of the B2h record)
left_wide           BYTE(00000010b)     ! Left Line Wide
left_sngl           BYTE(00000001b)     !           Single
left_dbl            BYTE(00000011b)     !           Double
right_wide          BYTE(00001000b)     ! Right Line Wide
right_sngl          BYTE(00000100b)     !            Single

right_dbl           BYTE(00001100b)     !            Double
top_wide            BYTE(00100000b)     ! Top Line Wide
top_sngl            BYTE(00010000b)     !          Single
top_dbl             BYTE(00110000b)     !          Double
bottom_wide         BYTE(10000000b)     ! Bottom Line Wide
bottom_sngl         BYTE(01000000b)     !             Single
bottom_dbl          BYTE(11000000b)     !             Double
                .
                                    ! Cluster record (B5h) values (row_attrs in row_size)
row_shadow      BYTE(00010000b)     ! Row has a shadow
row_auto_FF     BYTE(00100000b)     ! Row has a automatic page break
row_man_FF      BYTE(01000000b)     ! Row has a manual page break
row_fix_hgt     BYTE(10000000b)     ! Row has a fixed height set by the user

prt_set_attr    GROUP,PRE(wpa)      ! Used in the prt_settings (B9h) record
landscape_on        BYTE(00010000b)     ! print_flags (byte 36)

bin_none            BYTE(0)             ! paper_bin values
bin_sngl_sht        BYTE(1)
bin_manual          BYTE(2)
bin_upper           BYTE(3)
bin_lower           BYTE(4)

paper_letter        BYTE(0)             ! paper_type values
paper_A4            BYTE(1)
paper_80x66         BYTE(2)
paper_132x66        BYTE(3)
paper_80x72         BYTE(4)
paper_legal         BYTE(5)
paper_B5            BYTE(6)
                .
rec_colors      GROUP,PRE(rcc)      ! Colors used in the color_neg (99h)
black               BYTE(0)         !   and the shadow_color (A3h) records
dk_blue             BYTE(1)
green               BYTE(2)
cyan                BYTE(3)
red                 BYTE(4)
magenta             BYTE(5)
yellow              BYTE(6)
white               BYTE(7)
                .

port_codes      GROUP,PRE(wyp)      ! WYSIWYG printer port assignments (87h record)
parallel_1          BYTE(0)
serial_1            BYTE(1)
parallel_2          BYTE(2)
serial_2            BYTE(3)
DOS_LPT1            BYTE(4)
DOS_LPT2            BYTE(5)
DOS_LPT3            BYTE(6)
DOS_LPT4            BYTE(7)
                .
baud_rates      GROUP,PRE(wyb)      ! WYSIWYG printer baud rates (88h record)
baud_110            BYTE(0)
baud_150            BYTE(1)
baud_300            BYTE(2)
baud_600            BYTE(3)
baud_1200           BYTE(4)
baud_2400           BYTE(5)
baud_4800           BYTE(6)
baud_9600           BYTE(7)
baud_19200          BYTE(8)
                .
