!
!   RED - 06/08/93

!   This defines the layout of a 1-2-3 2.3 .FMT file used by the WYSIWYG
!   add-in.  The global variables and arrays needed to use the WYSIFILE
!   proc are also defined here.

!

wysiwyg_vars    GROUP,PRE(wyv)  ! Variables needed bu wysifile() that must be
                                !   set by the caller.
filename            STRING(64)
cluster_lump        BYTE    ! Lump index (count) for the current cluster
cluster_row         BYTE    ! Current row count in the current cluster.  When =
                            !   16, the cluster record is written and this
                            !   is reset to 1.
fonts_to_use        GROUP
font_to_use             BYTE,DIM(2) ! List of the WYSIWYG font numbers (1-8) to
                .   .               !   use.  This is used by the "std_attr"
                                    !   function in wysifile to determine
                                    !   which fonts to load into the standard
                                    !   attribute table record.  Max of 2 fonts
                                    !   can be used!  First zero entry indicates
                                    !   the end of the font list.
!
attr_tab_nos    GROUP,PRE(wat)  ! These variables are used to store the
                                !   attribute table numbers created by the
                                !   "std_attr" function in wysifile or when
                                !   the attributes are assigned "manually" by
                                !   a module.  Using these variables provides
                                !   a consistent naming convention for the
                                !   various attribute combinations.  They
                                !   should be referenced when the attribute is
                                !   assigned to a cluster_info record.  NOTE:
                                !   the first user-defined attribute number is
                                !   17!

attr_fonts          GROUP,DIM(8)    ! Each group group of attributes is repeated,
attr_group              GROUP       !   once for each of the 8 possible fonts.
no_attr                     BYTE    ! Font designation only                   1

                                    ! Normal (no bold or shading)
n_l                         BYTE    !  left border                           2
n_lr                        BYTE    !   right border                        3
n_lrt                       BYTE    !    top border                        4
n_lrb                       BYTE    !    bottom border                     5
n_lr_wb                     BYTE    !    wide bottom border                6
n_lr_db                     BYTE    !    double bottom border              7
n_lr_wt                     BYTE    !    wide top border                   8
n_l_wt                      BYTE    !   wide top border                     9
n_l_wb                      BYTE    !   wide bottom border                 10
n_r                         BYTE    !  Right                                11
n_r_wt                      BYTE    !   wide top border                    12
n_r_wb                      BYTE    !   wide bottom border                 13
n_lrtb                      BYTE    !  complete border                      14
n_wt                        BYTE    !  Wide top                             15
n_wb                        BYTE    !  Wide bottom                          16
n_lrt_wb                    BYTE    !   wide bottom border                 17
n_lrt_db                    BYTE    !   double bottom border               18

b                           BYTE    ! Bold                                   19
b_l                         BYTE    !  left border                          20
b_lr                        BYTE    !   right border                       21
b_lrt                       BYTE    !    top border                       22
b_lrb                       BYTE    !    bottom border                    23
b_lr_wb                     BYTE    !    wide bottom border               24
b_lr_db                     BYTE    !    double bottom border             25
b_lr_wt                     BYTE    !    wide top border                  26
b_l_wt                      BYTE    !   wide top border                    27
b_l_wb                      BYTE    !   wide bottom border                 28
b_r                         BYTE    !  Right                                29
b_r_wt                      BYTE    !   wide top border                    30
b_r_wb                      BYTE    !   wide bottom border                 31
b_lrtb                      BYTE    !  complete border                      32
b_wt                        BYTE    !  Wide top                             33
b_wb                        BYTE    !  Wide bottom                          34
b_lrt_wb                    BYTE    !   wide bottom border                 35
b_lrt_db                    BYTE    !   double bottom border               36
                                    ! 
bs                          BYTE    !  shade (light)                        37
bs_l                        BYTE    !   left border                        38
bs_lr                       BYTE    !    right border                     39
bs_lrt                      BYTE    !     top border                     40
bs_lrb                      BYTE    !     bottom border                  41
bs_lr_wb                    BYTE    !     wide bottom border             42
bs_lr_db                    BYTE    !     double bottom border           43
bs_lr_wt                    BYTE    !     wide top border                44
bs_l_wt                     BYTE    !    wide top border                  45
bs_l_wb                     BYTE    !    wide bottom border               46
bs_r                        BYTE    !   Right                              47
bs_r_wt                     BYTE    !    wide top border                  48
bs_r_wb                     BYTE    !    wide bottom border               49
bs_lrtb                     BYTE    !   complete border                    50
bs_wt                       BYTE    !   Wide top                           51
bs_wb                       BYTE    !   Wide bottom                        52
bs_lrt_wb                   BYTE    !    wide bottom border               53
bs_lrt_db                   BYTE    !    double bottom border             54

                                    ! In text range
no_attr_t                   BYTE    ! No attributes in text range            55
                                    ! Normal (no bold or shading)
nt_l                        BYTE    !  left border                          56
nt_lr                       BYTE    !   right border                       57
nt_lrt                      BYTE    !    top border                       58
nt_lrb                      BYTE    !    bottom border                    59
nt_lr_wb                    BYTE    !    wide bottom border               60
nt_lr_db                    BYTE    !    double bottom border             61
nt_lr_wt                    BYTE    !    wide top border                  62
nt_l_wt                     BYTE    !   wide top border                    63
nt_l_wb                     BYTE    !   wide bottom border                 64
nt_r                        BYTE    !  Right                                65
nt_r_wt                     BYTE    !   wide top border                    66
nt_r_wb                     BYTE    !   wide bottom border                 67
nt_lrtb                     BYTE    !  complete border                      68
nt_wt                       BYTE    !  Wide top                             69
nt_wb                       BYTE    !  Wide bottom                          70
nt_lrt_wb                   BYTE    !   wide bottom border                 71
nt_lrt_db                   BYTE    !   double bottom border               72

bt                          BYTE    ! Bold - Text range, no shade, no border 73
bt_l                        BYTE    !  left border                          74
bt_lr                       BYTE    !   right border                       75
bt_lrt                      BYTE    !    top border                       76
bt_lrb                      BYTE    !    bottom border                    77
bt_lr_wb                    BYTE    !    wide bottom border               78
bt_lr_db                    BYTE    !    double bottom border             79
bt_lr_wt                    BYTE    !    wide top border                  80
bt_l_wt                     BYTE    !   wide top border                    81
bt_l_wb                     BYTE    !   wide bottom border                 82
bt_r                        BYTE    !  Right                                83
bt_r_wt                     BYTE    !   wide top border                    84
bt_r_wb                     BYTE    !   wide bottom border                 85
bt_lrtb                     BYTE    !  complete border                      86
bt_wt                       BYTE    !  wide top                             87
bt_wb                       BYTE    !  wide bottom                          88
bt_lrt_wb                   BYTE    !   wide bottom border                 89
bt_lrt_db                   BYTE    !   double bottom border               90
                                    ! 
bts                         BYTE    !  shade (light)                        91
bts_l                       BYTE    !   left border                        92
bts_lr                      BYTE    !    right border                     93
bts_lrt                     BYTE    !     top border                     94
bts_lrb                     BYTE    !     bottom border                  95
bts_lr_wb                   BYTE    !     wide bottom border             96
bts_lr_db                   BYTE    !     double bottom border           97
bts_lr_wt                   BYTE    !     wide top border                98
bts_l_wt                    BYTE    !    wide top border                  99
bts_l_wb                    BYTE    !    wide bottom border              100
bts_r                       BYTE    !   Right                             101
bts_r_wt                    BYTE    !    wide top border                 102
bts_r_wb                    BYTE    !    wide bottom border              103
bts_lrtb                    BYTE    !   complete border                   104
bts_wt                      BYTE    !   Wide top                          105
bts_wb                      BYTE    !   Wide bottom                       106
bts_lrt_wb                  BYTE    !    wide bottom border              107
bts_lrt_db                  BYTE    !    double bottom border            108
                        .
attr_tab_no             BYTE,DIM(108),OVER(attr_group)
                .   .

!
wys_file    DOS,NAME(wyv:filename),PRE(wys)
record      RECORD
opcode          SHORT
length          SHORT

bof             GROUP
version1            BYTE                    ! 6 here and
version2            BYTE                    ! 128 here for FMT 2 version file
                    GROUP;BYTE,DIM(1024).   ! 1,024 is the largest potential record size
                .
string          STRING(128),OVER(bof)      ! General use string

                GROUP,OVER(bof)
prt_cart            BYTE            ! 1=Printer supports cartridges
                .
                GROUP,OVER(bof)
cartridge_1         STRING(13)      ! Primary cartridge name (ASCIIZ)
                .
                GROUP,OVER(bof)
cartridge_2         STRING(13)      ! Secondary cartridge name (ASCIIZ)
                .
                GROUP,OVER(bof)
printer_name        STRING(128)     ! Printer name (ASCIIZ).  Full name as
                .                   !   shown to user in the WYSIWYG print status
                                    !   screen.
                GROUP,OVER(bof)
port_code           SHORT           ! Printer port (see "port_codes" in wysiwyg.inc)
                .
                GROUP,OVER(bof)
baud                SHORT           ! Printer baud rate (see "baud_rates" in wysiwyg.inc)
                .
                GROUP,OVER(bof)
driver_name         STRING(128)     ! Internal printer driver name (ASCIIZ)
                .                   !   (ie. XHPLJ3)
                GROUP,OVER(bof)
line_color          BYTE            ! Line color
                .

                GROUP,OVER(bof)
color_neg           BYTE            ! Color for negative numbers (see wysiwyg.inc)
                .
                GROUP,OVER(bof)
shadow_color        BYTE            ! Color for shadows
                .
font_face       GROUP,OVER(bof)     ! Font Faces (8 per file)
font_number         BYTE            ! Font #
font_name           STRING(9)       ! ASCIIZ string (max = 9 characters, ie. HLV, TMS)
                .
                GROUP,OVER(bof)     ! PITCH Size (?) of the 8 fonts
font_pitch          SHORT,DIM(8)
                .
                GROUP,OVER(bof)     ! The Type of the 8 fonts
font_type           SHORT,DIM(8)    !
                .
                GROUP,OVER(bof)     ! The point size of the 8 fonts
font_points         SHORT,DIM(8)    !
                .
attr_tab        GROUP,OVER(bof)     ! The table of possible attribute combinations
attr_table          GROUP,DIM(256)  ! Max of 256 different combinations
char_attr               BYTE        ! Byte 1 - character display attributes
char_color              BYTE        ! Byte 2 - character color and red negative indicator (bit 7)
bg_attr                 BYTE        ! Byte 3 - Background color, shading, shadow, and text range indicator
border_attr             BYTE        ! Byte 4 - Line border attributes
                .   .

clusters        GROUP,OVER(bof)     ! The list of rows in 16 row blocks with
cluster_no          SHORT ! 0=1     !   the attribute info. One of these records
                                    !   must be produced for each group of 16
                                    !   rows used in a spreadsheet.
                    SHORT           ! (reserved)
cluster_rec         GROUP
row_size                GROUP,DIM(16)   ! On for each row in the cluster
row_height                  BYTE        ! Defaults to font point size + 2
row_attrs                   BYTE
                        .
row_len                 GROUP,DIM(16)
row_lumps                   BYTE        ! Number of LUMPS in each row (0-255)
                        .
lumps                   GROUP,DIM(256)  ! Up to 256 LUMPS per row. DIM is the starting column number.
col_count                   BYTE        ! #of columns this LUMP is in effect (must total 256 for each LUMP!)
attr_style                  BYTE        ! Attribute style (from the attr_tab record) for this LUMP
                .   .   .

prt_settings    GROUP,OVER(bof)     ! The Print settings
UpLeftCol           SHORT           ! Print range - Upper left corner Column (A=0)
UpLeftRow           SHORT           !               "     "    "      Row    (1=0)
LoRghtCol           SHORT           !               Lower right corner Column
LoRghtRow           SHORT           !               "     "    "       Row

RowUpLeftCol        SHORT           ! Row Border - Upper left corner Column
RowUpLeftRow        SHORT           !              "     "    "      Row
RowLoRghtCol        SHORT           !              Lower Right corner Column
RowLoRghtRow        SHORT           !              "     "     "      Row

ColUpLeftCol        SHORT           ! Column Border - Upper left corner Column
ColUpLeftRow        SHORT           !                 "     "    "      Row
ColLoRghtCol        SHORT           !                 Lower Right corner Column
ColLoRghtRow        SHORT           !                 "     "     "      Row

PaperSizeWid        SHORT           ! Paper Size - Width (in thousandths of an inch, ie. 8500 = 8.5")
PaperSizeLen        SHORT           !              Length (11000 = 11.0")

MarginLeft          SHORT           ! Left Margin (in thousandths of an inch, ie. 500 = 1/2")
MarginRight         SHORT           ! Right Margin (500 = 1/2")
MarginTop           SHORT           ! Top Margin (1000 = 1.0")
MarginBot           SHORT           ! Right Margin (500 = 1/2")

print_flags         BYTE            ! Various Print settings (ie, see "prt_set_attr" in wysiwyg.inc)
page_breaks         BYTE,DIM(32)    ! Page breaks by column groups
paper_bin           SHORT           ! 0=Default
                    SHORT           ! Reserved
copies              SHORT           ! Number of copies
compression         SHORT           ! 15 - 1000%
paper_type          SHORT           ! Paper type
.           .   .
