!
!   RED - 03/13/92
!
!   This defines the layout of a 1-2-3 spreadsheet file.  The 1-2-3 record
!   opcode values and the variables needed to process a 1-2-3 file are also
!   defined.
!
!

wks_file    DOS,NAME(wks_filename),PRE(wks)
record      RECORD
opcode          SHORT
length          SHORT
bof_info        GROUP
version             SHORT
                    GROUP;BYTE,DIM(2062).
                .
window1_info    GROUP,OVER(bof_info)            ! Window #1 information
cursor_col          SHORT                       ! Current cursor column
cursor_row          SHORT                       !   and row
cell_format         BYTE
                    BYTE                        ! Unused (must be 0)
w1_col_width        SHORT
screen_cols         SHORT                       ! #of columns on screen
screen_rows         SHORT                       ! #of rows on screen
leftmost_col        SHORT
top_row             SHORT
title_cols          SHORT                       ! # of title columns
title_rows          SHORT                       ! # of title rows
left_ttl_col        SHORT                       ! Left title column number
top_ttl_row         SHORT                       ! Top title row number
br_width_col        SHORT                       ! Border width column
br_width_row        SHORT                       ! Border width row
window_width        SHORT                       ! Window width column
                    BYTE                        ! Unused (must be 0)
                    BYTE                        ! Pad to 32?
                .
width_info      GROUP,OVER(bof_info)
col_number          SHORT           ! A = 0
col_width           BYTE
                .
data            GROUP,OVER(bof_info)
format              BYTE
col                 SHORT           ! A = 0
row                 SHORT           ! 1 = 0

label_info          GROUP
label_prefix            STRING(1)
string                  STRING(239)
                        GROUP;BYTE,DIM(1818).
                    .
integer_info        GROUP,OVER(label_info)
integer                 SHORT       ! 2-byte number - can only be a value
                    .               !   from -32,768 to 32,767!

real_info           GROUP,OVER(label_info)
real_no                 REAL        ! 8-byte (64-bit) floating point, IEEE format
                    .
formula_info        GROUP,OVER(label_info)
result                  REAL        ! Formula result (64-bit, IEEE format)
text_len                SHORT       ! Formula text size in bytes
formula_text            GROUP;BYTE,DIM(2048).
.           .   .   .

! 1-2-3 Cell opcode values
bof_op          SHORT(00)           ! Beginning of file
window1_def     SHORT(07)           ! Window #1 definition (the main window)
col_width_op    SHORT(08)           ! Set column width
integer_op      SHORT(13)           ! Integer (0D00h, I/O automatically reverses)
floating_op     SHORT(14)           ! Floating pointer (IEEE format, and Clarion!, format)
label_op        SHORT(15)           ! Label record
formula_op      SHORT(16)           ! Formula record
cur_graph_op    SHORT(45)           ! Current graph record
nam_graph_op    SHORT(46)           ! Named graph record
def_range_op    SHORT(71)           ! Define range
eof_op          SHORT(01)           ! End of file

ver_123_1       SHORT(1028)         ! Version 1.x spreadsheet
ver_123_2       SHORT(1030)         ! Version 2.x spreadsheet

! These format codes correspond to 1-2-3's format codes with cell
!   protection on.
def_format      BYTE(11111111b)     ! Use Default spreadsheet format
cur_0_dec       BYTE(10100000b)     ! Currency, 0 decimal places
cur_2_dec       BYTE(10100010b)     ! Currency, 2 decimal places
comma_0_dec     BYTE(11000000b)     ! Comma, 0 decimal places
comma_1_dec     BYTE(11000001b)     ! Comma, 1 decimal place
comma_2_dec     BYTE(11000010b)     ! Comma, 2 decimal places
comma_3_dec     BYTE(11000011b)     ! Comma, 3 decimal places
comma_4_dec     BYTE(11000100b)     ! Comma, 4 decimal places
comma_5_dec     BYTE(11000101b)     ! Comma, 5 decimal places
comma_6_dec     BYTE(11000110b)     ! Comma, 6 decimal places
date_intl_1     BYTE(11111001b)     ! Date, MM/DD/YY
date_std        BYTE(11110010b)     ! Date, DD-MMM-YY

! Turns off the "protected" cell bit when BANDed with the standard 1-2-3
!   "protected cell" formats above.
unprot_cell     BYTE(01111111b)

max_123_rows    SHORT(8192)         ! Maximum # of rows in a 1-2-3 spreadsheet

cnv_123_date    LONG(36161)         ! Subtract this variable from a standard
                                    !   Clarion date field (LONG) to convert
                                    !   it to the correct 1-2-3 date value.
cnv_DBF_date    LONG(2378858)       ! Add this variable to a standard Clarion
                                    !   date field (LONG) to convert it to the
                                    !   correct dBase III/IV (.DBF) date value.
                                    !   In Foxpro, use the SYS(11,xxx) function
                                    !   to convert a date string to the DBF
                                    !   format date number.
                                    !   (ie. REPLACE ALL cla_date WITH VAL(SYS(11,char_date)) - 2378858

wks_filename    STRING(64)
wks_number      REAL
file_size       LONG                ! Size of the WKS file in bytes
wks_pointer     LONG                ! Use as pointer variable for GETs
org_pointer     LONG                ! Hold area for pointer value
byte_cnt        BYTE                ! Number of bytes to read or write
cur_row         SHORT
cur_col         SHORT
col_shown       SHORT               ! Column# currently displayed (use to
                                    !   determine if the column letter display
                                    !   needs to be updated.
col_letters     GROUP               ! Column letter character values
col_letter          BYTE,DIM(2)
                .

cell_typ_err   BYTE                 ! Set by read routines to indicate that the
                                    !   expected cell type was not read (ie.
                                    !   a label was found when a numeric cell
                                    !   was required).
