{------------------------------------------------------------------------------

                                REVISION HISTORY

v1.00  : 1993/10/07.  First public release.  DDA
v1.01  : 1993/10/22.  Fix: wasn't deleting a temporary file.  DDA
                      Changed RDUPSORT.BAT to comply with RPSORT,
                        an excellent and fast freeware sorter.  DDA
                        RPSRT102 is on Channel 1, the FHOF BBS, and elsewhere.
v1.02  : 1993/10/26.  All dups placed in a report file, "rdup_del.dat".  DDA
v1.03  : 1993/12/20.  Now checks original directory for RDUPSORT.BAT, and
                      uses that copy for executing it if it exists.      DDA

------------------------------------------------------------------------------}

{$M 4096, 0, 0}
uses dos,crt ;
const
     tmpd = 'rdup#dir';
     masf = 'rdup#fil';
     attn = '[... The following is a new filename:';
var  wp : string ;

procedure showhelp ( errornum : byte );
const
     progdata = 'RDUP- Free DOS utility: delete duplicate lines across multiple files.';
     progdat2 = 'V1.03: December 20, 1993. (c) 1993 by David Daniel Anderson - Reign Ware.';
      usage   = 'Usage:  RDUP file_spec [/i (=case Insensitive)]';
var
    message : string [80];
begin
    writeln ( progdata );
    writeln ( progdat2 );
    writeln ;
    writeln ( usage );
    writeln ;

    case errornum of
      1 : message := 'invalid number of command line parameters.';
      2 : message := 'unable to create or use storage directory.';
      3 : message := 'no files found to process.';
      9 : message := 'undefined error.';
    end;
    writeln ( 'ERROR: (#',errornum,') - ', message );
    halt ( errornum );
end;

function converttoupper(w : string) : string;
var
   cp  : integer;        {the position of the character to change.}
begin
     for cp := 1 to length(w) do
         w[cp] := upcase(w[cp]);
     converttoupper := w;
end;

procedure makedir ( tdir : string );
var
  resp : char ;
begin
  {$I-}
  mkdir ( tdir );
  if (IOResult <> 0) then begin
     writeln ( 'Storage directory ',tdir,' already exists!' );
     write ( 'Press "y" to use, any other key to abort: ');
     resp := readkey ;
     if (upcase (resp) <> 'Y') then showhelp (2);
     writeln ( resp );
  end;
  {$I+}
end;

procedure combine ( tagfiles : string ; var alltg : text );
var
   dirinfo : searchrec ;
   tagline : string ;
   tagfile : text ;
begin
  findfirst ( (wp+tagfiles), archive, dirinfo );
  if ( doserror = 0 ) then begin
     assign ( alltg, tmpd+'\'+masf );
     rewrite ( alltg );
     repeat
       assign ( tagfile,wp+dirinfo.name );
       reset  ( tagfile );
       writeln ( alltg,attn+' ][ '+dirinfo.name );
       writeln ( 'Assimilating: ',wp+dirinfo.name );
       while   ( not ( eof ( tagfile ))) do begin
            readln ( tagfile, tagline );
            writeln ( alltg, tagline );
       end;
       close  ( tagfile );
       findnext ( dirinfo );
     until ( doserror <> 0 );
     close ( alltg );
  end
  else
    showhelp (3);
end;

procedure separate ( var alltg : text );
var
   tagfiles, tagline : string ;
   tagfile           : text ;
begin
  reset ( alltg );
  readln ( alltg, tagline );
  if ( ( copy (tagline,1,45)) <> attn ) then
    showhelp (9)
  else begin
    tagline := ( copy ( tagline,50,( length (tagline)-49 )));
    assign ( tagfile, tagline );
    rewrite ( tagfile );
    writeln ( 'De-Assimilating: ',tagline );
  end;
  while ( not ( eof ( alltg ))) do begin
    readln ( alltg, tagline );
    if ( ( copy (tagline,1,45)) = attn ) then begin
      close  ( tagfile );
      tagline := ( copy ( tagline,50,( length (tagline)-49 )));
      assign ( tagfile,tagline );
      rewrite ( tagfile );
      writeln ( 'De-Assimilating: ',tagline );
    end
    else
      writeln ( tagfile, tagline );
  end;
  close  ( tagfile );
  close  ( alltg );
end;

procedure putnumb ( var source : text ; fname : string );
var
   numb  : word ;
   dest  : text ;
   linec : string ;
begin
     assign ( source, fname );
     reset  ( source );
     assign ( dest, 'rwgibber.tmp' );
     rewrite ( dest );
     numb := 10000 ;
     repeat
          readln (source,linec);
          numb := succ (numb);
          writeln ( dest, numb ,' ', linec);
     until eof (source);
     close ( source );
     close ( dest );
     erase ( source );
     rename ( dest, fname );
end;

procedure rmvnumb ( var source : text ; fname : string );
var
   dest  : text ;
   linec : string ;
begin
     assign ( source, fname );
     reset  ( source );
     assign ( dest, 'rwgibber.tmp' );
     rewrite ( dest );
     repeat
          readln ( source, linec );
          delete ( linec,1,6);
          writeln ( dest,linec );
     until eof ( source );
     close ( source );
     close ( dest );
     erase ( source );
     rename ( dest, fname );
end;

procedure dduplins ( var sfile : text ; fname : string );
const dischars = 6;
var
   statfile,
   dfile  : text ;
   linecr, lineca,
   linenx, linena : string ;
   ig_case : boolean ;
   ic : string [4];

begin
     if ( paramcount = 2 ) then
        ig_case := (( converttoupper ( paramstr (2) )) = '/I' )
     else ig_case := false ;
     if ig_case
        then ic := ''
        else ic := 'not ';

     writeln ( 'Deleting duplicates now, and ',ic,'ignoring case.' );

     assign ( statfile, 'rdup_del.dat' );
       rewrite  ( statfile );
     assign ( sfile, fname );
       reset  ( sfile );
     assign ( dfile, 'rwgibber.tmp' );
       rewrite ( dfile );

     readln  ( sfile,linenx );
     linena  := linenx;
     if ig_case then
        linena  := converttoupper (linena);
     delete ( linena,1,dischars );

     while not eof (sfile) do
     begin
           linecr := linenx;
           lineca := linena;

           readln  ( sfile,linenx );
           linena  := linenx;
           if ig_case then
              linena  := converttoupper (linena);
           delete  ( linena,1,dischars );

           if ( lineca <> linena ) then
              writeln ( dfile,linecr )
           else
              writeln ( statfile, ( copy ( linecr,7, ( length (linecr)-6))) );
     end;
     writeln ( dfile,linenx );

     close ( sfile );
     close ( dfile );
     close ( statfile );
     erase ( sfile );
     rename ( dfile, fname );
end;

procedure getpath ( var wpath, inf : string );
var
    ps1     : pathstr ;
    rdir    : dirstr ;
    rname   : namestr ;
    rext    : extstr ;
begin
     ps1 := inf;
     ps1 := ( fexpand ( ps1 ));
     fsplit ( ps1,rdir,rname,rext );
     wpath := rdir;
     inf := rname+rext;
end;

var
   tags    : string ;
   alltags : text ;
   dirinfo : searchrec ;
   inorg   : boolean ;

begin
  findfirst ( 'RDUPSORT.B*', archive, dirinfo );
  inorg := ( doserror = 0 );
  checkbreak := false ;
  if ( paramcount < 1 )
  or ( paramcount > 2 )
     then showhelp (1);
  makedir ( tmpd );
  tags := paramstr (1);
  getpath ( wp, tags );

  clrscr ;
  writeln ( 'Start!' );
  writeln ( 'Constructing master file.' );
  combine ( tags, alltags );
  chdir ( tmpd );
  writeln ( 'Adding line numbers.' );
  putnumb ( alltags, masf );

  writeln ( 'Shelling out to sort.' );
   swapvectors ;
   if inorg then
     exec ( getenv ('COMSPEC'),' /c ..\rdupsort '+masf+' >nul' )
   else
     exec ( getenv ('COMSPEC'),' /c rdupsort '+masf+' >nul' );
   swapvectors ;

  dduplins ( alltags, masf );

  writeln ( 'Shelling out to sort.' );
   swapvectors ;
   if inorg then
     exec ( getenv ('COMSPEC'),' /c ..\rdupsort '+masf+' /u >nul' )
   else
     exec ( getenv ('COMSPEC'),' /c rdupsort '+masf+' /u >nul' );
   swapvectors ;

  writeln ( 'Removing line numbers.' );
  rmvnumb ( alltags, masf );
  separate ( alltags );
  writeln ( 'Destroying master file.' );
  erase ( alltags );
  writeln ( 'Finish!' );
end.
