;;; Copyright (c) 1993 V.S. Delta CAD
;;;C:SKEW
(defun C:SKEW ( / ent1 ent2 p1 q1 p2 q2 n d dir int int_nil tmp int1 lngth
                                *error* dot vector lngth unit dirct)
   (defun *error* (s) (princ))
   (defun dot (a b)(+ (* (car a) (car b)) (* (cadr a)(cadr b)) (* (caddr a)(caddr b))))
   (defun vector (a b) (list (- (* (cadr a) (caddr b)) (* (cadr b) (caddr a)))
             (- (* (caddr a) (car b)) (* (car a) (caddr b)))
             (- (* (car a) (cadr b)) (* (car b) (cadr a)))))
   (defun lngth (a) (sqrt (+ (expt (car a) 2.0) (expt (cadr a) 2.0) (expt (caddr a) 2.0))))
   (defun unit (a b) (mapcar '(lambda (c) (/ c b)) a))
   (defun dirct (a b) (list (- (car b) (car a)) (- (cadr b) (cadr a)) (- (caddr b) (caddr a))))
   (princ "\nSelect first line.")
   (while (not (and (setq ent1 (nentsel))
      (= (cdr (assoc 0 (setq ent1 (entget (car ent1))))) "LINE"))))
   (princ "\nSelect second line.")
   (while (not (and (setq ent2 (nentsel))
      (= (cdr (assoc 0 (setq ent2 (entget (car ent2))))) "LINE"))))
   (setq p1 (cdr (assoc 10 ent1)) q1 (cdr (assoc 11 ent1))
         p2 (cdr (assoc 10 ent2)) q2 (cdr (assoc 11 ent2)))
   (if (inters p1 q1 p2 q2 ())
      (progn (princ "\nThe selected lines intersect!")(quit)))
   (setq n (unit (setq tmp (vector (dirct p1 q1) (dirct p2 q2))) 
      (if (= 0.0 (lngth tmp))
         (progn (princ "\nThe selected lines are parallel.")(quit))(lngth tmp))))
   (setq d (dot n (dirct p1 p2)))
   (setq dir (mapcar '(lambda (a) (* a d)) n))
   (setq int (inters (mapcar '+ p1 dir) (mapcar '+ q1 dir) p2 q2))
   (setq int_nil (inters (mapcar '+ p1 dir) (mapcar '+ q1 dir) p2 q2 ()))
   (if int (progn (setq int1 (mapcar '(lambda (a b) (- a b)) int dir))
         (entmake (list '(0 . "LINE") (cons 10 int) (cons 11 int1)))))
   (if (and int_nil (not int)) (progn
         (princ "\nThe drawn line segment does not intersect the selected lines!")
         (setq int1 (mapcar '(lambda (a b) (- a b)) int_nil dir))
         (entmake (list '(0 . "LINE") (cons 10 int_nil) (cons 11 int1)))
      ))(princ "\nThe created line segment is ")(princ d)(princ " units long.")(princ))
