/* ------------------------------------------------------------------------ *\
|            |                                                               |
|  WRAPI.H   | Wrapped-API definitions.                                      |
|            |                                                               |
|            | Placed in the public domain by:                               |
|            |                                                               |
|            |    Gregory C. Sarafin                                         |
|            |    In-Design                                                  |
|            |    PO Box 336                                                 |
|            |    Cranbury, NJ 08512                                         |
|            |                                                               |
|            |    CIS: 73747,3112                                            |
|            |                                                               |
|            |                                                               |
|            | * * N O T I C E * N O T I C E * N O T I C E * N O T I C E * * |
|            |                                                               |
|            | WRAPI is the original work of Gregory C. Sarafin with         |
|            | contributions by David Karasek.                               |
|            |                                                               |
|            | WRAPI comes with absolutely no warranty.                      |
|            |                                                               |
|            | WRAPI exists in the public domain.                            |
|            |                                                               |
|            | Use WRAPI at your own risk.                                   |
|            |                                                               |
|            | * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * |
|            |                                                               |
|            |                                                               |
|            | The following APIs are currently supported...                 |
|            |                                                               |
|            | _API_MSC       Microsoft 'C' (Large Model)             LIB    |
|            | _API_BC        Borland 'C'   (Large Model)             LIB    |
|            | _API_WCC       Watcom 'C'    (Large Model)             LIB    |
|            | _API_DLL       Generic 'C' DLL                         DLL    |
|            | _API_CLIP4     Clipper Summer '87                      LIB    |
|            | _API_CLIP5     Clipper 5.x  (VMM)                      LIB    |
|            | _API_FPD20     FoxPro 2.0                              PLB    |
|            | _API_FPD25     FoxPro 2.5+                             PLB    |
|            | _API_FPW25     FoxPro 2.5+ for Windows                 FLL    |
|            | _API_VBD       Visual Basic for DOS 1.0+               LIB    |
|            | _API_VBW       Visual Basic for Windows 2.0+           DLL    |
|            |                                                               |
|            |                                                               |
|            | Revison History                                               |
|            |                                                               |
|            |                                                               |
|            | #     Date      Description                                   |
|            | -     ----      -----------                                   |
|            | 1.00  01/07/94  Sanitized for public consumption              |
|            |                                                               |
\* ------------------------------------------------------------------------ */



#ifdef _MSC_VER

  #pragma warning(disable:4001)
  #pragma warning(disable:4101)
  #pragma warning(disable:4127)

#endif


/* API setup -------------------------------------------------------------- */

#ifdef _API_CLIP4

  #define _API_CLIPPER

#endif

#ifdef _API_CLIP5

  #define _API_CLIPPER

#endif

#ifdef _API_CLIPPER

  #define IsWZTerm   1

  #define _FAMILY_XBASE

  #ifdef _API_CLIP4

    #include <extend.h>

  #else

    #include <extend.api>

  #endif

  #include <io.h>
  #include <sys\types.h>
  #include <sys\stat.h>

#endif

#ifdef _API_FPD20

	#define _API_FOX

#endif

#ifdef _API_FPD25

	#define _API_FOX

#endif

#ifdef _API_FPW25

	#define _API_FOX

  #define WINVER 0x300

  #define _FAMILY_DLL

  #include <windows.h>
  #include <string.h>
  #include <malloc.h>

#endif

#ifdef _API_FOX

  #define IsWZTerm   0

  #define _FAMILY_XBASE

  #include <pro_ext.h>

#endif

#ifdef _API_VBD

  #define IsWZTerm   0

  #define _FAMILY_C

  #include <io.h>
  #include <fcntl.h>
  #include <sys\types.h>
  #include <sys\stat.h>
  #include <string.h>
  #include <malloc.h>

#endif

#ifdef _API_BC

  #define _API_C

#endif

#ifdef _API_MSC

  #define _API_C

#endif

#ifdef _API_WCC

  #define _API_C

#endif

#ifdef _API_C

  #define IsWZTerm   1

	#define _FAMILY_C

  #include <stdlib.h>
  #include <io.h>
  #include <fcntl.h>
  #include <sys\types.h>
  #include <sys\stat.h>
  #include <string.h>
  #include <malloc.h>

#endif

#ifdef _API_DLL

  #define IsWZTerm    1

  #define _API_C
	#define _FAMILY_C
  #define _FAMILY_DLL

  #include <stdlib.h>
  #include <windows.h>
  #include <io.h>
  #include <fcntl.h>
  #include <sys\types.h>
  #include <sys\stat.h>
  #include <string.h>
  #include <malloc.h>

#endif

#ifdef _API_VBW

  #define IsWZTerm   1

	#define _FAMILY_C
  #define _FAMILY_DLL

  #include <windows.h>
  #include <vbapi.h>
  #include <io.h>
  #include <fcntl.h>
  #include <sys\types.h>
  #include <sys\stat.h>
  #include <string.h>
  #include <malloc.h>

#endif


/* Standard typedefs ------------------------------------------------------ */

#ifndef NULL

  #define NULL (void*) 0L

#endif

// basic typedefs

typedef short          bool    ;
typedef signed short   fhandle ;
typedef unsigned char  uchar   ;
typedef unsigned short ushort  ;
typedef unsigned long  ulong   ;


// Standard NIL definitions.

#ifndef USE_NIL
#define USE_NIL  1                 // Flag for using NIL logic, change
#endif                             // it to 0 to disable NIL processing

#if USE_NIL

  #define NIL_C ( (char)   '\xFF' )
  #define NIL_I ( (short)  -32767 ) // you may want to change these to
  #define NIL_B ( (bool)   -32767 ) // negative MAX_VALUEs
  #define NIL_L ( (long)   -32767 )
  #define NIL_D ( (double) -32767 )
  #define NIL_S ( (char*)  "\xFF" )
  #define NIL_G ( (void*)      0L )

#else

  #define NIL_C ( (char)  '\0' )
  #define NIL_I ( (short)   0  )
  #define NIL_B ( (bool)    0  )
  #define NIL_L ( (long)    0  )
  #define NIL_D ( (double)  0  )
  #define NIL_S ( (char*)   "" )
  #define NIL_G ( (void*)   0L )

#endif

// WPRN typedef

typedef struct   { // WRAPPED PRINT DEVICE STRUCTURE
	bool    bStd   ; // a STD print device?
	fhandle fh     ; // handle to a DOS file/device
                 #ifdef _FAMILY_DLL
	HDC     hdc    ; // handle to a device context
	bool    bSpool ; // indicates that spooler was hooked up
                 #endif
} WPRN           ;


// WSTR typedef

typedef struct  { // WRAPPED-API STRING STRUCTURE
  char   *cp    ; // Actual pointer to the string
  ushort  uiLen ; // Length of string
  ulong   ulHnd ; // Host API handle if applicable
} WSTR          ; // 10 byte structure vs 4 byte char*


// Numeric array typedefs (you can add your own)

typedef struct { double d1 ; double d2 ; } D2 ;
typedef struct { double d1 ; double d2 ; double d3 ; double d4 ; } D4 ;


/* Standard prototypes and macro functions -------------------------------- */

// Stringify and Type Conversion functions

char*    stringify  ( void* , char* )                                        ;

char*    itosz      ( short , short )                                        ;
char*    uitosz     ( ushort , short )                                       ;
char*    ltosz      ( long , short )                                         ;
char*    ultosz     ( ulong , short )                                        ;
char*    dtosz      ( double , short )                                       ;
long     dtol       ( double , short )                                       ;

short    sztoi      ( char* )                                                ;
ushort   sztoui     ( char* )                                                ;
long     sztol      ( char* )                                                ;
ulong    sztoul     ( char* )                                                ;
double   sztod      ( char* )                                                ;

double   powerof10  ( short )                                                ;
double   round      ( double , short )                                       ;


// String manipulation functions

void     szwcpy     ( char* , WSTR* )                                        ;
void     swzcpy     ( WSTR* , char* )                                        ;
void     swwcpy     ( WSTR* , WSTR* )                                        ;

void     szwncpy    ( char* , WSTR* , ushort )                               ;

short    szwcmp     ( char* , WSTR* )                                        ;
short    swzcmp     ( WSTR* , char* )                                        ;
short    swwcmp     ( WSTR* , WSTR* )                                        ;

WSTR*    ztow       ( char* )                                                ;
char*    ctosz      ( char )                                                 ;

void     strfill    ( char** , char* )                                       ;
bool     streat     ( char** , char* , char , ushort )                       ;
void     strpadr    ( char* , char , ushort )                                ;


// Device output

short    iWPrnStart ( WPRN* , short )                                        ;
short    iWPrnEnd   ( WPRN* )                                                ;
bool     bWPrnC     ( WPRN* , char  )                                        ;
bool     bWPrnSZ    ( WPRN* , char* )                                        ;
bool     bWPrnSB    ( WPRN* , char* , ushort )                               ;
bool     bWPrnWSP   ( WPRN* , WSTR* )                                        ;

short    iMsgError  ( void )                                                 ;


// Error handling

void     vWError ( void )                                                    ;


// DLL stuff

#ifdef _FAMILY_DLL

  BOOL FAR PASCAL _export bAbortProc      ( HDC , short ) ;
  HDC                     hdcGetPrinterDC ( void )        ;
  bool                    bGDICommand     ( HDC , short ) ;
  bool                    bGDIPrint       ( HDC , WSTR* ) ;

#endif


// Memory allocation

void*   WAlloc   ( ushort )                                                 ;
void    WFree    ( void** )                                                 ;

#define ALLOC(uiSize)      WAlloc  ( uiSize )
#define FREE(vp)           WFree   ( (void**) & ( vp ) )

#define ALLOC_LEN          6
#define ALLOC_HND          4

#define ALLOCATED(vp) ( vp ? * (ushort*) ( (char*) vp - ALLOC_LEN ) : (ushort) 0 )


// WSTR manipulators

#if IsWZTerm
  #define  cWNext(wsp,i)    ( *( (*wsp).cp + ++i ) )
#else
  #define  cWNext(wsp,i)    ( i < (*wsp).uiLen ? *( (*wsp).cp + ++i ) : (char) ( ++i && 0 ) )
#endif

#if USE_NIL
  #define IsWNIL(wsp)       ( !wsp || !(*wsp).cp || *(*wsp).cp == NIL_C )
#else
  #define IsWNIL(wsp)       ( 0 )
#endif

#define IsWNULL(wsp)        ( ! (*wsp).uiLen )

#define IsWEOS(wsp,i)       ( ! ( (*wsp).uiLen > (ushort) i ) )

#define wspcpy(wspTo,wspFr) MEMCPY ( wspTo , wspFr , sizeof ( WSTR ) )
#define wsplen(wsp)         ( (*wsp).uiLen )


// Standard 'C' stuff

#define POW10(i)  powerof10 ( i )

// constructs borrowed from high level languages

#define beginSequence     do
#define endSequence       while ( 0 )

#define LowerCase(c)      ( (char) ( c | 0x20 ) )
#define UpperCase(c)      ( (char) ( c & 0xDF ) )
#define ToggleBit(l,b)    ( ( l & b ) ? ( l & ~b ) : ( l | b ) )


#ifdef _API_CLIPPER

  // this prevents MSC7 from calling _fld1
  // if you have MSC5.1, you can get rid of this and use the standard def

  #define INVERSE(v) ( (v) ? 2.0 / ( 2.0 * (v) ) : (v) )

#else

  #define INVERSE(v) ( (v) ? 1.0 / (v) : (v) )

#endif



/* Clipper Wrapper Definitions -------------------------------------------- */

#ifdef _API_CLIPPER

  typedef unsigned long size_p   ; // far pointers

  #define _GLOBAL_DEF

  #define _CLEANUP

  #define TRAP_ERR()    if ( ! IS_ERR_NONE ( ) ) vWError ( ) ;

  #define WSP


  extern  void _reta(quant) ;

  #define XBASE_NIL     UNDEF
  #define XBASE_CHAR    CHARACTER
  #define XBASE_BOOL    LOGICAL
  #define XBASE_INT     NUMERIC
  #define XBASE_LONG    NUMERIC
  #define XBASE_DOUBLE  NUMERIC
  #define XBASE_STRING  CHARACTER

  #define API_PARM    short iParm
  #define API_GRAB_C  cReturn = *_parc ( iParm ) ;
  #define API_GRAB_B  bReturn = (bool)  _parl  ( iParm ) ;
  #define API_GRAB_I  iReturn = (short) _parni ( iParm ) ;
  #define API_GRAB_L  lReturn = _parnl ( iParm ) ;
  #define API_GRAB_D  dReturn = _parnd ( iParm ) ;
  #define API_GRAB_S  { wsReturn.cp    = _parc ( iParm ) ; \
                        wsReturn.uiLen = (ushort) STRLEN ( wsReturn.cp ) ; \
                        wsReturn.ulHnd = 0L ; }

  #define PARMLIST    void
  #define PARMCOUNT   _parinfo(0)
  #define PARMTYPE(i) _parinfo(i)
  #define PARMMIN(i)  if i <= PARMCOUNT IS_ERR_COUNT ( )

  #define TYPE_C  CLIPPER
  #define TYPE_B  CLIPPER
  #define TYPE_I  CLIPPER
  #define TYPE_L  CLIPPER
  #define TYPE_D  CLIPPER
  #define TYPE_S  CLIPPER
  #define TYPE_D2 CLIPPER
  #define TYPE_D4 CLIPPER

  #define DECL_C(r)    char     r =         NIL_C 
  #define DECL_B(r)    bool     r =         NIL_B 
  #define DECL_I(r)    short    r =         NIL_I 
  #define DECL_L(r)    long     r =         NIL_L 
  #define DECL_D(r)    double   r =         NIL_D 
  #define DECL_S(r)    WSTR*    r = (WSTR*) NIL_G 
  #define DECL_D2(r)   D2*      r = (D2*)   NIL_G 
  #define DECL_D4(r)   D4*      r = (D4*)   NIL_G 

  #define PREP_C(n,p)                  char   p              
  #define PREP_B(n,p)                  bool   p              
  #define PREP_I(n,p)                  short  p              
  #define PREP_L(n,p)                  long   p              
  #define PREP_D(n,p)                  double p              
  #define PREP_S(n,p) WSTR wsBuff##n ; WSTR*  p = &wsBuff##n 

  #define GRAB_C(n,p) p =  cWGrab ( n ) 
  #define GRAB_B(n,p) p =  bWGrab ( n ) 
  #define GRAB_I(n,p) p =  iWGrab ( n ) 
  #define GRAB_L(n,p) p =  lWGrab ( n ) 
  #define GRAB_D(n,p) p =  dWGrab ( n ) 
  #define GRAB_S(n,p) wspcpy ( p , wspWGrab ( n ) )

  #define SEND_C(r)   _retc  ( ctosz ( r )   ) ; return 
  #define SEND_B(r)   _retl  ( (short) r     ) ; return 
  #define SEND_I(r)   _retni (         r     ) ; return 
  #define SEND_L(r)   _retnl (         r     ) ; return 
  #define SEND_D(r)   _retnd (         r     ) ; return 
  #define SEND_S(r)   _retc  (       (*r).cp ) ; return 

  #ifdef _API_CLIP4

    #define SEND_D2(r) _retc  ( stringify ( r , "dd"   ) ) ; return ;
    #define SEND_D4(r) _retc  ( stringify ( r , "dddd" ) ) ; return ;

    // Error generator
    extern void pascal IpErrEvent ( void ) ;

  #else

    #define SEND_D2(r) _reta  ( 2 ) ;                 \
                       if ( gpReturn ) {              \
                         _stornd ( r->d1 , -1 , 1 ) ; \
                         _stornd ( r->d2 , -1 , 2 ) ; \
                         } else {                     \
                         _stornd (   0.0 , -1 , 1 ) ; \
                         _stornd (   0.0 , -1 , 2 ) ; \
                         }                            \
                       return ;
    #define SEND_D4(r) _reta ( 4 ) ;                  \
                       if ( gpReturn ) {              \
                         _stornd ( r->d1 , -1 , 1 ) ; \
                         _stornd ( r->d2 , -1 , 2 ) ; \
                         _stornd ( r->d3 , -1 , 3 ) ; \
                         _stornd ( r->d4 , -1 , 4 ) ; \
                         } else {                     \
                         _stornd (   0.0 , -1 , 1 ) ; \
                         _stornd (   0.0 , -1 , 2 ) ; \
                         _stornd (   0.0 , -1 , 3 ) ; \
                         _stornd (   0.0 , -1 , 4 ) ; \
                         }                            \
                       return ;

  #endif


  // prototypes for parameter grabbers

  char     cWGrab ( API_PARM ) ;
  bool     bWGrab ( API_PARM ) ;
  short    iWGrab ( API_PARM ) ;
  long     lWGrab ( API_PARM ) ;
  double   dWGrab ( API_PARM ) ;
  WSTR*  wspWGrab ( API_PARM ) ;


  // low level file i/o

   short _topen   ( const char far * , short , ... ) ;
   short _tcreat  ( const char far * , short )       ;
  ushort _tread   ( short , char far * , ushort )    ;
  ushort _twrite  ( short , char far * , ushort )    ;
   ulong _tlseek  ( short , long , short )           ;
    void _tclose  ( short )                          ;
// short _txerror ( void )                           ;

  #define F_OPEN_RW(szPath)          _topen   ( szPath , 66 )
  #define F_OPEN_RO(szPath)          _topen   ( szPath , 64 )
  #define F_OPEN_WO(szPath)          _topen   ( szPath , 65 )
  #define F_CREATE(szPath)           _tcreat  ( szPath ,  0 )
  #define F_READ(iHnd,szBuff,uiLen)  _tread   ( iHnd , szBuff , uiLen )
  #define F_WRITE(iHnd,szBuff,uiLen) _twrite  ( iHnd , szBuff , uiLen )
  #define F_GOBOF(iHnd)              _tlseek  ( iHnd , 0L , SEEK_SET )
  #define F_GOEOF(iHnd)              _tlseek  ( iHnd , 0L , SEEK_END )
  #define F_GOTO(iHnd,lPosition)     _tlseek  ( iHnd , lPosition , SEEK_SET )
  #define F_GOBACK(iHnd,lPosition)   _tlseek  ( iHnd , -lPosition , SEEK_END )
  #define F_POS(iHnd)                _tlseek  ( iHnd , 0L , SEEK_CUR )
  #define F_MOVE(iHnd,lBytes)        _tlseek  ( iHnd , lBytes , SEEK_CUR )
  #define F_CLOSE(iHnd)              _tclose  ( iHnd )
  #define F_ERROR()                  0
//#define F_ERROR()                  _txerror ( )


/* ------------------------------------------------------------------------ *\

  WARNING: this method uses undocumented Clipper internals!

  Using LIB to generate a list file from CLIPPER.LIB yields the following
  list of functions found in a module named FILESYS.  Fortunately, the
  obviously recognizable functions follow the same prototype as their MSC
  low level IO counterparts.

  __dspace          __f_first         __f_next          __horror
  __tclose          __tcommit         __tcreat          __tctemp
  __tdevraw         __tend            __terror          __thcount
  __tinit           __tisdevice       __tlock           __tlseek
  __tmname          __topen           __tread           __trename
  __tunlink         __tversion        __twrite          __txaction
  __txclass         __txerror         __txlocus

\* ------------------------------------------------------------------------ */

  // The Clipper error object

  typedef struct {        // ERROR OBJECT
    ushort  uiSeverity  ;
    ushort  uiGenCode   ;
    ushort  uiOSCode    ;
    ushort  uiFlags     ;
    ushort  uiTries     ;
    ushort  uiSubCode   ;
    char   *szSubSystem ;
    char   *szDescript  ;
    char   *szOp        ;
    char   *szFileName  ;
  } ERR ;

  int _eError ( ERR * ) ;

  // buffer & string manipulation (MORE undocumented Clipper internals)

  char*  strcpy      ( char*, char* )           ;
  short  WStrcmp     ( char*, char* )           ;
  ushort strlen      ( char* )                  ;
  void*  _bcopy      ( void* , void* , ushort ) ;
  void*  _bcmp       ( void* , void* )          ;
  void*  _bset       ( void* , short , ushort ) ;

  #define STRCPY(szTo,szFr)              strcpy ( szTo , szFr  )
  #define STRCMP(sz1,sz2)               WStrcmp ( sz1  , sz2   )
  #define STRLEN(sz)                     strlen ( sz   )
  #define MEMCPY(vpTo,vpFr,uiLen)        _bcopy ( vpTo , vpFr  , uiLen )
  #define MEMCMP(vp1,vp2,uiLen)          _bcmp  ( vp1  , vp2   , uiLen )
  #define MEMSET(vpTo,iFill,uiLen)       _bset  ( vpTo , iFill , uiLen )

  #define ATOI(sz)                       sztoi  ( sz )
  #define ATOL(sz)                       sztol  ( sz )
  #define ATOF(sz)                       sztod  ( sz )
  #define ITOA(i,sz,r)                   strcpy ( sz , itosz  ( i  , r ) )
  #define LTOA(l,sz,r)                   strcpy ( sz , ltosz  ( l  , r ) )
  #define UTOA(ui,sz,r)                  strcpy ( sz , uitosz ( ui , r ) )
  #define ULTOA(ul,sz,r)                 strcpy ( sz , ultosz ( ul , r ) )
  #define FTOA(n,sz,d)                   strcpy ( sz , dtosz  ( (double) n , d ) )
  #define ROUND(n,d)                     round  ( (double) n , d )

#endif



/* FoxPro Wrapper Definitions --------------------------------------------- */



#ifdef _API_FOX

  void vErrTrapFox ( void ) ;

  typedef unsigned long size_p ; // far pointers

  #define _GLOBAL_DEF   void _fltused(){}

  #define _CLEANUP

  #define TRAP_ERR()    if ( ! IS_ERR_NONE ( ) ) vErrTrapFox ( ) ;

  #define WSP

  void far AUNSTRING ( ParamBlk* ) ;

  void _PutLong   ( long , short ) ;
  void _PutDouble ( double , short , short ) ;
  void _PutString ( WSTR* ) ;

    #ifdef _API_FPD20
  #define FOXRET while ( (*gpFoxParm).pCount ) \
                   if ( (*gpFoxParm).p[--(*gpFoxParm).pCount].val.ev_type == 'C' ) \
                     _HUnLock ( (*gpFoxParm).p[(*gpFoxParm).pCount].val.ev_handle ) ; \
                   return
    #else
  #define FOXRET return
    #endif


  #define XBASE_NIL     'U'
  #define XBASE_CHAR    'C'
  #define XBASE_BOOL    'L'
  #define XBASE_INT     'N'
  #define XBASE_LONG    'N'
  #define XBASE_DOUBLE  'N'
  #define XBASE_STRING  'C'

  #define API_PARM    short iParm , ParamBlk *gpFoxParm
  #define API_GRAB_C  cReturn = (char) ( ( (*gpFoxParm).p[iParm-1].val.ev_length ) \
                                  ? *((char*)_HandToPtr((*gpFoxParm).p[iParm-1].val.ev_handle)) \
                                  : '\0' ) ;
  #define API_GRAB_B  bReturn = (bool)   (*gpFoxParm).p[iParm-1].val.ev_length ;
    #ifdef _API_FPD20
  #define API_GRAB_I  iReturn = (short)  (*gpFoxParm).p[iParm-1].val.ev_long ;
  #define API_GRAB_L  lReturn =          (*gpFoxParm).p[iParm-1].val.ev_long ;
    #else
  #define API_GRAB_I  iReturn = (short)  (*gpFoxParm).p[iParm-1].val.ev_real ;
  #define API_GRAB_L  lReturn = (long)   (*gpFoxParm).p[iParm-1].val.ev_real ;
    #endif
  #define API_GRAB_D  dReturn = (double) (*gpFoxParm).p[iParm-1].val.ev_real ;
  #define API_GRAB_S  { wsReturn.cp    = (char*)  _HandToPtr((*gpFoxParm).p[iParm-1].val.ev_handle) ; \
                        wsReturn.uiLen = (ushort) (*gpFoxParm).p[iParm-1].val.ev_length ; \
                        wsReturn.ulHnd = (ulong)  (*gpFoxParm).p[iParm-1].val.ev_handle ; \
                        _HLock((*gpFoxParm).p[iParm-1].val.ev_handle) ; }

  // APIGRAB_S automatically _HLock()s the associated MHANDLE !!

  #define PARMLIST    ParamBlk *gpFoxParm
  #define PARMCOUNT   (*gpFoxParm).pCount
  #define PARMTYPE(i) (*gpFoxParm).p[i-1].val.ev_type
  #define PARMMIN(i)  if i <= PARMCOUNT IS_ERR_COUNT ( )

  #define TYPE_C  void FAR
  #define TYPE_B  void FAR
  #define TYPE_I  void FAR
  #define TYPE_L  void FAR
  #define TYPE_D  void FAR
  #define TYPE_S  void FAR
  #define TYPE_D4 void FAR
  #define TYPE_D2 void FAR

  #define DECL_C(r)  char   r =         NIL_C 
  #define DECL_B(r)  bool   r =         NIL_B 
  #define DECL_I(r)  short  r =         NIL_I 
  #define DECL_L(r)  long   r =         NIL_L 
  #define DECL_D(r)  double r =         NIL_D 
  #define DECL_S(r)  WSTR*  r = (WSTR*) NIL_G 
  #define DECL_D2(r) D2*    r = (D2*)   NIL_G 
  #define DECL_D4(r) D4*    r = (D4*)   NIL_G 

  #define PREP_C(n,p)                   char   p              
  #define PREP_B(n,p)                   bool   p              
  #define PREP_I(n,p)                   short  p              
  #define PREP_L(n,p)                   long   p              
  #define PREP_D(n,p)                   double p              
  #define PREP_S(n,p)  WSTR wsBuff##n ; WSTR*  p = &wsBuff##n 

  #define GRAB_C(n,p) p = cWGrab ( n , gpFoxParm ) 
  #define GRAB_B(n,p) p = bWGrab ( n , gpFoxParm ) 
  #define GRAB_I(n,p) p = iWGrab ( n , gpFoxParm ) 
  #define GRAB_L(n,p) p = lWGrab ( n , gpFoxParm ) 
  #define GRAB_D(n,p) p = dWGrab ( n , gpFoxParm ) 
  #define GRAB_S(n,p) wspcpy ( p , wspWGrab ( n , gpFoxParm ) ) 

  #define SEND_C(r)  _RetChar    ( ctosz ( r )        ) ; FOXRET
  #define SEND_B(r)  _RetLogical (   (int) r          ) ; FOXRET
  #define SEND_I(r)  _RetInt     (  (long) r ,  5     ) ; FOXRET
  #define SEND_L(r)  _RetInt     (         r , 10     ) ; FOXRET
  #define SEND_D(r)  _RetFloat   (         r , 12 , 4 ) ; FOXRET
  #define SEND_S(r)  _RetChar    ( r && (*r).cp ?           (*r).cp        : "" ) ; FOXRET
  #define SEND_D2(r) _RetChar    ( r            ? stringify ( r , "dd"   ) : "" ) ; FOXRET
  #define SEND_D4(r) _RetChar    ( r            ? stringify ( r , "dddd" ) : "" ) ; FOXRET

  // prototypes for parameter grabbers

  char     cWGrab ( API_PARM ) ;
  bool     bWGrab ( API_PARM ) ;
  short    iWGrab ( API_PARM ) ;
  long     lWGrab ( API_PARM ) ;
  double   dWGrab ( API_PARM ) ;
  WSTR  *wspWGrab ( API_PARM ) ;

  // low level file i/o

  #define F_OPEN_RW(szPath)          _FOpen   ( szPath , FO_READWRITE )
  #define F_OPEN_RO(szPath)          _FOpen   ( szPath , FO_READONLY )
  #define F_OPEN_WO(szPath)          _FOpen   ( szPath , FO_WRITEONLY )
  #define F_CREATE(szPath)           _FCreate ( szPath , FC_NORMAL )
  #define F_READ(iHnd,sBuff,uiLen)   _FRead   ( iHnd , sBuff , uiLen )
  #define F_WRITE(iHnd,sBuff,uiLen)  _FWrite  ( iHnd , sBuff , uiLen )
  #define F_GOBOF(iHnd)              _FSeek   ( iHnd , 0L , FS_FROMBOF )
  #define F_GOEOF(iHnd)              _FSeek   ( iHnd , 0L , FS_FROMEOF )
  #define F_GOTO(iHnd,lPosition)     _FSeek   ( iHnd , lPosition , FS_FROMBOF )
  #define F_GOBACK(iHnd,lPosition)   _FSeek   ( iHnd , -lPosition , FS_FROMEOF )
  #define F_POS(iHnd)                _FSeek   ( iHnd , 0L , FS_RELATIVE )
  #define F_MOVE(iHnd,lBytes)        _FSeek   ( iHnd , lBytes , FS_RELATIVE )
  #define F_CLOSE(iHnd)              _FClose  ( iHnd )
  #define F_ERROR()                  _FError  ( )

  // buffer & string manipulation

  #define STRCPY(szTo,szFr)          _StrCpy  ( szTo , szFr  )
  #define STRCMP(sz1,sz2)            _StrCmp  ( sz1  , sz2   )
  #define STRLEN(sz)                 _StrLen  ( sz   )
  #define MEMCPY(vpTo,vpFr,uiLen)    _MemMove ( vpTo , vpFr  , uiLen )
  #define MEMCMP(vp1, vp2,uiLen)     _MemCmp  ( vp1  , vp2   , uiLen )
  #define MEMSET(vpTo,iFill,uiLen)   _MemFill ( vpTo , iFill , uiLen )

  #define ATOI(sz)                   sztoi  ( sz )
  #define ATOL(sz)                   sztol  ( sz )
  #define ATOF(sz)                   sztod  ( sz )
  #define ITOA(i,sz,r)               _StrCpy ( sz , itosz  ( i  , r ) )
  #define LTOA(l,sz,r)               _StrCpy ( sz , ltosz  ( l  , r ) )
  #define UTOA(ui,sz,r)              _StrCpy ( sz , uitosz ( ui , r ) )
  #define ULTOA(ul,sz,r)             _StrCpy ( sz , ultosz ( ul , r ) )
  #define FTOA(n,sz,d)               _StrCpy ( sz , dtosz  ( (double) n , d ) )
  #define ROUND(n,d)                 round  ( (double) n , d )

#endif



/* Visual Basic for Dos Wrapper Definitions ------------------------------- */



#ifdef _API_VBD

  void vErrTrapVBD ( void ) ;

  typedef unsigned long  size_p ; // far pointers

  #define _GLOBAL_DEF char vbstr[4] ; short vbptr ;

  #define _CLEANUP    // if ( *(long*) vbstr ) StringRelease ( vbstr ) ;

  #define TRAP_ERR()  if ( ! IS_ERR_NONE ( ) ) vErrTrapVBD ( ) ;

  #define WSP         void far*

  #define TYPE_C  char   pascal
  #define TYPE_B  bool   pascal
  #define TYPE_I  short  pascal
  #define TYPE_L  long   pascal
  #define TYPE_D  double pascal
  #define TYPE_S  char*  pascal
  #define TYPE_D4 D4*    pascal
  #define TYPE_D2 D2*    pascal

  #define PARMLIST
  #define PARMCOUNT

  #define DECL_C(r)                   char     r             
  #define DECL_B(r)                   bool     r             
  #define DECL_I(r)                   short    r             
  #define DECL_L(r)                   long     r             
  #define DECL_D(r)                   double   r             
  #define DECL_S(r)   WSTR wsReturn ; WSTR*    r = &wsReturn 
  #define DECL_D2(r)                  D2*      r = NIL_G     ; char *sz 
  #define DECL_D4(r)                  D4*      r = NIL_G     ; char *sz 

  #define PREP_C(n,p) char   c##n
  #define PREP_B(n,p) bool   b##n
  #define PREP_I(n,p) short  i##n
  #define PREP_L(n,p) long   l##n
  #define PREP_D(n,p) double d##n
  #define PREP_S(n,p) WSTR wsBuff##n 

  #define GRAB_C(n,p)
  #define GRAB_B(n,p)
  #define GRAB_I(n,p)
  #define GRAB_L(n,p)
  #define GRAB_D(n,p)
  #define GRAB_S(n,p) wsBuff##n.cp    = StringAddress ( (char near*)(long) p ) ; \
                      wsBuff##n.uiLen = StringLength  ( (char near*)(long) p ) ; \
                      wsBuff##n.ulHnd = (long) p ; \
                      p = (char far*) &wsBuff##n 

  #define SEND_C(r)  return          r            
  #define SEND_B(r)  return (bool) ( r ? -1 : 0 ) 
  #define SEND_I(r)  return          r            
  #define SEND_L(r)  return          r            
  #define SEND_D(r)  return          r            
  #define SEND_S(r)  StringAssign ( (*r).cp , (*r).uiLen , vbstr , 0 ) ; \
                     return vbstr 
  #define SEND_D2(r) sz = stringify ( r , "dd"   ) ; \
                     StringAssign ( sz , STRLEN ( sz ) , vbstr , 0 ) ; \
                     return vbstr 
  #define SEND_D4(r) sz = stringify ( r , "dddd" ) ; \
                     StringAssign ( sz , STRLEN ( sz ) , vbstr , 0 ) ; \
                     return vbstr 

  // VBD string handler prototypes

  extern void  pascal StringAssign  ( char far* , short , char far* , short ) ;
  extern short pascal StringLength  ( char near* ) ;
  extern char* pascal StringAddress ( char near* ) ;
  extern char* pascal StringRelease ( char near* ) ;

  // Error generator (a VBD SUB procedure)

  extern void  pascal IpErrEvent    ( void ) ;

  // low level file i/o

  #define F_OPEN_RW(szPath)          open   ( szPath , O_RDWR   | O_BINARY )
  #define F_OPEN_RO(szPath)          open   ( szPath , O_RDONLY | O_BINARY )
  #define F_OPEN_WO(szPath)          open   ( szPath , O_WRONLY | O_BINARY )
  #define F_CREATE(szPath)           creat  ( szPath , S_IWRITE )
  #define F_READ(iHnd,szBuff,uiLen)  read   ( iHnd , szBuff , uiLen )
  #define F_WRITE(iHnd,szBuff,uiLen) write  ( iHnd , szBuff , uiLen )
  #define F_GOBOF(iHnd)              lseek  ( iHnd , 0L , SEEK_SET )
  #define F_GOEOF(iHnd)              lseek  ( iHnd , 0L , SEEK_END )
  #define F_GOTO(iHnd,lPosition)     lseek  ( iHnd , lPosition , SEEK_SET )
  #define F_GOBACK(iHnd,lPosition)   lseek  ( iHnd , -lPosition , SEEK_END )
  #define F_POS(iHnd)                lseek  ( iHnd , 0L , SEEK_CUR )
  #define F_MOVE(iHnd,lBytes)        lseek  ( iHnd , lBytes , SEEK_CUR )
  #define F_CLOSE(iHnd)              close  ( iHnd )
  #define F_ERROR()                  _doserrno

  // buffer & string manipulation

  #define STRCPY(szTo,szFr)          strcpy ( szTo , szFr  )
  #define STRCMP(sz1,sz2)            strcmp ( sz1  , sz2   )
  #define STRLEN(sz)                 strlen ( sz   )
  #define MEMCPY(vpTo,vpFr,uiLen)    memcpy ( vpTo , vpFr  , uiLen )
  #define MEMCMP(vp1, vp2,uiLen)     memcmp ( vp1  , vp2   , uiLen )
  #define MEMSET(vpTo,iFill,uiLen)   memset ( vpTo , iFill , uiLen )

  #define ATOI(sz)                   sztoi  ( sz )
  #define ATOL(sz)                   sztol  ( sz )
  #define ATOF(sz)                   sztod  ( sz )
  #define ITOA(i,sz,r)               strcpy ( sz , itosz  ( i  , r ) )
  #define LTOA(l,sz,r)               strcpy ( sz , ltosz  ( l  , r ) )
  #define UTOA(ui,sz,r)              strcpy ( sz , uitosz ( ui , r ) )
  #define ULTOA(ul,sz,r)             strcpy ( sz , ultosz ( ul , r ) )
  #define FTOA(n,d)                  strcpy ( sz , dtosz  ( (double) n , d ) )
  #define ROUND(n,d)                 round  ( (double) n , d )

#endif



/* Visual Basic for Windows Wrapper Definitions --------------------------- */



#ifdef _API_VBW

  void vErrTrapVBW ( void ) ;

  typedef unsigned long size_p ; // long pointers

  #define _GLOBAL_DEF   

  #define _CLEANUP

  #define TRAP_ERR()    if ( ! IS_ERR_NONE ( ) ) vErrTrapVBW ( ) ;

  #define WSP           void far*

  #define TYPE_C  char    _export
  #define TYPE_B  bool    _export
  #define TYPE_I  short   _export
  #define TYPE_L  long    _export
  #define TYPE_D  double  _export
  #define TYPE_S  char   *_export
  #define TYPE_D2 char   *_export
  #define TYPE_D4 char   *_export

  #define PARMLIST
  #define PARMCOUNT

  #define DECL_C(r)                   char   r             
  #define DECL_B(r)                   bool   r             
  #define DECL_I(r)                   short  r             
  #define DECL_L(r)                   long   r             
  #define DECL_D(r)                   double r             
  #define DECL_S(r)   WSTR wsReturn ; WSTR*  r = &wsReturn  
  #define DECL_D2(r)                  D2*    r = NIL_G     ; char *sz 
  #define DECL_D4(r)                  D4*    r = NIL_G     ; char *sz 

  #define PREP_C(n,p) char   c##n
  #define PREP_B(n,p) bool   b##n
  #define PREP_I(n,p) short  i##n
  #define PREP_L(n,p) long   l##n
  #define PREP_D(n,p) double d##n
  #define PREP_S(n,p) WSTR   wsBuff##n 

  #define GRAB_C(n,p)
  #define GRAB_B(n,p)
  #define GRAB_I(n,p)
  #define GRAB_L(n,p)
  #define GRAB_D(n,p)

  #define GRAB_S(n,p) wsBuff##n.cp    = ( p ) ; \
                      wsBuff##n.uiLen = (ushort) STRLEN ( wsBuff##n.cp ) ; \
                      wsBuff##n.ulHnd = (long) p ; \
                      p = &wsBuff##n 

/* ------------------------------------------------------------------------ *\

  Old method must be used if strings not prototyped as BYVAL!

  #define GRAB_S(n,p) wsBuff##n.cp     = VBDerefZeroTermHlstr ( p ) ; \
                      wsBuff##n.uiLen = (ushort) STRLEN ( wsBuff##n.cp ) ; \
                      wsBuff##n.ulHnd = (long) p ; \
                      p = &wsBuff##n ;

\* ------------------------------------------------------------------------ */

  #define SEND_C(r)  return          r            ;
  #define SEND_B(r)  return (bool) ( r ? -1 : 0 ) ;
  #define SEND_I(r)  return          r            ;
  #define SEND_L(r)  return          r            ;
  #define SEND_D(r)  return          r            ;
  #define SEND_S(r)  return   VBCreateTempHlstr ( (*r).cp , (*r).uiLen ) ;
  #define SEND_D2(r) sz = stringify ( r , "dd"   ) ; return VBCreateTempHlstr ( sz , STRLEN ( sz ) ) ;
  #define SEND_D4(r) sz = stringify ( r , "dddd" ) ; return VBCreateTempHlstr ( sz , STRLEN ( sz ) ) ;

  // low level file i/o

  #define F_OPEN_RW(szPath)          open   ( szPath , O_RDWR | O_BINARY )
  #define F_OPEN_RO(szPath)          open   ( szPath , O_RDONLY | O_BINARY )
  #define F_OPEN_WO(szPath)          open   ( szPath , O_WRONLY | O_BINARY )
  #define F_CREATE(szPath)           creat  ( szPath , S_IWRITE )
  #define F_READ(iHnd,szBuff,uiLen)  read   ( iHnd , szBuff , uiLen )
  #define F_WRITE(iHnd,szBuff,uiLen) write  ( iHnd , szBuff , uiLen )
  #define F_GOBOF(iHnd)              lseek  ( iHnd , 0L , SEEK_SET )
  #define F_GOEOF(iHnd)              lseek  ( iHnd , 0L , SEEK_END )
  #define F_GOTO(iHnd,lPosition)     lseek  ( iHnd , lPosition , SEEK_SET )
  #define F_GOBACK(iHnd,lPosition)   lseek  ( iHnd , -lPosition , SEEK_END )
  #define F_POS(iHnd)                lseek  ( iHnd , 0L , SEEK_CUR )
  #define F_MOVE(iHnd,lBytes)        lseek  ( iHnd , lBytes , SEEK_CUR )
  #define F_CLOSE(iHnd)              close  ( iHnd )
  #define F_ERROR()                  _doserrno

  // buffer & string manipulation

  #define STRCPY(szTo,szFr)          strcpy ( szTo , szFr  )
  #define STRCMP(sz1,sz2)            strcmp ( sz1  , sz2   )
  #define STRLEN(sz)                 ( *sz ? strlen ( sz ) : 0 )
  #define MEMCPY(vpTo,vpFr,uiLen)    memcpy ( vpTo , vpFr  , uiLen )
  #define MEMCMP(vp1, vp2,uiLen)     memcmp ( vp1  , vp2   , uiLen )
  #define MEMSET(vpTo,iFill,uiLen)   memset ( vpTo , iFill , uiLen )

  #define ATOI(sz)                   atoi  ( sz )
  #define ATOL(sz)                   atol  ( sz )
  #define ATOF(sz)                   atof  ( sz )
  #define ITOA(i,sz,r)               itoa  ( i  , sz , r )
  #define LTOA(l,sz,r)               ltoa  ( l  , sz , r )
  #define UTOA(ui,sz,r)              utoa  ( ui , sz , r )
  #define ULTOA(ul,sz,r)             ultoa ( ul , sz , r )
  #define FTOA(n,sz,d)               strcpy ( sz , dtosz  ( (double) n , d ) )
  #define ROUND(n,d)                 round  ( (double) n , d )

#endif



/* C Wrapper Definitions -------------------------------------------------- */



#ifdef _API_C

  void vErrTrapC ( void ) ;

  typedef unsigned long size_p ; // far pointers

  #define _GLOBAL_DEF

  #define _CLEANUP

  #define TRAP_ERR()   if ( ( ! IS_ERR_NONE ( ) ) ) vErrTrapC ( ) ;

  #define WSP          void far*

	#ifdef _FAMILY_DLL

		#define TYPE_C  char    PASCAL     _export
    #define TYPE_B  bool    PASCAL     _export
    #define TYPE_I  short   PASCAL     _export
    #define TYPE_L  long    PASCAL     _export
    #define TYPE_D  double  PASCAL     _export
    #define TYPE_S  char*   PASCAL far _export
    #define TYPE_D2 D2*     PASCAL far _export
    #define TYPE_D4 D4*     PASCAL far _export

	#else

    #define TYPE_C  char
    #define TYPE_B  bool
    #define TYPE_I  short
    #define TYPE_L  long
    #define TYPE_D  double
    #define TYPE_S  char*
    #define TYPE_D4 D4*
    #define TYPE_D2 D2*

	#endif

  #define PARMLIST
  #define PARMCOUNT

  #define DECL_C(r)                   char   r             
  #define DECL_B(r)                   bool   r             
  #define DECL_I(r)                   short  r             
  #define DECL_L(r)                   long   r             
  #define DECL_D(r)                   double r             
  #define DECL_S(r)   WSTR wsReturn ; WSTR*  r = &wsReturn 
  #define DECL_D4(r)                  D4*    r = NIL_G     
  #define DECL_D2(r)                  D2*    r = NIL_G     

  #define PREP_C(n,p) char   c##n
  #define PREP_B(n,p) bool   b##n
  #define PREP_I(n,p) short  i##n
  #define PREP_L(n,p) long   l##n
  #define PREP_D(n,p) double d##n
  #define PREP_S(n,p) WSTR wsBuff##n

  #define GRAB_C(n,p) 
  #define GRAB_B(n,p) 
  #define GRAB_I(n,p) 
  #define GRAB_L(n,p) 
  #define GRAB_D(n,p) 
  #define GRAB_S(n,p) if ( p == NULL ) { \
                         wsBuff##n.cp    = NIL_S ; \
                         wsBuff##n.uiLen = (ushort) 1 ; } \
                       else { \
                         wsBuff##n.cp    = (char*) p ; \
                         wsBuff##n.uiLen = (ushort) STRLEN ( wsBuff##n.cp ) ; } \
                       wsBuff##n.ulHnd = 0L ; \
                       p = &wsBuff##n ;

  #define SEND_C(r)  return   r     ;
  #define SEND_B(r)  return   r     ;
  #define SEND_I(r)  return   r     ;
  #define SEND_L(r)  return   r     ;
  #define SEND_D(r)  return   r     ;
  #define SEND_S(r)  return (*r).cp ;
  #define SEND_D2(r) return   r     ;
  #define SEND_D4(r) return   r     ;


/* ------------------------------------------------------------------------ *\

   C passes parameters directly, therefore TYPE_S parameters are actually
   passed as char*.  Unfortunately, the wrapper->core interface requires
   that strings be passed as WSTR*.  To handle this transparently, the
   PREP_S() macro translates to a declaration of a unique WSTR buffer
   and GRAB_S() recastes the void* to a WSTR* after first pointing the
   WSTR buffer at the string.  For example:

  Macro             | Translation                    | Meaning
  ==================*================================*======================
  PREP_S(3,wspText) | WSTR wsBuff3;                  | declare a WSTR buffer
  ------------------+--------------------------------+----------------------
  GRAB_S(3,wspText) | wsBuff3.cp = wspText ;         | point buff to string
                    | ((WSTR*)wspText) = &wsBuff3 ;  | re-point/caste void*
                    |                                | as a WSTR* to buff

   Notice how the ## directive is used to glue two tokens together
   creating a unique variable name.

   This may seem a little wierd, but it is the only way to satisfy a single
   source translation to any of the supported APIs, including C.

\* ------------------------------------------------------------------------ */

  // low level file i/o

  #define F_OPEN_RW(szPath)          open   ( szPath , O_RDWR | O_BINARY )
  #define F_OPEN_RO(szPath)          open   ( szPath , O_RDONLY | O_BINARY )
  #define F_OPEN_WO(szPath)          open   ( szPath , O_WRONLY | O_BINARY )
  #define F_CREATE(szPath)           creat  ( szPath , S_IWRITE )
  #define F_READ(iHnd,szBuff,uiLen)  read   ( iHnd , szBuff , uiLen )
  #define F_WRITE(iHnd,szBuff,uiLen) write  ( iHnd , szBuff , uiLen )
  #define F_GOBOF(iHnd)              lseek  ( iHnd , 0L , SEEK_SET )
  #define F_GOEOF(iHnd)              lseek  ( iHnd , 0L , SEEK_END )
  #define F_GOTO(iHnd,lPosition)     lseek  ( iHnd , lPosition , SEEK_SET )
  #define F_GOBACK(iHnd,lPosition)   lseek  ( iHnd , -lPosition , SEEK_END )
  #define F_POS(iHnd)                lseek  ( iHnd , 0L , SEEK_CUR )
  #define F_MOVE(iHnd,lBytes)        lseek  ( iHnd , lBytes , SEEK_CUR )
  #define F_CLOSE(iHnd)              close  ( iHnd )
  #define F_ERROR()                  _doserrno

  // buffer & string manipulation

  #define STRCPY(szTo,szFr)          strcpy ( szTo , szFr  )
  #define STRCMP(sz1,sz2)            strcmp ( sz1  , sz2   )
  #define STRLEN(sz)                 strlen ( sz   )
  #define MEMCPY(vpTo,vpFr,uiLen)    memcpy ( vpTo , vpFr  , uiLen )
  #define MEMCMP(vp1, vp2,uiLen)     memcmp ( vp1  , vp2   , uiLen )
  #define MEMSET(vpTo,iFill,uiLen)   memset ( vpTo , iFill , uiLen )

  #define ATOI(sz)                   atoi  ( sz )
  #define ATOL(sz)                   atol  ( sz )
  #define ATOF(sz)                   atof  ( sz )
  #define ITOA(i,sz,r)               itoa  ( i  , sz , r )
  #define LTOA(l,sz,r)               ltoa  ( l  , sz , r )
  #define UTOA(ui,sz,r)              utoa  ( ui , sz , r )
  #define ULTOA(ul,sz,r)             ultoa ( ul , sz , r )
  #define FTOA(n,sz,d)               strcpy ( sz , dtosz  ( (double) n , d ) )
  #define ROUND(n,d)                 round  ( (double) n , d )

  #ifdef _FAMILY_DLL                 // protects against dumb GPFs
    #undef  STRLEN
    #define STRLEN(sz)               ( *sz ? strlen ( sz ) : 0 )
  #endif


#endif



/* End-of-File ------------------------------------------------------------ */

