/* ------------------------------------------------------------------------ *\
|                                                                            |
|  CORE.C    | <AppName> core functions                                      |
|            |                                                               |
|            |                                                               |
|            |                                                               |
|            | ------------------------------------------------------------  |
|            |                                                               |
|            | File        Purpose                                           |
|            | ----        -------                                           |
|            | wrapi.c     wrapped-API support                               |
|            | wrapi.h     wrapped-API defintions                            |
|            | core.c      core functions                                    |
|            | core.h      core definitions                                  |
|            | export.h    definitions for all files                         |
|            | fox.h       FoxInfo defintion                                 |
|            |                                                               |
|            | ------------------------------------------------------------  |
|            |                                                               |
|            |   Developer:                                                  |
|            |                                                               |
|            |                                                               |
|            | ------------------------------------------------------------  |
|            |                                                               |
|            | Hungarian conventions                                         |
|            | ---------------------                                         |
|            | c   - single character                                        |
|            | i   - short integer ( 2 bytes )                               |
|            | b   - boolean short                                           |
|            | l   - long integer ( 4 bytes )                                |
|            | d   - double precision ( 8 bytes )                            |
|            | p   - pointer                                                 |
|            | g   - structure ( [g]roup of elements )                       |
|            | j   - union ( [j]oined elements )                             |
|            | u   - unsigned                                                |
|            | v   - void                                                    |
|            | sz  - string pointer ( zero terminated )                      |
|            | sza - string pointer ( declared as char array , zero term.)   |
|            | ws  - WSTR ( hybrid string structure )                        |
|            |                                                               |
|                                                                            |
\* ------------------------------------------------------------------------ */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <io.h>

#include "wrapi.h"
#include "export.h"
#include "core.h"
#include "fox.h"


// Global definitions from WRAPI

_GLOBAL_DEF


// Global error definitions

static ERRDEF  gXXErr ;

static char    szaXXErrText [EC_MAX] [EC_LEN] =

               {
                   { "successful"                               }
                 , { "demo limit has been exceeded"             }
                 , { "unable to write to print device"          }
                 , { "unable to call error handler"             }
                 , { "internal error (GET/SET handle)"          }
                 , { "internal error (C data type in GET/SET)"  }
                 , { "parameter is out of range "               }
                 , { "parameter is invalid data type"           }
                 , { "invalid parameter count"                  }
                 , { "error code is invalid"                    }
                 , { "unable to allocate memory from API"       }
                 , { "unable to get HDC for windows printing"   }
                 , { "unable to execute GDI command"            }
                 , { "unable to open named file"                }
               } ;


// Other global definitions


                     /* PUT YOUR GLOBALS HERE! */



/* Error wrappers --------------------------------------------------------- */



TYPE_I XXErrCode ( PARMLIST ) { // ( [iErrCode] )

  DECL_I ( iReturn ) ;

  PREP_I ( 1 , iErrCode ) ;

  GRAB_I ( 1 , iErrCode ) ;

  iReturn = _iXXErrCode ( iErrCode ) ;

  SEND_I ( iReturn ) ;

  }



TYPE_S XXErrLoc  ( PARMLIST ) { // ( [wspErrLoc] )

  DECL_S ( wspReturn ) ;

  PREP_S ( 1 , wspErrLoc ) ;

  SET_ERR_NONE ( ) ;

  GRAB_S ( 1 , wspErrLoc ) ;

  if ( IS_ERR_NONE ( ) ) wspReturn = _wspXXErrLoc ( (WSTR*) wspErrLoc ) ;

  if ( ! ( IS_ERR_NONE ( ) ) ) SET_ERR_LOC ( "XXErrLoc" ) ;

  TRAP_ERR ( ) ;

  SEND_S ( wspReturn ) ;

  }



TYPE_S XXErrText ( PARMLIST ) { // ( [iErrCode] , [wspErrText] )

  DECL_S ( wspReturn ) ;

  PREP_I ( 1 , iErrCode   ) ;
  PREP_S ( 2 , wspErrText ) ;

  SET_ERR_NONE ( ) ;

  GRAB_I ( 1 , iErrCode   ) ;
  GRAB_S ( 2 , wspErrText ) ;

  if ( IS_ERR_NONE ( ) ) wspReturn = _wspXXErrText ( iErrCode , (WSTR*) wspErrText ) ;

  SET_ERR_LOC ( "XXErrText" ) ;

  TRAP_ERR ( ) ;

  SEND_S ( wspReturn ) ;

  }



TYPE_I XXErrHost ( PARMLIST ) { // ( [iErrHost] )

  DECL_I ( iReturn ) ;

  PREP_I ( 1 , iErrHost ) ;

  GRAB_I ( 1 , iErrHost ) ;

  iReturn = _iXXErrHost ( iErrHost ) ;

  SEND_I ( iReturn ) ;

  }



TYPE_L XXErrFPtr ( PARMLIST ) { // ( [lFuncPtr] )

  DECL_L ( lReturn ) ;

  PREP_L ( 1 , lFuncPtr ) ;
  
  SET_ERR_NONE ( ) ;

  GRAB_L ( 1 , lFuncPtr ) ;

  if ( IS_ERR_NONE ( ) ) lReturn = GETSET_L ( HND_ERR_FPTR , lFuncPtr ) ;

  SET_ERR_LOC ( "XXErrFPtr" ) ;

  TRAP_ERR ( ) ;

  SEND_L ( lReturn ) ;

   
  }



TYPE_S XXErrFName ( PARMLIST ) { // ( [wspFuncName] )

  DECL_S ( wspReturn ) ;

  PREP_S ( 1 , wspFuncName ) ;

  SET_ERR_NONE ( ) ;

  GRAB_S ( 1 , wspFuncName ) ;

  if ( IS_ERR_NONE ( ) ) wspReturn = GETSET_S ( HND_ERR_FNAME , wspFuncName ) ;

  SET_ERR_LOC ( "XXErrText" ) ;

  TRAP_ERR ( ) ;

  SEND_S ( wspReturn ) ;

  }



TYPE_I XXErrQOS ( PARMLIST ) { // ( )

  DECL_I ( iReturn ) ;

  SET_ERR_NONE ( ) ;

  iReturn = _iXXErrQOS ( ) ;

  SEND_I ( iReturn ) ;

  }



/* Error core ------------------------------------------------------------- */



short _iXXErrCode ( short iErrCode ) {

  short iReturn = gXXErr.iCode ;

  if ( iErrCode != NIL_I )
    if IS_RANGE ( iErrCode , EC_NONE , EC_MAX )
      gXXErr.iCode = iErrCode ;
    else
      gXXErr.iCode = EC_EC ;

  return iReturn ;

  }



short _iXXErrHost ( short iErrHost ) {

  short iReturn = gXXErr.iHost ;

  if ( iErrHost != NIL_I )
    gXXErr.iHost = iErrHost ;

  return iReturn ;

  }



WSTR* _wspXXErrLoc ( WSTR* wspErrLoc ) {

  static char szaReturn[sizeof(gXXErr.szaLoc)] ;
  static WSTR wsReturn ;

  wsReturn.cp = szaReturn ;

  swzcpy ( &wsReturn , gXXErr.szaLoc ) ;

  if ( ! IsWNIL ( wspErrLoc ) )
    szwncpy ( gXXErr.szaLoc , wspErrLoc , sizeof(gXXErr.szaLoc) ) ;

  return &wsReturn ;

  }



WSTR* _wspXXErrText ( short iErrCode , WSTR* wspErrText ) {

  static char szaReturn[EC_LEN] ;
  static WSTR wsReturn ;

  if (iErrCode == NIL_I )
    iErrCode = gXXErr.iCode ;

  wsReturn.cp =  szaReturn ;

  swzcpy ( &wsReturn , szaXXErrText[iErrCode] ) ;

  if ( ! IsWNIL ( wspErrText ) )
    szwncpy ( szaXXErrText[iErrCode] , wspErrText , EC_LEN ) ;

  return &wsReturn ;

  }



char* _szXXErrMsg ( void ) {

  static char szaReturn[80] ; char *cp = szaReturn ;

  szfill ( &cp , "[<AppName>] " ) ;
  szfill ( &cp , gXXErr.szaLoc ) ;
  szfill ( &cp , "() : " ) ;
  szfill ( &cp , szaXXErrText[gXXErr.iCode] ) ;

  return szaReturn ;

  }



short _iXXErrQOS ( void ) {

  return gXXErr.iOS ;

  }



/* GET/SET engine --------------------------------------------------------- */


void* _vpXXGetSet ( short iHandle , void *vpSet ) {

  static  char szaChar[64]             ; // 64 byte buffer for returning char
  static  char szaReturn[sizeof(WSTR)] ; // <n> byte buffer for return values
  void   *vpGet = szaReturn            ; // pointer to return value
  bool    bIsNew = 0                   ; // flags new (SET) values
  void    (*vpFunc)() = NULL           ; // function ptr
  double  dUnits                       ; // for converting units in/out

  char      cNew =         NIL_C ,   *cpOld ;
  bool      bNew =         NIL_B ,   *bpOld ;
  short     iNew =         NIL_I ,   *ipOld ;
  long      lNew =         NIL_L ,   *lpOld ;
  double    dNew =         NIL_D ,   *dpOld ;
  WSTR   *wspNew = (WSTR*) NIL_G ,    wsOld ;

  short   iCtype = (short) ( iHandle & GET_CTYPE ) ; // strip C data type

  switch ( iCtype ) { 

    default : gXXErr.iCode = EC_GSCTYPE ; break ;

    case CTYPE_C :  // char

      if ( vpSet ) cNew = *((char*)vpSet) ; bIsNew = (bool) (cNew != NIL_C) ;

      switch ( iHandle ) { default : gXXErr.iCode = EC_GSVALUE  ; break ;

//      case HND_????         : cpOld = &(g????.c????)        ; break ;

        }

      GETSET ( cpOld , cNew )

      break ;

    case CTYPE_B :  // bool

      if ( vpSet ) bNew = *((bool*)vpSet) ; bIsNew = (bool) (bNew != NIL_B) ;

      switch ( iHandle ) { default : gXXErr.iCode = EC_GSVALUE ; break ;

//      case HND_????           : bpOld = &(g????.b????) ; break ;

        }

      GETSET ( bpOld , bNew )

      break ;

    case CTYPE_I :  // short

      if ( vpSet ) iNew = *((short*)vpSet) ; bIsNew = (bool) (iNew != NIL_I) ;

      switch ( iHandle ) { default : gXXErr.iCode = EC_GSVALUE ; break ;

//      case HND_????         : ipOld = &(g????.i????) ;
//
//        CHECK_ARG_RANGE ( IS_RANGE ( iNew , MIN_CONST_1 , MAX_CONST_1 ) )
//        break ;

        }

      GETSET ( ipOld , iNew )

      break ;

    case CTYPE_L :  // long

      if ( vpSet ) lNew = *((long*)vpSet) ; bIsNew = (bool) (lNew != NIL_L) ;

      switch ( iHandle ) { default : gXXErr.iCode = EC_GSVALUE ; break ;

//      case HND_????           : lpOld = &(g????.l????) ;
// 
//        CHECK_ARG_RANGE ( IS_RANGE ( lNew , 0 , 0xFFFFL ) )
//        break ;

        case HND_ERR_FPTR       : lpOld = &(gXXErr.lFPtr) ;

          break ;

        }

      GETSET ( lpOld , lNew )

      break ;

    case CTYPE_D :  // double

      if ( vpSet ) dNew = *((double*)vpSet) ; bIsNew = (bool) (dNew != NIL_D) ;

      dUnits = 0.0 ;

      switch ( iHandle ) { default : gXXErr.iCode = EC_GSVALUE ; break ;

//      case HND_????          : dpOld = &(g????.d????) ;
//
//        CHECK_ARG_RANGE ( IS_GTE_ZERO ( dNew ) )
//        break ;

        }

      GETSET ( dpOld , dNew )

      break ;

    case CTYPE_S :  // char*

      if ( vpSet ) wspNew = (WSTR*) vpSet ; bIsNew = (bool) ! IsWNIL ( wspNew ) ;

      (*(WSTR*)vpGet).cp = szaChar ;

      switch ( iHandle ) { default : gXXErr.iCode = EC_GSVALUE ; break ;

        case HND_ERR_FNAME   : wsOld.uiLen = (ushort) sizeof ( gXXErr.szaFName ) ;
                               wsOld.cp    = gXXErr.szaFName ;
                               break ;

        }

      if ( gXXErr.iCode == EC_GSVALUE ) {
        *(*(WSTR*)vpGet).cp    = '0' ;
         (*(WSTR*)vpGet).uiLen =  (ushort) 0  ;
        }
      else {
        swzcpy ( ((WSTR*)vpGet) , wsOld.cp ) ;
        if ( bIsNew && !gXXErr.iCode )
          szwncpy ( wsOld.cp , wspNew , wsOld.uiLen ) ;
        }

      break ;

    }

  return vpGet ;

  }



/* End-of-file ------------------------------------------------------------ */

