#
#   WRAPI make file prototype (uses NMAKE syntax)
#

BUILD   = $(APIDRV):\$(APIAPP)\build\$(API)

DEPENDS = $(BUILD)\core.obj
DEPENDS = $(DEPENDS) $(BUILD)\wrapi.obj

# Add your OBJ files here...  (e.g. DEPENDS = $(DEPENDS) $(BUILD)\myfile.obj)






!IF "$(API)"=="CLIP4"
DEPENDS = $(BUILD)\errclip4.obj $(DEPENDS)
!ENDIF

!IF "$(API)"=="VBD"
DEPENDS = $(BUILD)\errvbd.obj $(DEPENDS)
!ENDIF

LIBNAME = $(APIAPP)$(API)
LIBEXT  = $(_LIBEXT)

CC      = $(_CC)
MMODEL  = $(_MMODEL)
CFLAGS  = $(_CFLAGS)
LINKER  = $(_LINKER)
LFLAGS  = $(_LFLAGS)

!IF "$(APIMODE)"=="DBG"
!IF "$(_LDEBUG)"!=""
LFLAGS  = $(LFLAGS) $(_LDEBUG)
!ENDIF
!ENDIF

INCLUDES= $(_INCLUDES)
FILE2OBJ= $(_FILE2OBJ)
OBJS    = $(DEPENDS)
DEFS    = 

!IF "$(_DEFS)"!=""
DEFS    = $(_DEFS)
!ENDIF

!IF "$(_OBJS)"!=""
OBJS    = $(_OBJS) $(DEPENDS)
!ENDIF
LIBS    = $(_LIBS)

MAPFILE = NUL
#MAPFILE = $(APIAPP)  # uncomment for MAP file

.SUFFIXES : .prg

all: $(BUILD)\$(LIBNAME).$(LIBEXT)

!IF "$(API)"=="CLIP4"
{.}.prg{$(BUILD)}.obj:
  clipper $< -l -m -o$(@D)
!ENDIF

!IF "$(API)"=="VBD"
{.}.bas{$(BUILD)}.obj:
  vbc /FPa /Zi /O $< $(@R) NUL ;
!ENDIF

{.}.c{$(BUILD)}.obj:
  $(CC) $(CFLAGS) $(FILE2OBJ)$*.obj $<

.obj{$(BUILD)}.$(LIBEXT):

$(BUILD)\$(LIBNAME).$(LIBEXT) : $(DEPENDS)
!IF "$(LIBEXT)"=="lib"
  del $@
  echo > NUL @<<$(LIBNAME).lrf
$@
y
+$(OBJS: = &^
+)
NUL ;
<<
  $(LINKER) @$(LIBNAME).lrf
!IF "$(API)"=="VBD"
    link /Q /SE:1024 $@ , $(@R).qlb , , vbdosqlb , NUL ;
!ENDIF
!ELSE
  echo > NUL @<<$(LIBNAME).lrf
$(OBJS: = +^
)
$@
$(MAPFILE)
$(LIBS: = +^
)
$(DEFS) $(LFLAGS)
<<
  $(LINKER) @$(LIBNAME).lrf
!ENDIF

!IF "$(DEFS)"!=""
  implib $(BUILD)\$(LIBNAME).lib $(BUILD)\$(LIBNAME).$(LIBEXT)
  copy $(BUILD)\$(LIBNAME).lib       $(APIDRV):\windows\system\.
  copy $(BUILD)\$(LIBNAME).$(LIBEXT) $(APIDRV):\windows\system\.
!ENDIF
