/*
Orbit diagram of quadratic function
Lee F. Holeva
12/6/93
*/
// display a DOS window
#define WIN31
#define TEXTBUFSIZE 100
#include <owl.h>
#include <iostream.h>

#pragma argsused

double lower, upper;			// lower and upper limits on the parameter

/*
Derived Window application class
*/
class TLeesWinAppl : public TApplication{
public:
	TLeesWinAppl(LPSTR AName, HANDLE hInstance, HANDLE hPrevInstance,
	LPSTR lpCmdLine, int nCmdShow) : TApplication(AName, hInstance,
	hPrevInstance, lpCmdLine, nCmdShow){}
	virtual void InitMainWindow();
};

/*
Derived Window class
*/
class TLeesWin : public TWindow{
public:
	TLeesWin(PTWindowsObject AParent, LPSTR ATitle)
	: TWindow(AParent, ATitle){}

	/*
	This function gets called to display graphics in the window
	*/
	virtual void Paint(HDC hDC, PAINTSTRUCT&);
};

/*
Graphics code goes here:
Iterate the function: x*x + c
*/
void TLeesWin::Paint(HDC hDC, PAINTSTRUCT&)
{
	int i,j,x,y,width,height;
	double rate, func, c;

	/* get the screen size */
	width=GetDeviceCaps(hDC, HORZRES);
	height=GetDeviceCaps(hDC, VERTRES);
	cout << "Screen width = " << width << "\n";
	cout << "Screen height = " << height << "\n";

	/* Plot an orbit diagram */
	rate = (upper - lower)/(double)width;
	for(i=0;i<width;i++){

		func=0.0;
		c=rate*i + lower;
		x=(int)((width-1.0)*(c - lower)/(upper - lower));
		for(j=0;j<200;j++){

			/* function to be iterated */
			func = func*func + c;
			if(j > 49){
				y=(int)(-150.0*(lower + func));
				/* check window bounds */
				if(x >= 0 && y >= 0 &&
			   	x < width && y < height)
					SetPixel(hDC, x, y, RGB(0, 0, 255));
			}
		}
        }

}

/*
Windows application code goes here
*/
void TLeesWinAppl::InitMainWindow()
{
	TLeesWin *leeswinp;

	leeswinp=new TLeesWin(NULL, "Lee's Graphics Window");			// Create a new window
	MainWindow=leeswinp;

}

/*
Main window routine
*/
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
			LPSTR lpCmdLine, int nCmdShow)
{
	char text_buf[TEXTBUFSIZE];
	TLeesWinAppl LeesAppl("Lees Window Application", hInstance,
	hPrevInstance, lpCmdLine, nCmdShow);

	_InitEasyWin();		       // Enable DOS I/O for the window

	/* get the x axis limits */
	cout << "x axis limits must be between -2.0 and 0.25\n";
	cout << "Lower limit = ";
	cin >> lower;
	cout << "upper limit = ";
	cin >> upper;

        LeesAppl.Run();			// Run the Windows application
	return LeesAppl.Status;
}
