/*
Sierpinski triangle fractal generation
Lee F. Holeva
12/6/93
*/
// display a DOS window
#define WIN31

#include <stdlib.h>
#include <time.h>
#include <owl.h>
#include <iostream.h>

#pragma argsused

int n, m;			// Coordinates of the initial point

/*
Derived Window application class
*/
class TLeesWinAppl : public TApplication{
public:
	TLeesWinAppl(LPSTR AName, HANDLE hInstance, HANDLE hPrevInstance,
	LPSTR lpCmdLine, int nCmdShow) : TApplication(AName, hInstance,
	hPrevInstance, lpCmdLine, nCmdShow){}
	virtual void InitMainWindow();
};

/*
Derived Window class
*/
class TLeesWin : public TWindow{
public:
	TLeesWin(PTWindowsObject AParent, LPSTR ATitle)
	: TWindow(AParent, ATitle){}

	/*
	This function gets called to display graphics in the window
	*/
	virtual void Paint(HDC hDC, PAINTSTRUCT&);
};

/*
Graphics code goes here:
Construct a Sierpinski triangle
*/
void TLeesWin::Paint(HDC hDC, PAINTSTRUCT&)
{
	long int i, num;
	int j,width,height;

	/* get the screen size */
	width=GetDeviceCaps(hDC, HORZRES);
	height=GetDeviceCaps(hDC, VERTRES);
	cout << "Screen width = " << width << "\n";
	cout << "Screen height = " << height << "\n";

	if(height > width)num = (long)height*(long)height;
	else num = (long)width*(long)width;
        /* generate random iterates of the midpoint function */
	for(i=0;i<num;i++){

		j = random(3);
		switch(j){
		case 0:
			m = m/2;
			n = (n + height - 1)/2;
			break;
		case 1:
			m = (m + width/2 - 1)/2;
			n = n/2;
			break;
		case 2:
			m = (m + width - 1)/2;
			n = (n + height - 1)/2;
			break;
		}
		/* plot the attractor */
		if(i >= 1000)SetPixel(hDC, m, n, RGB(255, 0, 255));
        }
}

/*
Windows application code goes here
*/
void TLeesWinAppl::InitMainWindow()
{
	TLeesWin *leeswinp;

	leeswinp=new TLeesWin(NULL, "Lee's Graphics Window");			// Create a new window
	MainWindow=leeswinp;

}

/*
Main window routine
*/
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
			LPSTR lpCmdLine, int nCmdShow)
{
	TLeesWinAppl LeesAppl("Lees Window Application", hInstance,
	hPrevInstance, lpCmdLine, nCmdShow);

	_InitEasyWin();		       // Enable DOS I/O for the window

	randomize();
	/* get a pair of integers */
	cout << "initial x coordinate = ";
	cin >> m;
	cout << "initial y coordinate = ";
	cin >> n;

        LeesAppl.Run();			// Run the Windows application
	return LeesAppl.Status;
}
