/*
Koch Showflake fractal generation
Lee F. Holeva
12/14/93
*/
// display a DOS window
#define WIN31

#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <owl.h>
#include <iostream.h>

#pragma argsused

/*
Definition of polygon vertex
*/
typedef struct vertex{
	int x,y;
	struct vertex *next;
}poly_vertex;

double insert(HDC, poly_vertex *, poly_vertex *);

int width,height;					// Screen width and height

/*
Derived Window application class
*/
class TLeesWinAppl : public TApplication{
public:
	TLeesWinAppl(LPSTR AName, HANDLE hInstance, HANDLE hPrevInstance,
	LPSTR lpCmdLine, int nCmdShow) : TApplication(AName, hInstance,
	hPrevInstance, lpCmdLine, nCmdShow){}
	virtual void InitMainWindow();
};

/*
Derived Window class for Koch snowflake
*/
class TLeesWin : public TWindow{
	poly_vertex *first, *last;
public:
	TLeesWin(PTWindowsObject AParent, LPSTR ATitle)
	: TWindow(AParent, ATitle){
		first = last = NULL;
	}

	/*
	This function gets called to display graphics in the window
	*/
	virtual void Paint(HDC hDC, PAINTSTRUCT&);
	virtual void WMLButtonDown(TMessage&) = [WM_FIRST + WM_LBUTTONDOWN];
	virtual void WMRButtonDown(TMessage&) = [WM_FIRST + WM_RBUTTONDOWN];

};

/*
Left button down function
*/
void TLeesWin::WMLButtonDown(TMessage& Msg)
{
	poly_vertex *p;
	int mx, my;
	HDC s = GetDC(HWindow);

	/* get the mouse coordinates */
	mx = Msg.LP.Lo;
	my = Msg.LP.Hi;

	cout << mx << " , " << my << "\n";
	if(first != NULL){
		if(last->next == first){
			cout << "Polygon is complete\n";
			ReleaseDC(HWindow, s);
			return;
		}
	}

	/* add a vertex */
	if(first == NULL){
		p = new poly_vertex;
		first = last = p;
		p->x = mx;
		p->y = my;
		p->next = NULL;
        }
	else if((abs(first->x - mx) + abs(first->y - my)) < 10){
		last->next = first;
		MoveTo(s, last->x, last->y);
		LineTo(s, first->x, first->y);
	}
	else{
		p = new poly_vertex;
		last->next = p;
		p->x = mx;
		p->y = my;
		p->next = NULL;
		MoveTo(s, last->x, last->y);
		LineTo(s, mx, my);
                last = p;
        }

	ReleaseDC(HWindow, s);
}

double insert(HDC s, poly_vertex *z1, poly_vertex *z2)
{
        poly_vertex *p, *q;
	double ct, st, temp, deltax, deltay, r, x1, y1, x2, y2, x3, y3;

	/* segment angle */
	deltax = (double)(z2->x - z1->x);
	deltay = (double)(z2->y - z1->y);

	/* segment distance */
	r = sqrt(deltay*deltay + deltax*deltax);
	if(r < 3.0)return(r);
	ct = deltax/r;
	st = deltay/r;

        /* New coordinates on the horizontal */
	x1 = r/3.0;
	x2 = 2.0*r/3.0;
	x3 = r/2.0;
	y3 = -sqrt(3.0)*r/6.0;

	/* rotate */
	y1 = x1*st;
	x1 = x1*ct;
	y2 = x2*st;
	x2 = x2*ct;
	temp = x3*st + y3*ct;
	x3 = x3*ct - y3*st;
	y3 = temp;

	/* translate */
	x1 = x1 + (double)z1->x;
	y1 = y1 + (double)z1->y;
	x2 = x2 + (double)z1->x;
	y2 = y2 + (double)z1->y;
	x3 = x3 + (double)z1->x;
	y3 = y3 + (double)z1->y;

	/* erase the old segment */
	SelectObject(s, GetStockObject(WHITE_PEN));
	MoveTo(s, z1->x, z1->y);
	LineTo(s, z2->x, z2->y);
	SelectObject(s, GetStockObject(BLACK_PEN));

	/* insert a new vertices */
	MoveTo(s, z1->x, z1->y);
	p = new poly_vertex;
	z1->next = p;
	p->x = (int)x1;
	p->y = (int)y1;
        LineTo(s, p->x, p->y);
	q = new poly_vertex;
	p->next = q;
	q->x = (int)x3;
	q->y = (int)y3;
        LineTo(s, q->x, q->y);
	p = new poly_vertex;
	q->next = p;
	p->x = (int)x2;
	p->y = (int)y2;
        LineTo(s, p->x, p->y);
	p->next = z2;

	return(r/3.0);
}

/*
Construct a Koch snowflake
*/
void TLeesWin::WMRButtonDown(TMessage&)
{
	poly_vertex *p, *nextp;
	double r, maxr;
	HDC s = GetDC(HWindow);

	if(last->next != first){
		cout << "Polygon is not complete!\n";
		ReleaseDC(HWindow, s);
		return;
	}

	/* iterate along the polygon until the segment length becomes small */
	do{

		/* sweep along the polygon inserting triangles */
		maxr = 0.0;
		p = first;
		do{

                     nextp = p->next;
		     r = insert(s, p, nextp);
		     if(r > maxr)maxr = r;
		     p = nextp;
		     	
                }while(p != first);
		cout << "maximum segment length = " << maxr << "\n";

	}while(maxr > 3.0);

	ReleaseDC(HWindow, s);
}

/*
get screen info
*/
void TLeesWin::Paint(HDC hDC, PAINTSTRUCT&)
{
	/* get the screen size */
	width=GetDeviceCaps(hDC, HORZRES);
	height=GetDeviceCaps(hDC, VERTRES);
	cout << "Screen width = " << width << "\n";
	cout << "Screen height = " << height << "\n";
	SelectObject(hDC, GetStockObject(BLACK_PEN));

}

/*
Windows application code goes here
*/
void TLeesWinAppl::InitMainWindow()
{
	double segment_size;
	TLeesWin *leeswinp;

	leeswinp=new TLeesWin(NULL, "Lee's Graphics Window");		   // Create a new window
	MainWindow=leeswinp;

}

/*
Main window routine
*/
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
			LPSTR lpCmdLine, int nCmdShow)
{
	TLeesWinAppl LeesAppl("Lees Window Application", hInstance,
	hPrevInstance, lpCmdLine, nCmdShow);

	_InitEasyWin();		       // Enable DOS I/O for the window

	randomize();

	cout << "Use the mouse to define the initial polygon\n";

        LeesAppl.Run();			// Run the Windows application
	return LeesAppl.Status;
}
