/*
Life cellular automata simulation
Lee F. Holeva
12/6/93
*/
// display a DOS window
#define WIN31
#define TEXTBUFSIZE 100
#include <owl.h>
#include <stdlib.h>
#include <conio.h>
#include <iostream.h>
#define MAX_WIDTH 500
#define MAX_HEIGHT 500

#pragma argsused

double thresh;				// intiialization threshold
int num_iter;				// number of iterations
int sx, sy;				// horizontal and vertical screen scale factors

/*
functions for the LIFE algorithm
*/
void initialize(HDC, int , int);
unsigned char read_bit(HDC , int , int );
void write_bit(HDC, int, int, unsigned char);

/*
Derived Window application class
*/
class TLeesWinAppl : public TApplication{
public:
	TLeesWinAppl(LPSTR AName, HANDLE hInstance, HANDLE hPrevInstance,
	LPSTR lpCmdLine, int nCmdShow) : TApplication(AName, hInstance,
	hPrevInstance, lpCmdLine, nCmdShow){}
	virtual void InitMainWindow();
};

/*
Derived Window class
*/
class TLeesWin : public TWindow{
public:
	TLeesWin(PTWindowsObject AParent, LPSTR ATitle)
	: TWindow(AParent, ATitle){}

	/*
	This function gets called to display graphics in the window
	*/
	virtual void Paint(HDC hDC, PAINTSTRUCT&);

};

/*
Row buffer class for the LIFE simulation
*/
class history{
	unsigned char *buf[2];			// Pointers to a pair of rows
public:
	history(int w);				// constructor

	void update(HDC s, int x, int y, int w, int h);
	void display_last(HDC s, int w, int h);
};

/*
Bit access functions
*/
unsigned char read_bit(HDC s, int x, int y)
{
	if(GetPixel(s, sx*x + sx/2, sy*y + sy/2) == RGB(0, 0, 0))return(1);
	return(0);
}
void write_bit(HDC s, int x, int y, unsigned char val)
{
	RECT rect;

	rect.left = sx*x;
	rect.top = sy*y;
	rect.right = sx*(x + 1);
	rect.bottom = sy*(y + 1);

	if(val == 1)
		FillRect(s, &rect, GetStockObject(BLACK_BRUSH));
	else
		FillRect(s, &rect, GetStockObject(WHITE_BRUSH));
}
/*
Routine to initialize the screen
*/
void initialize(HDC s,int w, int h)
{
	int i,j;
	double z;

	for(i=0;i<h;i++){
		for(j=0;j<w;j++){

		     z = (double)random(RAND_MAX)/(double)RAND_MAX;
		     if(z < thresh)write_bit(s, j, i, 0);
		     else write_bit(s, j, i, 1);
		}
	}
}

history::history(int w)
{
	int i, j;

	buf[0] = new unsigned char[w];
	buf[1] = new unsigned char[w];
	for(i=0;i<2;i++)
		for(j=0;j<w;j++)
                	buf[i][j] = 0xFF;
}

void history::update(HDC s,int x, int y, int w, int h)
{
	int i,j,l,k;
	unsigned char sum, label;

	/*
	Sum the current screen labels over a 3x3 neighborhood
	*/
	sum = 0;
	for(i= -1;i<=1;i++){
		k = y + i;
		if(k < 0)k = h-1;
		if(k > h-1)k = 0;
		for(j= -1;j<=1;j++){
			l = x + j;
			if(l < 0)l = w-1;
			if(l > w-1)l = 0;
			if(i != 0 || j != 0)sum+=read_bit(s, l, k);
		}
	}

	/* Update rules */
	if(read_bit(s, x, y) == 1){
		if(sum == 2 || sum == 3)label = 1;
		else label = 0;
	}
	else{
		if(sum == 3)label = 1;
		else label = 0;
	}

	/* update the row buffers */
	k = y - 2;
	if(k == -2)k = h - 2;
        if(k == -1)k = h - 1;
	if(buf[0][x] != 0xFF)write_bit(s, x, y-2, buf[0][x]);
	buf[0][x] = buf[1][x];
        buf[1][x] = label;

}

void history::display_last(HDC s, int w, int h)
{
	int j;

	for(j=0;j<w;j++){
		write_bit(s, j, h - 2, buf[0][j]);
		write_bit(s, j, h - 1, buf[1][j]);
	}
}

/*
Graphics code goes here:
LIFE cellular automata demo
*/
void TLeesWin::Paint(HDC hDC, PAINTSTRUCT&)
{
	int i,j,k,width,height;

	/* get the screen size */
	width=GetDeviceCaps(hDC, HORZRES);
	height=GetDeviceCaps(hDC, VERTRES);
	cout << "Screen width = " << width << "\n";
	cout << "Screen height = " << height << "\n";
	history past = history(width/sx);

	/* initialize the screen */
	initialize(hDC, width/sx, height/sy);

	/* do num_iter cycles */
	for(k=0;k<num_iter;k++){

		for(i=0;i<height/sy;i++)
			for(j=0;j<width/sx;j++)
				past.update(hDC, j, i, width/sx, height/sy);
		if(kbhit())break;
	}
	/* display the last two rows */
	past.display_last(hDC, width/sx, height/sy);
}

/*
Windows application code goes here
*/
void TLeesWinAppl::InitMainWindow()
{
	TLeesWin *leeswinp;

	leeswinp=new TLeesWin(NULL, "Lee's Graphics Window");			// Create a new window
	MainWindow=leeswinp;

}

/*
Main window routine
*/
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
			LPSTR lpCmdLine, int nCmdShow)
{

	TLeesWinAppl LeesAppl("Lees Window Application", hInstance,
	hPrevInstance, lpCmdLine, nCmdShow);

	_InitEasyWin();		       // Enable DOS I/O for the window

	randomize();
	/* get the initialization threshold */
	cout << "Initialization threshold = ";
	cin >> thresh;
	cout << "Number of iterations = ";
	cin >> num_iter;
	cout << "horizontal screen scale factor (1 or something divisable by 2) = ";
	cin >> sx;
	cout << "vertical screen scale factor (1 or something divisable by 2) = ";
	cin >> sy;

        LeesAppl.Run();			// Run the Windows application
	return LeesAppl.Status;
}
